/*
 * Decompiled with CFR 0.152.
 */
package ignis.bubblechat.mixins;

import ignis.bubblechat.animations.AnimatedTextRendererV8;
import ignis.bubblechat.animations.AnimationTokens;
import ignis.bubblechat.animations.GuardRuntime;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_327.class}, priority=9999)
public class TextRendererAnimationMixin {
    @Unique
    private static boolean isInputField(float y) {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_22683() == null) {
            return false;
        }
        int windowHeight = client.method_22683().method_4502();
        return y < 20.0f || y > (float)windowHeight * 0.95f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"draw(Ljava/lang/String;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;ZII)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDrawString(String text, float x, float y, int color, boolean shadow, Matrix4f matrix, class_4597 vertexConsumers, boolean seeThrough, int backgroundColor, int light, CallbackInfoReturnable<Integer> cir) {
        if (text == null || text.isEmpty()) {
            return;
        }
        if (GuardRuntime.isGuarded()) {
            return;
        }
        if (TextRendererAnimationMixin.isInputField(y)) {
            return;
        }
        if (!AnimationTokens.shouldAnimate(text)) {
            return;
        }
        boolean prev = GuardRuntime.beginGuard();
        try {
            int width = AnimatedTextRendererV8.drawAnimated((class_327)this, matrix, vertexConsumers, seeThrough, light, text, x, y, color, shadow, backgroundColor);
            if (vertexConsumers instanceof class_4597.class_4598) {
                ((class_4597.class_4598)vertexConsumers).method_22993();
            }
            cir.setReturnValue((Object)width);
        }
        finally {
            GuardRuntime.endGuard(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"draw(Lnet/minecraft/text/Text;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;ZII)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDrawText(class_2561 text, float x, float y, int color, boolean shadow, Matrix4f matrix, class_4597 vertexConsumers, boolean seeThrough, int backgroundColor, int light, CallbackInfoReturnable<Integer> cir) {
        StackTraceElement[] stack;
        if (text == null) {
            return;
        }
        if (GuardRuntime.isGuarded()) {
            return;
        }
        String str = text.getString();
        if (TextRendererAnimationMixin.isInputField(y)) {
            return;
        }
        if (!AnimationTokens.shouldAnimate(str)) {
            return;
        }
        boolean isAdvancedChat = false;
        for (StackTraceElement element : stack = Thread.currentThread().getStackTrace()) {
            String className = element.getClassName().toLowerCase();
            if (!className.contains("advancedchat") && !className.contains("darkkronicle")) continue;
            isAdvancedChat = true;
            break;
        }
        boolean prev = GuardRuntime.beginGuard();
        try {
            int bgColor = isAdvancedChat ? backgroundColor : 0;
            int width = AnimatedTextRendererV8.drawAnimated((class_327)this, matrix, vertexConsumers, seeThrough, light, str, x, y, color, shadow, bgColor);
            if (vertexConsumers instanceof class_4597.class_4598) {
                ((class_4597.class_4598)vertexConsumers).method_22993();
            }
            cir.setReturnValue((Object)width);
        }
        finally {
            GuardRuntime.endGuard(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"drawWithShadow(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/text/Text;FFI)I"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void onDrawWithShadowText(class_4587 matrices, class_2561 text, float x, float y, int color, CallbackInfoReturnable<Integer> cir) {
        String screenClass;
        if (text == null) {
            return;
        }
        if (GuardRuntime.isGuarded()) {
            return;
        }
        if (TextRendererAnimationMixin.isInputField(y)) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1755 != null && (screenClass = client.field_1755.getClass().getName().toLowerCase()).contains("chat") && y > (float)(client.method_22683().method_4502() - 50)) {
            return;
        }
        String str = text.getString();
        if (str.contains("w") || str.contains("&") || str.contains("\u00a7") || str.contains("test")) {
            System.out.println("[DEBUG onDrawWithShadow ALL] str='" + str.replace('\u00a7', '&') + "', color=0x" + Integer.toHexString(color));
        }
        if (!AnimationTokens.shouldAnimate(str)) {
            return;
        }
        boolean prev = GuardRuntime.beginGuard();
        try {
            class_4597.class_4598 immediate = client.method_22940().method_23000();
            Matrix4f matrix = matrices.method_23760().method_23761();
            int width = AnimatedTextRendererV8.drawAnimated((class_327)this, matrix, (class_4597)immediate, false, 0xF000F0, str, x, y, color, true, 0);
            cir.setReturnValue((Object)width);
        }
        finally {
            GuardRuntime.endGuard(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"drawWithShadow(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/text/OrderedText;FFI)I"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void onDrawWithShadowOrdered(class_4587 matrices, class_5481 text, float x, float y, int color, CallbackInfoReturnable<Integer> cir) {
        if (text == null) {
            return;
        }
        if (GuardRuntime.isGuarded()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList colors = new ArrayList();
        ArrayList positions = new ArrayList();
        text.accept((index, style, codePoint) -> {
            if (style != null && style.method_10973() != null) {
                int styleColor = style.method_10973().method_27716();
                if (!colors.isEmpty() && (Integer)colors.get(colors.size() - 1) != styleColor) {
                    colors.add(styleColor);
                    positions.add(sb.length());
                } else if (colors.isEmpty()) {
                    colors.add(styleColor);
                    positions.add(0);
                }
            }
            sb.appendCodePoint(codePoint);
            return true;
        });
        String str = sb.toString();
        if (TextRendererAnimationMixin.isInputField(y)) {
            return;
        }
        if (!colors.isEmpty() && AnimationTokens.containsAnimationCodes(str)) {
            StringBuilder reconstructed = new StringBuilder();
            int lastPos = 0;
            for (int i = 0; i < colors.size(); ++i) {
                int colorValue = (Integer)colors.get(i);
                int pos = (Integer)positions.get(i);
                if (pos > lastPos) {
                    reconstructed.append(str.substring(lastPos, pos));
                }
                char colorCode = TextRendererAnimationMixin.rgbToMinecraftColor(colorValue);
                reconstructed.append("\u00a7").append(colorCode);
                lastPos = pos;
            }
            if (lastPos < str.length()) {
                reconstructed.append(str.substring(lastPos));
            }
            str = reconstructed.toString();
        }
        if (!AnimationTokens.shouldAnimate(str)) {
            return;
        }
        boolean prev = GuardRuntime.beginGuard();
        try {
            class_310 client = class_310.method_1551();
            class_4597.class_4598 immediate = client.method_22940().method_23000();
            Matrix4f matrix = matrices.method_23760().method_23761();
            int width = AnimatedTextRendererV8.drawAnimated((class_327)this, matrix, (class_4597)immediate, false, 0xF000F0, str, x, y, color, true, 0);
            immediate.method_22993();
            cir.setReturnValue((Object)width);
        }
        finally {
            GuardRuntime.endGuard(prev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"draw(Lnet/minecraft/text/OrderedText;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;ZII)I"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void onDrawOrdered(class_5481 text, float x, float y, int color, boolean shadow, Matrix4f matrix, class_4597 vertexConsumers, boolean seeThrough, int backgroundColor, int light, CallbackInfoReturnable<Integer> cir) {
        if (text == null) {
            return;
        }
        if (GuardRuntime.isGuarded()) {
            return;
        }
        if (TextRendererAnimationMixin.isInputField(y)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList colors = new ArrayList();
        ArrayList positions = new ArrayList();
        text.accept((index, style, codePoint) -> {
            if (style != null && style.method_10973() != null) {
                int styleColor = style.method_10973().method_27716();
                if (!colors.isEmpty() && (Integer)colors.get(colors.size() - 1) != styleColor) {
                    colors.add(styleColor);
                    positions.add(sb.length());
                } else if (colors.isEmpty()) {
                    colors.add(styleColor);
                    positions.add(0);
                }
            }
            sb.appendCodePoint(codePoint);
            return true;
        });
        String str = sb.toString();
        if (!colors.isEmpty()) {
            StringBuilder reconstructed = new StringBuilder();
            int lastPos = 0;
            for (int i = 0; i < colors.size(); ++i) {
                int colorValue = (Integer)colors.get(i);
                int pos = (Integer)positions.get(i);
                if (pos > lastPos) {
                    reconstructed.append(str, lastPos, pos);
                }
                char colorCode = TextRendererAnimationMixin.rgbToMinecraftColor(colorValue);
                reconstructed.append("\u00a7").append(colorCode);
                lastPos = pos;
            }
            if (lastPos < str.length()) {
                reconstructed.append(str.substring(lastPos));
            }
            str = reconstructed.toString();
        }
        if (AnimationTokens.containsAnimationCodes(str)) {
            boolean prev = GuardRuntime.beginGuard();
            try {
                int width = AnimatedTextRendererV8.drawAnimated((class_327)this, matrix, vertexConsumers, seeThrough, light, str, x, y, color, shadow, 0);
                if (vertexConsumers instanceof class_4597.class_4598) {
                    ((class_4597.class_4598)vertexConsumers).method_22993();
                }
                cir.setReturnValue((Object)width);
            }
            finally {
                GuardRuntime.endGuard(prev);
            }
        }
    }

    @Unique
    private static char rgbToMinecraftColor(int rgb) {
        int[][] mcColors = new int[][]{{0, 48}, {170, 49}, {43520, 50}, {43690, 51}, {0xAA0000, 52}, {0xAA00AA, 53}, {0xFFAA00, 54}, {0xAAAAAA, 55}, {0x555555, 56}, {0x5555FF, 57}, {0x55FF55, 97}, {0x55FFFF, 98}, {0xFF5555, 99}, {0xFF55FF, 100}, {0xFFFF55, 101}, {0xFFFFFF, 102}};
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        char closest = 'f';
        int minDistance = Integer.MAX_VALUE;
        for (int[] mcColor : mcColors) {
            int mcRgb = mcColor[0];
            int mcR = mcRgb >> 16 & 0xFF;
            int mcG = mcRgb >> 8 & 0xFF;
            int mcB = mcRgb & 0xFF;
            int distance = (r - mcR) * (r - mcR) + (g - mcG) * (g - mcG) + (b - mcB) * (b - mcB);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closest = (char)mcColor[1];
        }
        return closest;
    }
}

