/*
 * Decompiled with CFR 0.152.
 */
package ignis.bubblechat.mixins;

import ignis.bubblechat.BubbleChat;
import ignis.bubblechat.packets.ChatPacket;
import ignis.bubblechat.renders.BubbleChatRender;
import ignis.bubblechat.rpchat.RPChat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_897.class})
public abstract class EntityRendererMixin<T extends class_1297> {
    @Shadow
    @Final
    protected class_898 field_4676;
    private static final Map<UUID, Integer> typingTicksMap = new HashMap<UUID, Integer>();

    @Shadow
    public abstract class_327 method_3932();

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=false)
    public void renderLabelIfPresent(@NonNull T entity, float yaw, float tickDelta, @NonNull class_4587 matrices, @NonNull class_4597 vertexConsumers, int light, @NonNull CallbackInfo callbackInfo) {
        if (matrices == null) {
            throw new NullPointerException("matrices is marked non-null but is null");
        }
        if (vertexConsumers == null) {
            throw new NullPointerException("vertexConsumers is marked non-null but is null");
        }
        if (callbackInfo == null) {
            throw new NullPointerException("callbackInfo is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (matrices == null) {
            throw new NullPointerException("matrices is marked non-null but is null");
        }
        if (vertexConsumers == null) {
            throw new NullPointerException("vertexConsumers is marked non-null but is null");
        }
        if (callbackInfo == null) {
            throw new NullPointerException("callbackInfo is marked non-null but is null");
        }
        if (entity instanceof class_1309) {
            BubbleChatRender bubbleChatRender;
            UUID uuid;
            Map<UUID, BubbleChatRender> bubbleChatRenders = BubbleChat.getBubbleChatRenders();
            Map<UUID, ChatPacket> chatPackets = BubbleChat.getChatPackets();
            ChatPacket packet = chatPackets.get(uuid = entity.method_5667());
            if (packet != null) {
                if (!bubbleChatRenders.containsKey(uuid)) {
                    bubbleChatRenders.put(uuid, new BubbleChatRender(packet.getMessages(), this.field_4676, this.method_3932(), (class_1297)entity));
                } else {
                    bubbleChatRender = bubbleChatRenders.get(uuid);
                    bubbleChatRender.updateMessages(packet.getMessages(), (class_1297)entity);
                }
                chatPackets.remove(uuid);
            }
            if (bubbleChatRenders.containsKey(uuid)) {
                bubbleChatRender = bubbleChatRenders.get(uuid);
                bubbleChatRender.render((class_1297)entity, matrices, vertexConsumers, light);
                if (bubbleChatRender.isRendered()) {
                    bubbleChatRenders.remove(uuid);
                }
            }
            if (!(entity instanceof class_1657) && RPChat.getChatsOpened().getOrDefault(uuid, false).booleanValue()) {
                this.renderTypingDots((class_1297)entity, uuid, matrices, vertexConsumers, light);
            }
        }
    }

    private void renderTypingDots(class_1297 entity, UUID uuid, class_4587 matrices, class_4597 vertexConsumers, int light) {
        String message;
        if (class_310.method_1551().field_1690.field_1842) {
            return;
        }
        int tick = typingTicksMap.getOrDefault(uuid, 0) + 1;
        typingTicksMap.put(uuid, tick);
        if (tick <= 80) {
            message = "\u00a77 . ";
        } else if (tick <= 160) {
            message = "\u00a77 . . ";
        } else {
            if (tick > 240) {
                typingTicksMap.put(uuid, 0);
                return;
            }
            message = "\u00a77 . . . ";
        }
        matrices.method_22903();
        matrices.method_22904(0.0, (double)entity.method_17682() + 0.5, 0.0);
        matrices.method_22907(this.field_4676.method_24197());
        matrices.method_22905(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_327 textRenderer = this.method_3932();
        class_5250 text = class_2561.method_43470((String)message);
        int width = textRenderer.method_27525((class_5348)text);
        int x = -width / 2;
        float opacity = class_310.method_1551().field_1690.method_19343(0.25f);
        int backgroundColor = (int)(opacity * 255.0f) << 24;
        textRenderer.method_30882((class_2561)text, (float)x, 0.0f, 0xFFFFFF, false, matrix, vertexConsumers, false, backgroundColor, light);
        matrices.method_22909();
    }
}

