/*
 * Decompiled with CFR 0.152.
 */
package ignis.bubblechat.logger;

import ignis.bubblechat.packets.ChatPacket;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ChatLogger {
    private static final DateTimeFormatter FOLDER_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static File logFile = null;
    private static BufferedWriter writer = null;
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        try {
            class_310 client = class_310.method_1551();
            File gameDir = client.field_1697;
            File logsDir = new File(gameDir, "\u041b\u043e\u0433\u0438 \u0434\u043b\u044f \u0421\u0421");
            if (!logsDir.exists()) {
                logsDir.mkdirs();
            }
            String timestamp = LocalDateTime.now().format(FOLDER_FORMAT);
            logFile = new File(logsDir, timestamp + ".txt");
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile, true), StandardCharsets.UTF_8));
            initialized = true;
            System.out.println("[ChatLogger] \u041b\u043e\u0433 \u0444\u0430\u0439\u043b \u0441\u043e\u0437\u0434\u0430\u043d: " + logFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("[ChatLogger] \u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043b\u043e\u0433 \u0444\u0430\u0439\u043b\u0430: " + e.getMessage());
        }
    }

    public static void logMessage(String message) {
        if (!initialized || writer == null) {
            return;
        }
        if (!ChatLogger.isVotiveChatMessage(message)) {
            return;
        }
        try {
            String timestamp = LocalDateTime.now().format(TIME_FORMAT);
            String logLine = String.format("[%s] %s", timestamp, ChatLogger.stripFormatting(message));
            writer.write(logLine);
            writer.newLine();
            writer.flush();
        }
        catch (IOException e) {
            System.err.println("[ChatLogger] \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u043b\u043e\u0433: " + e.getMessage());
        }
    }

    public static void logMessage(class_2561 text) {
        if (text != null) {
            ChatLogger.logMessage(text.getString());
        }
    }

    public static void logBubbleChatPacket(ChatPacket packet) {
        if (!initialized || writer == null || packet == null) {
            return;
        }
        try {
            String timestamp = LocalDateTime.now().format(TIME_FORMAT);
            ArrayList<String> messagesCopy = new ArrayList<String>(packet.getMessages());
            for (String message : messagesCopy) {
                if (message == null || message.isEmpty()) continue;
                String logLine = String.format("[%s] %s", timestamp, ChatLogger.stripFormatting(message));
                writer.write(logLine);
                writer.newLine();
                writer.flush();
            }
        }
        catch (IOException e) {
            System.err.println("[ChatLogger] \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u043b\u043e\u0433: " + e.getMessage());
        }
    }

    private static boolean isVotiveChatMessage(String message) {
        int colonIndex;
        String clean = ChatLogger.stripFormatting(message).trim();
        if (clean.startsWith("Current ") || clean.startsWith("Brush ") || clean.startsWith("Performer ") || clean.startsWith("Voxel ") || clean.startsWith("Tool ") || clean.contains("VoxelSniper") || clean.contains("WorldEdit") || clean.isEmpty()) {
            return false;
        }
        if (message.contains("((DO))") || message.contains("((ME))") || message.contains("((TRY))") || message.contains("((TODO))") || message.contains("((LAD))") || message.contains("((AD))")) {
            return true;
        }
        return !message.startsWith("[") && message.contains(": ") && (colonIndex = message.indexOf(": ")) > 0 && colonIndex < 50;
    }

    private static String stripFormatting(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if ((ch == '\u00a7' || ch == '&') && i + 1 < text.length()) {
                ++i;
                continue;
            }
            if (ch == '\u200b' || ch == '\u200c') continue;
            result.append(ch);
        }
        return result.toString();
    }

    public static void close() {
        if (writer != null) {
            try {
                writer.close();
                System.out.println("[ChatLogger] \u041b\u043e\u0433 \u0444\u0430\u0439\u043b \u0437\u0430\u043a\u0440\u044b\u0442: " + logFile.getName());
            }
            catch (IOException e) {
                System.err.println("[ChatLogger] \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043b\u043e\u0433 \u0444\u0430\u0439\u043b\u0430: " + e.getMessage());
            }
        }
        writer = null;
        logFile = null;
        initialized = false;
    }
}

