/*
 * Decompiled with CFR 0.152.
 */
package ignis.bubblechat.animations;

public final class AnimationTokens {
    private AnimationTokens() {
    }

    public static boolean shouldAnimate(String raw) {
        int j;
        int i;
        if (raw == null || raw.isEmpty()) {
            return false;
        }
        for (i = 0; i < raw.length() - 1; ++i) {
            char code;
            char c = raw.charAt(i);
            if (c != '&' && c != '\u00a7' || !AnimationTokens.isAnimationCode(code = Character.toLowerCase(raw.charAt(i + 1)))) continue;
            return true;
        }
        i = 0;
        while ((i = raw.indexOf(60, i)) >= 0 && (j = raw.indexOf(62, i + 1)) >= 0) {
            String inside = raw.substring(i + 1, j).trim();
            boolean isClose = inside.startsWith("/");
            String namePayload = isClose ? inside.substring(1).trim() : inside;
            int colon = namePayload.indexOf(58);
            String name = (colon >= 0 ? namePayload.substring(0, colon) : namePayload).trim().toLowerCase();
            if (AnimationTokens.isKnownTag(name)) {
                return true;
            }
            i = j + 1;
        }
        return false;
    }

    private static boolean isAnimationCode(char code) {
        return code == 'j' || code == 'h' || code == 'p' || code == 'w' || code == 'g' || code == 'z' || code == 'v' || code == 's' || code == 'y' || code == 'q' || code == '+' || code == 'i' || code == 't' || code == '=' || code == 'u' || code == '!' || code == '*' || code == 'x' || code == '-';
    }

    private static boolean isKnownTag(String name) {
        return name.equals("rainbow") || name.equals("pulse") || name.equals("highlight") || name.equals("gradient") || name.equals("shimmer") || name.equals("vibrate") || name.equals("wiggle") || name.equals("bounce") || name.equals("sparkle") || name.equals("flame") || name.equals("ice") || name.equals("magic_glow") || name.equals("divine") || name.equals("typewriter") || name.equals("fade") || name.equals("unravel") || name.equals("shake") || name.equals("glitch") || name.equals("drip") || name.equals("whisper");
    }

    public static boolean containsAnimationCodes(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        if (AnimationTokens.shouldAnimate(text)) {
            return true;
        }
        return text.contains("wiggle") || text.contains("rainbow") || text.contains("pulse") || text.contains("shimmer") || text.contains("vibrate") || text.contains("bounce") || text.contains("sparkle") || text.contains("flame") || text.contains("ice") || text.contains("magic_glow") || text.contains("divine") || text.contains("typewriter") || text.contains("fade") || text.contains("unravel") || text.contains("shake") || text.contains("glitch") || text.contains("drip") || text.contains("whisper") || text.contains("gradient") || text.contains("\u2764") || text.contains("\u2728") || text.contains("\u2606");
    }
}

