/*
 * Decompiled with CFR 0.152.
 */
package ignis.bubblechat.animations;

import ignis.bubblechat.animations.GuardRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_327;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

public class AnimatedTextRendererV8 {
    private static final Map<Character, Integer> VANILLA_COLORS = new HashMap<Character, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int drawAnimated(class_327 tr, Matrix4f matrix, class_4597 vertices, boolean seeThrough, int light, String raw, float x, float y, int fallbackColor, boolean shadow, int backgroundColor) {
        if (raw == null || raw.isEmpty()) {
            return 0;
        }
        List<TextSegment> segments = AnimatedTextRendererV8.parseText(raw);
        long nowMs = class_156.method_658();
        float cursor = x;
        int charIndex = 0;
        boolean wasGuarded = GuardRuntime.isGuarded();
        if (!wasGuarded) {
            GuardRuntime.beginGuard();
        }
        try {
            for (TextSegment segment : segments) {
                if (segment.text.isEmpty()) continue;
                for (int i = 0; i < segment.text.length(); ++i) {
                    int color;
                    float time;
                    float glitchChance;
                    float time2;
                    float unravelProgress;
                    float time3;
                    float time4;
                    char c = segment.text.charAt(i);
                    String charStr = String.valueOf(c);
                    float dx = 0.0f;
                    float dy = 0.0f;
                    if (segment.wiggle) {
                        time4 = (float)nowMs * 0.001f;
                        dy = (float)Math.sin(time4 * 8.0f + (float)charIndex * 0.5f) * 1.5f;
                        dx = (float)Math.cos(time4 * 5.6f + (float)charIndex * 0.3f) * 0.5f;
                    }
                    if (segment.vibrate) {
                        time4 = (float)nowMs * 0.001f;
                        dx += (float)Math.sin(time4 * 15.0f + (float)charIndex * 1.7f) * 0.8f;
                        dy += (float)Math.cos(time4 * 15.0f + (float)charIndex * 2.3f) * 0.5f;
                    }
                    if (segment.shake) {
                        time4 = (float)nowMs * 0.001f;
                        dx += (float)Math.sin(time4 * 25.0f + (float)charIndex * 2.5f) * 2.0f;
                        dy += (float)Math.cos(time4 * 25.0f + (float)charIndex * 3.1f) * 1.5f;
                    }
                    if (segment.flame) {
                        time4 = (float)nowMs * 0.001f;
                        dy += (float)Math.sin(time4 * 10.0f + (float)charIndex * 0.7f) * 2.0f - 0.5f;
                        dx += (float)Math.sin(time4 * 8.0f + (float)charIndex * 0.9f) * 0.8f;
                    }
                    if (segment.sparkle) {
                        time4 = (float)nowMs * 0.001f;
                        float sparkle = (float)(Math.sin(time4 * 20.0f + (float)charIndex * 1.3f) * Math.cos(time4 * 17.0f + (float)charIndex * 0.8f));
                        dx += sparkle * 0.6f;
                        dy += sparkle * 0.4f;
                    }
                    if (segment.drip) {
                        int level = charIndex % 3;
                        dy += (float)level * 1.5f;
                        time3 = (float)nowMs * 0.001f;
                        dy += (float)Math.sin(time3 * 2.0f + (float)charIndex * 0.5f) * 0.2f;
                    }
                    if (segment.unravel && (unravelProgress = Math.min(1.0f, ((time2 = (float)nowMs * 0.001f) - (float)charIndex * 0.05f) % 2.0f)) < 0.5f) {
                        dx += (1.0f - unravelProgress * 2.0f) * 10.0f;
                    }
                    if (segment.glitch && (glitchChance = (float)Math.sin((time = (float)nowMs * 0.001f) * 30.0f + (float)charIndex * 5.0f)) > 0.8f) {
                        dx += (float)(Math.random() * 4.0 - 2.0);
                        dy += (float)(Math.random() * 4.0 - 2.0);
                    }
                    if (segment.rainbow) {
                        time3 = (float)(nowMs % 1000000L) / 1000.0f;
                        float hue = (time3 * 0.2f + (float)charIndex * 0.1f) % 1.0f;
                        color = AnimatedTextRendererV8.hsbToRgb(hue, 1.0f, 1.0f);
                    } else if (segment.gradient && segment.gradientStart != null && segment.gradientEnd != null) {
                        float progress = (float)charIndex / (float)Math.max(1, segment.text.length() - 1);
                        color = AnimatedTextRendererV8.interpolateColor(segment.gradientStart, segment.gradientEnd, progress);
                    } else {
                        color = segment.color != null ? segment.color : fallbackColor;
                        color = color & 0xFFFFFF | 0xFF000000;
                        if (segment.pulse) {
                            color = AnimatedTextRendererV8.applyPulse(nowMs, color);
                        }
                        if (segment.shimmer) {
                            color = AnimatedTextRendererV8.applyShimmer(nowMs, charIndex, color);
                        }
                        if (segment.ice) {
                            color = AnimatedTextRendererV8.applyIce(nowMs, charIndex, color);
                        }
                        if (segment.magicGlow) {
                            color = AnimatedTextRendererV8.applyMagicGlow(nowMs, charIndex, color);
                        }
                        if (segment.divine) {
                            color = AnimatedTextRendererV8.applyDivine(nowMs, charIndex, color);
                        }
                        if (segment.sparkle) {
                            color = AnimatedTextRendererV8.applySparkle(nowMs, charIndex, color);
                        }
                        if (segment.flame) {
                            color = AnimatedTextRendererV8.applyFlame(nowMs, charIndex, color);
                        }
                        if (segment.fade) {
                            color = AnimatedTextRendererV8.applyFade(nowMs, charIndex, color);
                        }
                        if (segment.whisper) {
                            color = AnimatedTextRendererV8.applyWhisper(nowMs, color);
                        }
                        if (segment.typewriter) {
                            color = AnimatedTextRendererV8.applyTypewriter(nowMs, charIndex, color);
                        }
                        if (segment.glitch) {
                            color = AnimatedTextRendererV8.applyGlitch(nowMs, charIndex, color);
                        }
                    }
                    int charWidth = tr.method_1727(charStr);
                    tr.method_27521(charStr, cursor + dx, y + dy, color, shadow, matrix, vertices, seeThrough, backgroundColor, light);
                    cursor += (float)charWidth;
                    ++charIndex;
                }
            }
            int n = (int)(cursor - x);
            return n;
        }
        finally {
            if (!wasGuarded) {
                GuardRuntime.endGuard(false);
            }
        }
    }

    private static List<TextSegment> parseText(String raw) {
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        TextSegment current = new TextSegment();
        Integer currentColor = null;
        boolean currentRainbow = false;
        boolean currentPulse = false;
        boolean currentWiggle = false;
        boolean currentShimmer = false;
        boolean currentVibrate = false;
        boolean currentSparkle = false;
        boolean currentFlame = false;
        boolean currentIce = false;
        boolean currentMagicGlow = false;
        boolean currentDivine = false;
        boolean currentTypewriter = false;
        boolean currentFade = false;
        boolean currentUnravel = false;
        boolean currentShake = false;
        boolean currentGlitch = false;
        boolean currentDrip = false;
        boolean currentWhisper = false;
        boolean currentGradient = false;
        Integer currentGradientStart = null;
        Integer currentGradientEnd = null;
        for (int i = 0; i < raw.length(); ++i) {
            char ch = raw.charAt(i);
            if (ch == '\u200b' && i + 1 < raw.length() && raw.charAt(i + 1) == '\u200c') {
                if (!current.text.isEmpty()) {
                    segments.add(current);
                    current = new TextSegment();
                }
                currentColor = null;
                currentRainbow = false;
                currentPulse = false;
                currentWiggle = false;
                currentShimmer = false;
                currentVibrate = false;
                currentSparkle = false;
                currentFlame = false;
                currentIce = false;
                currentMagicGlow = false;
                currentDivine = false;
                currentTypewriter = false;
                currentFade = false;
                currentUnravel = false;
                currentShake = false;
                currentGlitch = false;
                currentDrip = false;
                currentWhisper = false;
                currentGradient = false;
                currentGradientStart = null;
                currentGradientEnd = null;
                ++i;
                continue;
            }
            if ((ch == '&' || ch == '\u00a7') && i + 1 < raw.length()) {
                char code = Character.toLowerCase(raw.charAt(i + 1));
                if (code == 'r') {
                    if (!current.text.isEmpty()) {
                        segments.add(current);
                        current = new TextSegment();
                    }
                    currentColor = null;
                    currentRainbow = false;
                    currentPulse = false;
                    currentWiggle = false;
                    currentShimmer = false;
                    currentVibrate = false;
                    currentSparkle = false;
                    currentFlame = false;
                    currentIce = false;
                    currentMagicGlow = false;
                    currentDivine = false;
                    currentTypewriter = false;
                    currentFade = false;
                    currentUnravel = false;
                    currentShake = false;
                    currentGlitch = false;
                    currentDrip = false;
                    currentWhisper = false;
                    currentGradient = false;
                    currentGradientStart = null;
                    currentGradientEnd = null;
                    ++i;
                    continue;
                }
                if (VANILLA_COLORS.containsKey(Character.valueOf(code))) {
                    if (!current.text.isEmpty()) {
                        segments.add(current);
                        current = new TextSegment();
                    }
                    currentColor = VANILLA_COLORS.get(Character.valueOf(code));
                    currentGradient = false;
                    currentGradientStart = null;
                    currentGradientEnd = null;
                    currentRainbow = false;
                    ++i;
                    continue;
                }
                if (code == 'g' && i + 3 < raw.length()) {
                    char nextChar1 = raw.charAt(i + 2);
                    char nextChar2 = raw.charAt(i + 3);
                    if (!(nextChar1 != '&' && nextChar1 != '\u00a7' || i + 4 >= raw.length() || nextChar2 != '&' && nextChar2 != '\u00a7' || i + 5 >= raw.length())) {
                        char colorCode1 = Character.toLowerCase(raw.charAt(i + 3));
                        char colorCode2 = Character.toLowerCase(raw.charAt(i + 5));
                        if (VANILLA_COLORS.containsKey(Character.valueOf(colorCode1)) && VANILLA_COLORS.containsKey(Character.valueOf(colorCode2))) {
                            if (!current.text.isEmpty()) {
                                segments.add(current);
                                current = new TextSegment();
                            }
                            currentGradient = true;
                            currentGradientStart = VANILLA_COLORS.get(Character.valueOf(colorCode1));
                            currentGradientEnd = VANILLA_COLORS.get(Character.valueOf(colorCode2));
                            currentRainbow = false;
                            i += 5;
                            continue;
                        }
                    } else if (VANILLA_COLORS.containsKey(Character.valueOf(nextChar1)) && VANILLA_COLORS.containsKey(Character.valueOf(nextChar2))) {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentGradient = true;
                        currentGradientStart = VANILLA_COLORS.get(Character.valueOf(nextChar1));
                        currentGradientEnd = VANILLA_COLORS.get(Character.valueOf(nextChar2));
                        currentRainbow = false;
                        i += 3;
                        continue;
                    }
                }
                boolean handled = false;
                switch (code) {
                    case 'j': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentRainbow = true;
                        currentPulse = false;
                        currentShimmer = false;
                        handled = true;
                        break;
                    }
                    case 'h': 
                    case 'p': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentPulse = true;
                        currentRainbow = false;
                        handled = true;
                        break;
                    }
                    case 'w': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentWiggle = true;
                        handled = true;
                        break;
                    }
                    case 'z': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentShimmer = true;
                        currentRainbow = false;
                        handled = true;
                        break;
                    }
                    case 'v': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentVibrate = true;
                        handled = true;
                        break;
                    }
                    case 's': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentSparkle = true;
                        handled = true;
                        break;
                    }
                    case 'y': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentFlame = true;
                        handled = true;
                        break;
                    }
                    case 'q': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentIce = true;
                        handled = true;
                        break;
                    }
                    case '+': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentMagicGlow = true;
                        handled = true;
                        break;
                    }
                    case 'i': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentDivine = true;
                        handled = true;
                        break;
                    }
                    case 't': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentTypewriter = true;
                        handled = true;
                        break;
                    }
                    case '=': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentFade = true;
                        handled = true;
                        break;
                    }
                    case 'u': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentUnravel = true;
                        handled = true;
                        break;
                    }
                    case '!': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentShake = true;
                        handled = true;
                        break;
                    }
                    case '*': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentGlitch = true;
                        handled = true;
                        break;
                    }
                    case 'x': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentDrip = true;
                        handled = true;
                        break;
                    }
                    case '-': {
                        if (!current.text.isEmpty()) {
                            segments.add(current);
                            current = new TextSegment();
                        }
                        currentWhisper = true;
                        handled = true;
                    }
                }
                if (handled) {
                    ++i;
                    continue;
                }
            }
            if (ch == '\u200b' || ch == '\u200c') continue;
            if (current.text.isEmpty()) {
                current.color = currentColor;
                current.rainbow = currentRainbow;
                current.pulse = currentPulse;
                current.wiggle = currentWiggle;
                current.shimmer = currentShimmer;
                current.vibrate = currentVibrate;
                current.sparkle = currentSparkle;
                current.flame = currentFlame;
                current.ice = currentIce;
                current.magicGlow = currentMagicGlow;
                current.divine = currentDivine;
                current.typewriter = currentTypewriter;
                current.fade = currentFade;
                current.unravel = currentUnravel;
                current.shake = currentShake;
                current.glitch = currentGlitch;
                current.drip = currentDrip;
                current.whisper = currentWhisper;
                current.gradient = currentGradient;
                current.gradientStart = currentGradientStart;
                current.gradientEnd = currentGradientEnd;
            }
            current.text = current.text + ch;
        }
        if (!current.text.isEmpty()) {
            segments.add(current);
        }
        return segments;
    }

    private static int applyPulse(long ms, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float pulse = 0.6f + 0.4f * (float)Math.sin((double)time * Math.PI * 2.0);
        int r = Math.min(255, (int)((float)(color >> 16 & 0xFF) * pulse));
        int g = Math.min(255, (int)((float)(color >> 8 & 0xFF) * pulse));
        int b = Math.min(255, (int)((float)(color & 0xFF) * pulse));
        int a = color >> 24 & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int applyShimmer(long ms, int index, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float shimmer = 0.7f + 0.3f * (float)Math.sin((double)time * Math.PI * 3.0 + (double)((float)index * 0.5f));
        int r = Math.min(255, (int)((float)(color >> 16 & 0xFF) * shimmer));
        int g = Math.min(255, (int)((float)(color >> 8 & 0xFF) * shimmer));
        int b = Math.min(255, (int)((float)(color & 0xFF) * shimmer));
        int a = color >> 24 & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int hsbToRgb(float h, float s, float b) {
        if ((h %= 1.0f) < 0.0f) {
            h += 1.0f;
        }
        float r = 0.0f;
        float g = 0.0f;
        float bl = 0.0f;
        int i = (int)(h * 6.0f);
        float f = h * 6.0f - (float)i;
        float p = b * (1.0f - s);
        float q = b * (1.0f - s * f);
        float t = b * (1.0f - s * (1.0f - f));
        switch (i % 6) {
            case 0: {
                r = b;
                g = t;
                bl = p;
                break;
            }
            case 1: {
                r = q;
                g = b;
                bl = p;
                break;
            }
            case 2: {
                r = p;
                g = b;
                bl = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                bl = b;
                break;
            }
            case 4: {
                r = t;
                g = p;
                bl = b;
                break;
            }
            case 5: {
                r = b;
                g = p;
                bl = q;
            }
        }
        return (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(bl * 255.0f);
    }

    private static int interpolateColor(int color1, int color2, float progress) {
        progress = Math.max(0.0f, Math.min(1.0f, progress));
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * progress);
        int g = (int)((float)g1 + (float)(g2 - g1) * progress);
        int b = (int)((float)b1 + (float)(b2 - b1) * progress);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int applyIce(long ms, int index, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float shimmer = 0.8f + 0.2f * (float)Math.sin(time * 5.0f + (float)index * 0.8f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, (int)((float)r * shimmer * 0.9f));
        g = Math.min(255, (int)((float)g * shimmer * 0.95f));
        b = Math.min(255, (int)((float)b * shimmer * 1.1f));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int applyMagicGlow(long ms, int index, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float glow = 0.7f + 0.3f * (float)Math.sin(time * 4.0f + (float)index * 0.5f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, (int)((float)r * glow * 1.1f));
        g = Math.min(255, (int)((float)g * glow * 0.9f));
        b = Math.min(255, (int)((float)b * glow * 1.15f));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int applyDivine(long ms, int index, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float glow = 0.85f + 0.15f * (float)Math.sin(time * 2.0f + (float)index * 0.3f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, (int)((float)r * glow * 1.2f));
        g = Math.min(255, (int)((float)g * glow * 1.1f));
        b = Math.min(255, (int)((float)b * glow * 0.8f));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int applySparkle(long ms, int index, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float sparkle = (float)(Math.sin(time * 15.0f + (float)index * 2.0f) * Math.cos(time * 12.0f + (float)index * 1.5f));
        float brightness = sparkle > 0.7f ? 1.3f : 1.0f;
        int r = Math.min(255, (int)((float)(color >> 16 & 0xFF) * brightness));
        int g = Math.min(255, (int)((float)(color >> 8 & 0xFF) * brightness));
        int b = Math.min(255, (int)((float)(color & 0xFF) * brightness));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int applyFlame(long ms, int index, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float flame = 0.7f + 0.3f * (float)Math.sin(time * 8.0f + (float)index * 1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, (int)((float)r * flame * 1.2f));
        g = Math.min(255, (int)((float)g * flame * 0.8f));
        b = Math.min(255, (int)((float)b * flame * 0.5f));
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int applyFade(long ms, int index, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float fade = 0.3f + 0.7f * (float)Math.abs(Math.sin(time * 1.5f + (float)index * 0.2f));
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = (int)((float)r * fade);
        g = (int)((float)g * fade);
        b = (int)((float)b * fade);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int applyWhisper(long ms, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float whisper = 0.3f + 0.1f * (float)Math.sin(time * 3.0f);
        int r = (int)((float)(color >> 16 & 0xFF) * whisper);
        int g = (int)((float)(color >> 8 & 0xFF) * whisper);
        int b = (int)((float)(color & 0xFF) * whisper);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static int applyTypewriter(long ms, int index, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float typeProgress = time * 5.0f % 30.0f;
        if ((float)index > typeProgress) {
            return 0;
        }
        if ((float)index > typeProgress - 1.0f) {
            float alpha = typeProgress - (float)index;
            int r = (int)((float)(color >> 16 & 0xFF) * alpha);
            int g = (int)((float)(color >> 8 & 0xFF) * alpha);
            int b = (int)((float)(color & 0xFF) * alpha);
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        return color;
    }

    private static int applyGlitch(long ms, int index, int color) {
        float time = (float)(ms % 1000000L) / 1000.0f;
        float glitchChance = (float)Math.sin(time * 30.0f + (float)index * 5.0f);
        if (glitchChance > 0.8f) {
            int r = (int)(Math.random() * 255.0);
            int g = (int)(Math.random() * 255.0);
            int b = (int)(Math.random() * 255.0);
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        return color;
    }

    static {
        VANILLA_COLORS.put(Character.valueOf('0'), 0);
        VANILLA_COLORS.put(Character.valueOf('1'), 170);
        VANILLA_COLORS.put(Character.valueOf('2'), 43520);
        VANILLA_COLORS.put(Character.valueOf('3'), 43690);
        VANILLA_COLORS.put(Character.valueOf('4'), 0xAA0000);
        VANILLA_COLORS.put(Character.valueOf('5'), 0xAA00AA);
        VANILLA_COLORS.put(Character.valueOf('6'), 0xFFAA00);
        VANILLA_COLORS.put(Character.valueOf('7'), 0xAAAAAA);
        VANILLA_COLORS.put(Character.valueOf('8'), 0x555555);
        VANILLA_COLORS.put(Character.valueOf('9'), 0x5555FF);
        VANILLA_COLORS.put(Character.valueOf('a'), 0x55FF55);
        VANILLA_COLORS.put(Character.valueOf('b'), 0x55FFFF);
        VANILLA_COLORS.put(Character.valueOf('c'), 0xFF5555);
        VANILLA_COLORS.put(Character.valueOf('d'), 0xFF55FF);
        VANILLA_COLORS.put(Character.valueOf('e'), 0xFFFF55);
        VANILLA_COLORS.put(Character.valueOf('f'), 0xFFFFFF);
    }

    public static class TextSegment {
        public String text = "";
        public Integer color = null;
        public boolean rainbow = false;
        public boolean pulse = false;
        public boolean wiggle = false;
        public boolean shimmer = false;
        public boolean vibrate = false;
        public boolean sparkle = false;
        public boolean flame = false;
        public boolean ice = false;
        public boolean magicGlow = false;
        public boolean divine = false;
        public boolean typewriter = false;
        public boolean fade = false;
        public boolean unravel = false;
        public boolean shake = false;
        public boolean glitch = false;
        public boolean drip = false;
        public boolean whisper = false;
        public boolean gradient = false;
        public Integer gradientStart = null;
        public Integer gradientEnd = null;

        public String toString() {
            return String.format("Seg[text='%s', color=%s, r=%s, p=%s, w=%s, s=%s, v=%s, +new]", this.text, this.color != null ? String.format("#%06X", this.color) : "null", this.rainbow, this.pulse, this.wiggle, this.shimmer, this.vibrate);
        }
    }
}

