/*
 * Decompiled with CFR 0.152.
 */
package ignis.bubblechat;

import ignis.bubblechat.BubbleChat;
import ignis.bubblechat.KeyBindings;
import ignis.bubblechat.logger.ChatLogger;
import ignis.bubblechat.rpchat.RPChat;
import java.lang.reflect.Method;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;

public class VotiveBubbleChatClientMod
implements ClientModInitializer {
    public void onInitializeClient() {
        this.checkImmediatelyFastCompatibility();
        BubbleChat.register();
        RPChat.register();
        KeyBindings.register();
        this.registerChatLogger();
        if (FabricLoader.getInstance().isModLoaded("advancedchatcore")) {
            try {
                Class<?> integrationClass = Class.forName("ignis.bubblechat.rpchat.AdvancedChatIntegration");
                Method registerMethod = integrationClass.getMethod("register", new Class[0]);
                registerMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                System.err.println("[VotiveBubbleChat] Failed to register AdvancedChat integration: " + e.getMessage());
            }
        }
    }

    private void checkImmediatelyFastCompatibility() {
        if (!FabricLoader.getInstance().isModLoaded("immediatelyfast")) {
            return;
        }
        System.out.println("[VotiveBubbleChat] \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d ImmediatelyFast!");
        try {
            Class<?> apiClass = Class.forName("net.raphimc.immediatelyfastapi.ImmediatelyFastApi");
            Object apiInstance = apiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object config = apiClass.getMethod("getConfig", new Class[0]).invoke(apiInstance, new Object[0]);
            Method setMethod = config.getClass().getMethod("setHudBatching", Boolean.TYPE);
            setMethod.invoke(config, false);
            System.out.println("[VotiveBubbleChat] hud_batching \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438.");
        }
        catch (Exception e) {
            System.out.println("[VotiveBubbleChat] \u0414\u043b\u044f \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0439 \u0440\u0430\u0431\u043e\u0442\u044b \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u0439:");
            System.out.println("  1. \u041e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 .minecraft/config/immediatelyfast.json");
            System.out.println("  2. \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \"hud_batching\": false");
            System.out.println("  3. \u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 Minecraft");
        }
    }

    private void registerChatLogger() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> ChatLogger.initialize());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ChatLogger.close());
    }
}

