/*
 * Decompiled with CFR 0.152.
 */
package ignis.bubblechat;

import com.google.common.collect.Maps;
import com.zeydie.sgson.SGsonBase;
import ignis.bubblechat.VotiveBubbleChatMod;
import ignis.bubblechat.logger.ChatLogger;
import ignis.bubblechat.packets.ChatPacket;
import ignis.bubblechat.renders.BubbleChatRender;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class BubbleChat {
    @NotNull
    private static final class_2960 channel = VotiveBubbleChatMod.createIdentifier("chat");
    @NotNull
    private static final Map<UUID, ChatPacket> chatPackets = Maps.newHashMap();
    @NotNull
    private static final Map<UUID, BubbleChatRender> bubbleChatRenders = Maps.newHashMap();

    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)channel, (client, handler, buf, responseSender) -> BubbleChat.handle((ChatPacket)SGsonBase.create().fromJsonToObject(new String(buf.method_36132(), StandardCharsets.UTF_8), (Object)new ChatPacket())));
    }

    public static void handle(@NonNull ChatPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        UUID uuid = packet.getUuid();
        if (chatPackets.containsKey(uuid)) {
            chatPackets.replace(uuid, packet);
        } else {
            chatPackets.put(uuid, packet);
        }
        ChatLogger.logBubbleChatPacket(packet);
    }

    public static boolean isRendered(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        BubbleChatRender bubbleChatRender = bubbleChatRenders.get(uuid);
        return bubbleChatRender == null ? true : bubbleChatRender.isRendered();
    }

    @Generated
    @NotNull
    public static Map<UUID, ChatPacket> getChatPackets() {
        return chatPackets;
    }

    @Generated
    @NotNull
    public static Map<UUID, BubbleChatRender> getBubbleChatRenders() {
        return bubbleChatRenders;
    }
}

