/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.util;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.Message;

public class LogSpamFilter
implements Filter {
    private static final String[] SPAM_PATTERNS = new String[]{"GL_INVALID_OPERATION", "GL_INVALID_VALUE", "OpenGL debug message", "Texture name does not refer to a texture object", "Invalid texture format"};

    public Filter.Result getOnMismatch() {
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result getOnMatch() {
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(LogEvent event) {
        return this.checkMessage(event.getMessage().getFormattedMessage());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.checkMessage(msg);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.checkMessage(message);
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.checkMessage(msg.toString());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.checkMessage(msg.getFormattedMessage());
    }

    private Filter.Result checkMessage(String message) {
        if (message == null) {
            return Filter.Result.NEUTRAL;
        }
        for (String pattern : SPAM_PATTERNS) {
            if (!message.contains(pattern)) continue;
            return Filter.Result.DENY;
        }
        return Filter.Result.NEUTRAL;
    }

    public LifeCycle.State getState() {
        return LifeCycle.State.STARTED;
    }

    public void initialize() {
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isStopped() {
        return false;
    }

    public static void register() {
        try {
            Logger rootLogger = (Logger)LogManager.getRootLogger();
            LogSpamFilter filter = new LogSpamFilter();
            rootLogger.addFilter((Filter)filter);
            System.out.println("[LogSpamFilter] OpenGL \u0441\u043f\u0430\u043c \u0444\u0438\u043b\u044c\u0442\u0440 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d!");
        }
        catch (Exception e) {
            System.err.println("[LogSpamFilter] \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440: " + e.getMessage());
        }
    }
}

