/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.votive.airships.client.ships.HelmModelLoader;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_776;
import net.minecraft.class_7833;

public class SteeringWheelRenderer {
    private static final class_310 client = class_310.method_1551();
    private static volatile class_1087 helmBaseModel;
    private static volatile class_1087 helmWheelModel;
    private static volatile boolean modelsLoaded;
    private static volatile boolean renderLogged;
    private static final class_1091 HELM_BASE_ID;
    private static final class_1091 HELM_WHEEL_ID;
    private static final float ROTATION_SPEED = 2.5f;
    private static final float MAX_ROTATION = 30.0f;

    public static void renderSteeringWheelWithRotation(class_4587 matrices, class_4597 vertexConsumers, int light, class_243 position, float shipYaw, float currentRotation) {
        matrices.method_22903();
        matrices.method_22904(position.field_1352, position.field_1351, position.field_1350);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(shipYaw));
        if (!modelsLoaded) {
            System.out.println("[HELM] First render call, attempting to load models...");
            SteeringWheelRenderer.loadModels();
        }
        class_776 blockRenderer = client.method_1541();
        if (!renderLogged) {
            renderLogged = true;
            System.out.println("[HELM] Rendering wheel - Base model: " + (helmBaseModel != null ? "loaded" : "null") + ", Wheel model: " + (helmWheelModel != null ? "loaded" : "null"));
        }
        if (helmBaseModel != null && helmWheelModel != null) {
            try {
                blockRenderer.method_3350().method_3367(matrices.method_23760(), vertexConsumers.getBuffer(class_1921.method_23581()), null, helmBaseModel, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
                matrices.method_22903();
                matrices.method_22904(0.575, 0.5397, 0.4375);
                matrices.method_22907(class_7833.field_40718.rotationDegrees(currentRotation));
                matrices.method_22904(-0.575, -0.5397, -0.4375);
                blockRenderer.method_3350().method_3367(matrices.method_23760(), vertexConsumers.getBuffer(class_1921.method_23581()), null, helmWheelModel, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
                matrices.method_22909();
            }
            catch (Exception e) {
                SteeringWheelRenderer.renderFallback(matrices, vertexConsumers, light, blockRenderer);
            }
        } else {
            SteeringWheelRenderer.renderFallback(matrices, vertexConsumers, light, blockRenderer);
        }
        matrices.method_22909();
    }

    private static synchronized void loadModels() {
        if (modelsLoaded) {
            return;
        }
        modelsLoaded = true;
        try {
            if (client.method_1554() != null) {
                System.out.println("[HELM] Trying to load wheel models...");
                class_1087 baseModel = client.method_1554().method_4742(HELM_BASE_ID);
                System.out.println("[HELM] Base model result: " + (baseModel != null ? "found" : "null"));
                if (baseModel != null && baseModel != client.method_1554().method_4744()) {
                    helmBaseModel = baseModel;
                    System.out.println("[HELM] \u2705 Base model loaded!");
                } else {
                    helmBaseModel = null;
                    System.out.println("[HELM] \u274c Base model is missing/null");
                }
                class_1087 wheelModel = client.method_1554().method_4742(HELM_WHEEL_ID);
                System.out.println("[HELM] Wheel model result: " + (wheelModel != null ? "found" : "null"));
                if (wheelModel != null && wheelModel != client.method_1554().method_4744()) {
                    helmWheelModel = wheelModel;
                    System.out.println("[HELM] \u2705 Wheel model loaded!");
                } else {
                    helmWheelModel = null;
                    System.out.println("[HELM] \u274c Wheel model is missing/null");
                }
                if (helmBaseModel == null && helmWheelModel == null) {
                    System.err.println("[HELM] No wheel models could be loaded, will use fallback");
                } else {
                    System.out.println("[HELM] Wheel models loading complete");
                }
            }
        }
        catch (Exception e) {
            helmBaseModel = null;
            helmWheelModel = null;
            System.err.println("[HELM] \u274c Error loading wheel models: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void renderFallback(class_4587 matrices, class_4597 vertexConsumers, int light, class_776 blockRenderer) {
        try {
            class_2680 fenceState = class_2246.field_10620.method_9564();
            blockRenderer.method_3353(fenceState, matrices, vertexConsumers, light, class_4608.field_21444);
        }
        catch (Exception e) {
            System.err.println("[VotiveRP] Error rendering fallback: " + e.getMessage());
        }
    }

    public static float calculateSteeringRotation(int steeringDirection, float previousRotation, float tickDelta) {
        float targetRotation = (float)steeringDirection * 30.0f;
        float difference = targetRotation - previousRotation;
        float speed = 2.5f * tickDelta;
        if (Math.abs(difference) > speed) {
            return previousRotation + Math.signum(difference) * speed;
        }
        return targetRotation;
    }

    static {
        modelsLoaded = false;
        renderLogged = false;
        HELM_BASE_ID = HelmModelLoader.HELM_BASE_MAIN;
        HELM_WHEEL_ID = HelmModelLoader.HELM_WHEEL_MAIN;
    }
}

