/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.mojang.brigadier.StringReader;
import com.votive.airships.client.ships.ShipPacketHandler;
import com.votive.airships.client.ships.SteeringWheelRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7225;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_7923;

public class ShipRenderer {
    private static final class_310 client = class_310.method_1551();
    private static final Map<String, class_2680> blockStateCache = new ConcurrentHashMap<String, class_2680>();
    private static long lastCacheClear = 0L;
    private static final long CACHE_CLEAR_INTERVAL = 30000L;
    private static boolean hideBlocks = false;

    public static void register() {
        WorldRenderEvents.AFTER_ENTITIES.register(ShipRenderer::renderShips);
    }

    public static void tick() {
        long now = System.currentTimeMillis();
        if (now - lastCacheClear > 30000L) {
            blockStateCache.clear();
            lastCacheClear = now;
        }
    }

    public static void render(class_4587 matrices, float tickDelta) {
        if (ShipRenderer.client.field_1687 == null || ShipRenderer.client.field_1724 == null) {
            return;
        }
        class_4597.class_4598 vertexConsumers = client.method_22940().method_23000();
        class_243 cameraPos = ShipRenderer.client.field_1773.method_19418().method_19326();
        for (ShipPacketHandler.ActiveShipClient ship : ShipPacketHandler.getShips().values()) {
            if (!ship.visible || ship.blocks == null || ship.blocks.isEmpty()) continue;
            class_243 renderPos = ship.getInterpolatedPosition(tickDelta);
            float renderYaw = (float)ship.getInterpolatedYaw(tickDelta);
            double distance = renderPos.method_1022(cameraPos);
            if (distance > 256.0) continue;
            ShipRenderer.renderShip(matrices, (class_4597)vertexConsumers, ship, cameraPos, renderPos, renderYaw, tickDelta);
        }
        vertexConsumers.method_22993();
    }

    private static void renderShips(WorldRenderContext context) {
        if (ShipRenderer.client.field_1687 == null || ShipRenderer.client.field_1724 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastCacheClear > 30000L) {
            blockStateCache.clear();
            lastCacheClear = now;
        }
        class_4587 matrices = context.matrixStack();
        class_4597.class_4598 vertexConsumers = client.method_22940().method_23000();
        class_243 cameraPos = context.camera().method_19326();
        float tickDelta = context.tickDelta();
        for (ShipPacketHandler.ActiveShipClient ship : ShipPacketHandler.getShips().values()) {
            if (!ship.visible || ship.blocks == null || ship.blocks.isEmpty()) continue;
            class_243 renderPos = ship.getInterpolatedPosition(tickDelta);
            float renderYaw = (float)ship.getInterpolatedYaw(tickDelta);
            double distance = renderPos.method_1022(cameraPos);
            if (distance > 256.0) continue;
            ShipRenderer.renderShip(matrices, (class_4597)vertexConsumers, ship, cameraPos, renderPos, renderYaw, tickDelta);
        }
        vertexConsumers.method_22993();
    }

    private static void renderShip(class_4587 matrices, class_4597 vertexConsumers, ShipPacketHandler.ActiveShipClient ship, class_243 cameraPos, class_243 renderPos, float renderYaw, float tickDelta) {
        class_1297 armorStand;
        matrices.method_22903();
        matrices.method_22904(renderPos.field_1352 - cameraPos.field_1352, renderPos.field_1351 - cameraPos.field_1351, renderPos.field_1350 - cameraPos.field_1350);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-renderYaw));
        matrices.method_22904(-0.5, 0.0, -0.5);
        class_776 blockRenderManager = client.method_1541();
        class_2338 shipLightPos = new class_2338((int)Math.floor(renderPos.field_1352), (int)Math.floor(renderPos.field_1351), (int)Math.floor(renderPos.field_1350));
        int shipLight = class_761.method_23794((class_1920)ShipRenderer.client.field_1687, (class_2338)shipLightPos);
        if (shipLight == 0 || (shipLight & 0xFFFF) == 0) {
            shipLight = 0xF00000;
        }
        if (ship.blockMapCache == null || ship.needsBlockMapRebuild) {
            ship.blockMapCache = new HashMap<class_2338, ShipPacketHandler.ShipBlock>();
            for (ShipPacketHandler.ShipBlock block : ship.blocks) {
                class_2338 pos = new class_2338(block.relativeX - (int)ship.controlOffset.field_1352, block.relativeY - (int)ship.controlOffset.field_1351, block.relativeZ - (int)ship.controlOffset.field_1350);
                ship.blockMapCache.put(pos, block);
            }
            ship.needsBlockMapRebuild = false;
        }
        Map<class_2338, ShipPacketHandler.ShipBlock> blockMap = ship.blockMapCache;
        double yawRad = Math.toRadians(renderYaw);
        double cosYaw = Math.cos(yawRad);
        double sinYaw = Math.sin(yawRad);
        if (!hideBlocks) {
            for (ShipPacketHandler.ShipBlock block : ship.blocks) {
                class_2338 blockPos;
                boolean isOpaqueFullBlock;
                class_2680 state;
                double distanceSquared;
                double relX = (double)block.relativeX - ship.controlOffset.field_1352;
                double relZ = (double)block.relativeZ - ship.controlOffset.field_1350;
                double rotatedX = relX * cosYaw - relZ * sinYaw;
                double relY = (double)block.relativeY - ship.controlOffset.field_1351;
                double rotatedZ = relX * sinYaw + relZ * cosYaw;
                class_243 blockWorldPos = new class_243(renderPos.field_1352 + rotatedX, renderPos.field_1351 + relY, renderPos.field_1350 + rotatedZ);
                if (!ShipRenderer.isInFrustum(blockWorldPos, cameraPos) || (distanceSquared = blockWorldPos.method_1025(cameraPos)) > 65536.0 || (state = ShipRenderer.parseBlockState(block.material, block.blockData)) == null || state.method_26204() == class_2246.field_10124) continue;
                boolean bl = isOpaqueFullBlock = state.method_26225() && state.method_26234((class_1922)ShipRenderer.client.field_1687, class_2338.field_10980);
                if (isOpaqueFullBlock && ShipRenderer.isCompletelyEnclosed(blockPos = new class_2338(block.relativeX - (int)ship.controlOffset.field_1352, block.relativeY - (int)ship.controlOffset.field_1351, block.relativeZ - (int)ship.controlOffset.field_1350), blockMap)) continue;
                matrices.method_22903();
                matrices.method_22904((double)block.relativeX - ship.controlOffset.field_1352, (double)block.relativeY - ship.controlOffset.field_1351, (double)block.relativeZ - ship.controlOffset.field_1350);
                try {
                    blockRenderManager.method_3353(state, matrices, vertexConsumers, shipLight, class_4608.field_21444);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                matrices.method_22909();
            }
        }
        if (ship.controlOffset != null) {
            float steeringRotation;
            matrices.method_22903();
            matrices.method_22904(ship.controlOffset.field_1352, ship.controlOffset.field_1351 + 0.75, ship.controlOffset.field_1350);
            matrices.method_22905(0.8f, 0.8f, 0.8f);
            ship.previousSteeringRotation = steeringRotation = SteeringWheelRenderer.calculateSteeringRotation(ship.steeringWheelRotation, ship.previousSteeringRotation, tickDelta);
            SteeringWheelRenderer.renderSteeringWheelWithRotation(matrices, vertexConsumers, class_761.method_23794((class_1920)ShipRenderer.client.field_1687, (class_2338)new class_2338((int)(renderPos.field_1352 + ship.controlOffset.field_1352), (int)(renderPos.field_1351 + ship.controlOffset.field_1351 + 1.0), (int)(renderPos.field_1350 + ship.controlOffset.field_1350))), class_243.field_1353, 0.0f, steeringRotation);
            matrices.method_22909();
        }
        if (hideBlocks && ship.armorStandUUID != null) {
            armorStand = ship.getArmorStand(client);
            if (armorStand != null) {
                armorStand.method_5648(false);
                matrices.method_22903();
                matrices.method_22904(0.0, 2.5, 0.0);
                if (ShipRenderer.client.field_1772 != null) {
                    String string = String.format("\u00a7aArmorStand\u00a7r\nPos: %.2f, %.2f, %.2f\nYaw: %.1f\u00b0", armorStand.method_23317(), armorStand.method_23318(), armorStand.method_23321(), Float.valueOf(armorStand.method_36454()));
                }
                matrices.method_22909();
            }
        } else if (!hideBlocks && ship.armorStandUUID != null && (armorStand = ship.getArmorStand(client)) != null) {
            armorStand.method_5648(true);
        }
        matrices.method_22909();
    }

    private static class_2680 parseBlockState(String material, String blockData) {
        try {
            String cacheKey = material + "|" + (blockData != null ? blockData : "");
            class_2680 cached = blockStateCache.get(cacheKey);
            if (cached != null) {
                return cached;
            }
            class_2680 result = null;
            if (blockData != null && !blockData.isEmpty()) {
                String normalizedData = blockData.trim();
                if (normalizedData.startsWith("minecraft:")) {
                    try {
                        class_2259.class_7211 parseResult = class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(normalizedData), (boolean)false);
                        result = parseResult.comp_622();
                    }
                    catch (Exception parseResult) {}
                } else if (!normalizedData.startsWith("[")) {
                    try {
                        String fullBlockData = "minecraft:" + normalizedData;
                        class_2259.class_7211 parseResult = class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(fullBlockData), (boolean)false);
                        result = parseResult.comp_622();
                    }
                    catch (Exception fullBlockData) {}
                } else if (normalizedData.startsWith("[")) {
                    try {
                        String materialName = material.toLowerCase();
                        String fullBlockData = "minecraft:" + materialName + normalizedData;
                        class_2259.class_7211 parseResult = class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(fullBlockData), (boolean)false);
                        result = parseResult.comp_622();
                    }
                    catch (Exception materialName) {
                        // empty catch block
                    }
                }
            }
            if (result == null) {
                String materialName = material.toLowerCase();
                class_2960 id = materialName.contains(":") ? new class_2960(materialName) : new class_2960("minecraft", materialName);
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
                result = block != null && block != class_2246.field_10124 ? block.method_9564() : class_2246.field_10340.method_9564();
            }
            if (result != null) {
                blockStateCache.put(cacheKey, result);
            }
            return result;
        }
        catch (Exception e) {
            return class_2246.field_10340.method_9564();
        }
    }

    private static class_243 rotateControlOffset(class_243 controlOffset, String orientation) {
        int rotation;
        switch (orientation) {
            case "SOUTH": {
                int n = 0;
                break;
            }
            case "WEST": {
                int n = 1;
                break;
            }
            case "NORTH": {
                int n = 2;
                break;
            }
            case "EAST": {
                int n = 3;
                break;
            }
            default: {
                int n = rotation = 0;
            }
        }
        if (rotation == 0) {
            return controlOffset;
        }
        double x = controlOffset.field_1352;
        double y = controlOffset.field_1351;
        double z = controlOffset.field_1350;
        return switch (rotation) {
            case 1 -> new class_243(-z, y, x);
            case 2 -> new class_243(-x, y, -z);
            case 3 -> new class_243(z, y, -x);
            default -> new class_243(x, y, z);
        };
    }

    public static void clearCache() {
        blockStateCache.clear();
        lastCacheClear = System.currentTimeMillis();
    }

    public static void toggleBlocksVisibility() {
        hideBlocks = !hideBlocks;
    }

    public static boolean areBlocksHidden() {
        return hideBlocks;
    }

    private static class_243 getBlockWorldPosition(ShipPacketHandler.ShipBlock block, ShipPacketHandler.ActiveShipClient ship, class_243 shipPos, float shipYaw) {
        double relX = (double)block.relativeX - ship.controlOffset.field_1352;
        double relY = (double)block.relativeY - ship.controlOffset.field_1351;
        double relZ = (double)block.relativeZ - ship.controlOffset.field_1350;
        double yawRad = Math.toRadians(shipYaw);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        double rotatedX = relX * cos - relZ * sin;
        double rotatedZ = relX * sin + relZ * cos;
        return new class_243(shipPos.field_1352 + rotatedX, shipPos.field_1351 + relY, shipPos.field_1350 + rotatedZ);
    }

    private static boolean isInFrustum(class_243 blockPos, class_243 cameraPos) {
        class_243 lookVec;
        if (ShipRenderer.client.field_1724 == null) {
            return true;
        }
        class_243 toBlock = blockPos.method_1020(cameraPos);
        double distance = toBlock.method_1033();
        if (distance < 2.0) {
            return true;
        }
        double dotProduct = (toBlock = toBlock.method_1029()).method_1026(lookVec = ShipRenderer.client.field_1724.method_5828(1.0f));
        return dotProduct > -0.3;
    }

    private static boolean isCompletelyEnclosed(class_2338 pos, Map<class_2338, ShipPacketHandler.ShipBlock> blockMap) {
        for (class_2350 dir : class_2350.values()) {
            if (ShipRenderer.hasOpaqueNeighbor(pos, dir, blockMap)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasOpaqueNeighbor(class_2338 pos, class_2350 direction, Map<class_2338, ShipPacketHandler.ShipBlock> blockMap) {
        class_2338 neighborPos = pos.method_10093(direction);
        ShipPacketHandler.ShipBlock neighbor = blockMap.get(neighborPos);
        if (neighbor == null) {
            return false;
        }
        try {
            class_2680 neighborState = ShipRenderer.parseBlockState(neighbor.material, neighbor.blockData);
            if (neighborState == null) {
                return false;
            }
            class_2338 dummyPos = class_2338.field_10980;
            return neighborState.method_26225() && neighborState.method_26234((class_1922)ShipRenderer.client.field_1687, dummyPos);
        }
        catch (Exception e) {
            return false;
        }
    }
}

