/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.mojang.brigadier.StringReader;
import com.votive.airships.client.ships.ShipClientHandler;
import com.votive.airships.client.ships.ShipClientPacketSender;
import com.votive.airships.client.ships.ShipPacketHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ShipPlayerController {
    private static final class_310 client = class_310.method_1551();
    private static PlayerOnShip currentShip = null;
    private static class_243 lastSentPosition = null;
    private static int ticksSinceLastSync = 0;
    private static final int SYNC_INTERVAL = 2;
    private static class_243 frozenRelativePosition = null;
    private static class_243 frozenVelocity = null;
    private static class_243 captainSmoothedPos = null;
    private static final double COLLISION_CHECK_RADIUS = 60.0;
    private static final double GROUND_DETECTION_RANGE = 1.5;
    private static final double STEP_HEIGHT = 0.6;
    private static final double EPSILON = 0.001;

    public static void tick(class_310 client) {
        ShipPlayerController.tick();
    }

    public static void tick() {
        class_746 player = ShipPlayerController.client.field_1724;
        if (player == null || ShipPlayerController.client.field_1687 == null) {
            ShipPlayerController.reset();
            return;
        }
        class_1297 cameraEntity = client.method_1560();
        if (cameraEntity != null && "FreeCamera".equals(cameraEntity.getClass().getSimpleName())) {
            return;
        }
        ShipPlayerController.checkAndApplyWindowFocus(player);
        ShipPacketHandler.cleanupOldPositions();
    }

    public static void applyShipPhysics() {
        if (ShipClientHandler.getInstance() != null && ShipClientHandler.getInstance().isPhysicsBlocked()) {
            return;
        }
        class_746 player = ShipPlayerController.client.field_1724;
        if (player == null || ShipPlayerController.client.field_1687 == null) {
            return;
        }
        if (ShipPacketHandler.getControlledShipId() != null) {
            return;
        }
        ShipPlayerController.checkAndApplyWindowFocus(player);
        if (!client.method_1569() && currentShip != null) {
            return;
        }
        GroundBlock groundBlock = ShipPlayerController.findGroundBlockUnderPlayer(player);
        if (System.currentTimeMillis() % 1000L < 50L) {
            if (groundBlock != null) {
                System.out.println("[ShipPlayerPhysics] \u041d\u0430\u0439\u0434\u0435\u043d \u0431\u043b\u043e\u043a \u043f\u043e\u0434 \u0438\u0433\u0440\u043e\u043a\u043e\u043c! Ship: " + groundBlock.ship.shipId);
            } else {
                System.out.println("[ShipPlayerPhysics] \u0411\u043b\u043e\u043a \u043f\u043e\u0434 \u0438\u0433\u0440\u043e\u043a\u043e\u043c \u041d\u0415 \u043d\u0430\u0439\u0434\u0435\u043d. \u041a\u043e\u0440\u0430\u0431\u043b\u0438: " + ShipPacketHandler.getShips().size());
            }
        }
        if (groundBlock != null) {
            ShipPlayerController.handlePlayerOnShip(player, groundBlock);
        } else if (currentShip != null) {
            ShipPlayerController.reset();
        }
    }

    private static void checkAndApplyWindowFocus(class_746 player) {
        if (!client.method_1569()) {
            ShipPlayerController.freezePlayerOnShip(player);
        } else {
            ShipPlayerController.unfreezePlayer(player);
        }
    }

    private static void handleCaptain(class_746 player, String shipId) {
        double shipYaw;
        class_243 shipPos;
        ShipPacketHandler.ActiveShipClient ship = ShipPacketHandler.getShips().get(shipId);
        if (ship == null) {
            ShipPlayerController.reset();
            return;
        }
        class_1297 armorStand = ship.getArmorStand(client);
        if (armorStand != null) {
            shipPos = armorStand.method_19538();
            shipYaw = armorStand.method_36454();
        } else {
            shipPos = ship.controlPoint;
            shipYaw = ship.yaw;
        }
        class_243 captainOffset = ShipPacketHandler.getCaptainOffset();
        class_243 rotatedOffset = ShipPlayerController.rotateVector(captainOffset, shipYaw);
        class_243 targetPos = shipPos.method_1019(rotatedOffset);
        player.method_33574(targetPos);
        player.method_18800(0.0, 0.0, 0.0);
        player.field_6017 = 0.0f;
        player.method_24830(true);
        ShipPlayerController.disableWalkingAnimation(player);
        if (currentShip == null || !ShipPlayerController.currentShip.shipId.equals(shipId)) {
            currentShip = new PlayerOnShip(shipId, shipPos, shipYaw);
        } else {
            currentShip.updatePosition(shipPos, shipYaw);
        }
        ShipPlayerController.syncPlayerPosition(player, shipId);
    }

    private static GroundBlock findGroundBlockUnderPlayer(class_746 player) {
        class_238 playerBox = player.method_5829();
        double playerFeetY = playerBox.field_1322;
        class_243 playerCenter = player.method_19538();
        GroundBlock closest = null;
        double closestDist = Double.MAX_VALUE;
        for (ShipPacketHandler.ActiveShipClient ship : ShipPacketHandler.getShips().values()) {
            if (!ship.visible || ship.blocks == null) continue;
            class_243 shipPos = ShipPlayerController.getShipActualPosition(ship);
            double shipYaw = ShipPlayerController.getShipActualYaw(ship);
            double distToShip = playerCenter.method_1022(shipPos);
            if (System.currentTimeMillis() % 2000L < 50L) {
                System.out.println("[DEBUG] \u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043a\u043e\u0440\u0430\u0431\u043b\u044f " + ship.shipId + " | distToShip=" + String.format("%.1f", distToShip) + " | RADIUS=60.0 | blocks=" + ship.blocks.size());
            }
            if (distToShip > 60.0) continue;
            for (ShipPacketHandler.ShipBlock block : ship.blocks) {
                double dist;
                double distY;
                class_243 blockPos = ShipPlayerController.calculateBlockWorldPos(block, ship, shipPos, shipYaw);
                double blockHeight = ShipPlayerController.getBlockTopHeight(block.material, block.blockData);
                double heightAdjustment = 1.0 - blockHeight;
                double blockTopY = blockPos.field_1351 - heightAdjustment;
                if (blockTopY > playerFeetY + 0.6 || (distY = Math.abs(playerFeetY - blockTopY)) > 1.5) continue;
                class_243 blockCenter = ShipPlayerController.calculateBlockCenter(blockPos, shipYaw);
                double dx = Math.abs(playerCenter.field_1352 - blockCenter.field_1352);
                double dz = Math.abs(playerCenter.field_1350 - blockCenter.field_1350);
                if (dx > 0.8 || dz > 0.8 || !((dist = Math.sqrt(dx * dx + dz * dz + distY * distY)) < closestDist)) continue;
                closestDist = dist;
                closest = new GroundBlock(ship, shipPos, shipYaw, blockPos, blockTopY);
            }
        }
        return closest;
    }

    private static void handlePlayerOnShip(class_746 player, GroundBlock ground) {
        double targetFeetY;
        String shipId = ground.ship.shipId;
        class_243 shipPos = ground.shipPos;
        double shipYaw = ground.shipYaw;
        if (currentShip == null || !ShipPlayerController.currentShip.shipId.equals(shipId)) {
            currentShip = new PlayerOnShip(shipId, shipPos, shipYaw);
        }
        class_243 shipMovement = class_243.field_1353;
        double yawDelta = 0.0;
        if (ShipPlayerController.currentShip.lastShipPosition != null) {
            shipMovement = shipPos.method_1020(ShipPlayerController.currentShip.lastShipPosition);
            yawDelta = shipYaw - ShipPlayerController.currentShip.lastShipYaw;
            if (System.currentTimeMillis() % 1000L < 50L && shipMovement.method_1027() > 1.0E-4) {
                System.out.println("[ShipMovement] Ship moved! Delta: " + String.format("%.3f, %.3f, %.3f", shipMovement.field_1352, shipMovement.field_1351, shipMovement.field_1350) + " | Length: " + String.format("%.3f", shipMovement.method_1033()));
            }
        }
        class_243 currentPos = player.method_19538();
        class_243 velocity = player.method_18798();
        class_238 playerBox = player.method_5829();
        double playerFeetY = playerBox.field_1322;
        double playerHeight = playerBox.field_1325 - playerBox.field_1322;
        class_243 newVelocity = velocity;
        boolean hasBlocksAboveGround = false;
        if (velocity.field_1351 < -0.1) {
            targetFeetY = ground.surfaceY;
            newVelocity = new class_243(velocity.field_1352, 0.0, velocity.field_1350);
            player.field_6017 = 0.0f;
        } else if (velocity.field_1351 > 0.1) {
            shipBlocks = ShipPlayerController.getAllShipBlockBoxes(ground.ship, shipPos, shipYaw);
            class_238 checkAbovePlayer = new class_238(playerBox.field_1323, playerFeetY + 0.1, playerBox.field_1321, playerBox.field_1320, playerFeetY + 2.5, playerBox.field_1324);
            boolean hasBlocksAbove = false;
            for (class_238 block : shipBlocks) {
                if (!checkAbovePlayer.method_994(block)) continue;
                hasBlocksAbove = true;
                break;
            }
            if (hasBlocksAbove) {
                targetFeetY = playerFeetY;
                newVelocity = new class_243(velocity.field_1352, 0.0, velocity.field_1350);
            } else {
                targetFeetY = playerFeetY + velocity.field_1351;
            }
        } else {
            if (ground.surfaceY > playerFeetY) {
                shipBlocks = ShipPlayerController.getAllShipBlockBoxes(ground.ship, shipPos, shipYaw);
                class_238 checkAboveGround = new class_238(playerBox.field_1323, ground.surfaceY + 0.1, playerBox.field_1321, playerBox.field_1320, ground.surfaceY + 2.0, playerBox.field_1324);
                hasBlocksAboveGround = false;
                for (class_238 block : shipBlocks) {
                    if (!checkAboveGround.method_994(block)) continue;
                    hasBlocksAboveGround = true;
                    break;
                }
                targetFeetY = hasBlocksAboveGround ? playerFeetY : ground.surfaceY;
            } else {
                targetFeetY = ground.surfaceY;
            }
            newVelocity = new class_243(velocity.field_1352, 0.0, velocity.field_1350);
        }
        double newCenterY = targetFeetY + playerHeight / 2.0;
        class_243 newPos = new class_243(currentPos.field_1352, newCenterY, currentPos.field_1350);
        double lockedY = newCenterY;
        class_243 horizontalVel = new class_243(velocity.field_1352, 0.0, velocity.field_1350);
        if (horizontalVel.method_1027() > 0.001) {
            List<class_238> shipBlocks = ShipPlayerController.getAllShipBlockBoxes(ground.ship, shipPos, shipYaw);
            class_243 beforeCollision = newPos;
            newPos = ShipPlayerController.applyMovementWithCollisions(player, newPos, horizontalVel, shipBlocks);
            if (hasBlocksAboveGround && newPos.field_1351 > beforeCollision.field_1351) {
                newPos = new class_243(newPos.field_1352, beforeCollision.field_1351, newPos.field_1350);
            }
        }
        player.method_33574(newPos);
        player.method_18799(newVelocity);
        player.method_24830(Math.abs(newVelocity.field_1351) < 0.01);
        double expectedMinY = newPos.field_1351 - playerHeight / 2.0;
        double expectedMaxY = newPos.field_1351 + playerHeight / 2.0;
        if (Math.abs(player.method_5829().field_1322 - expectedMinY) > 0.01) {
            class_238 correctBox = new class_238(player.method_5829().field_1323, expectedMinY, player.method_5829().field_1321, player.method_5829().field_1320, expectedMaxY, player.method_5829().field_1324);
            player.method_5857(correctBox);
        }
        currentShip.updatePosition(shipPos, shipYaw);
        ShipPlayerController.syncPlayerPosition(player, shipId);
    }

    private static void disableWalkingAnimation(class_746 player) {
        player.field_5973 = 0.0f;
        player.field_6039 = 0.0f;
        player.field_6225 = 0.0f;
        player.field_6211 = 0.0f;
        player.field_6249 = 0.0f;
    }

    private static List<class_238> getAllShipBlockBoxes(ShipPacketHandler.ActiveShipClient ship, class_243 shipPos, double shipYaw) {
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        boolean firstBlock = true;
        for (ShipPacketHandler.ShipBlock block : ship.blocks) {
            class_243 blockPos = ShipPlayerController.calculateBlockWorldPos(block, ship, shipPos, shipYaw);
            List<class_238> blockBoxes = ShipPlayerController.getBlockCollisionBoxes(block.material, block.blockData, blockPos, shipYaw);
            boxes.addAll(blockBoxes);
        }
        return boxes;
    }

    private static List<class_238> getBlockCollisionBoxes(String material, String blockData, class_243 blockWorldPos, double shipYaw) {
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        try {
            class_2680 state = ShipPlayerController.getBlockStateFromData(material, blockData);
            class_265 shape = state.method_26220(null, null);
            shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                class_238 worldBox = new class_238(blockWorldPos.field_1352 + minX, blockWorldPos.field_1351 + minY, blockWorldPos.field_1350 + minZ, blockWorldPos.field_1352 + maxX, blockWorldPos.field_1351 + maxY, blockWorldPos.field_1350 + maxZ);
                boxes.add(worldBox);
            });
        }
        catch (Exception e) {
            boxes.add(new class_238(blockWorldPos.field_1352, blockWorldPos.field_1351, blockWorldPos.field_1350, blockWorldPos.field_1352 + 1.0, blockWorldPos.field_1351 + 1.0, blockWorldPos.field_1350 + 1.0));
        }
        return boxes;
    }

    private static class_2680 getBlockStateFromData(String material, String blockData) {
        try {
            String materialName;
            Object fullBlockString;
            if (blockData != null && !blockData.isEmpty()) {
                String normalizedData = blockData.trim();
                if (normalizedData.startsWith("minecraft:")) {
                    fullBlockString = normalizedData;
                } else if (!normalizedData.startsWith("[")) {
                    fullBlockString = "minecraft:" + normalizedData;
                } else if (normalizedData.startsWith("[")) {
                    materialName = material.toLowerCase();
                    fullBlockString = "minecraft:" + materialName + normalizedData;
                } else {
                    fullBlockString = "minecraft:" + material.toLowerCase();
                }
            } else {
                String materialName2 = material.toLowerCase();
                fullBlockString = materialName2.contains(":") ? materialName2 : "minecraft:" + materialName2;
            }
            try {
                class_2259.class_7211 parseResult = class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader((String)fullBlockString), (boolean)false);
                return parseResult.comp_622();
            }
            catch (Exception parseError) {
                materialName = material.toLowerCase();
                class_2960 id = materialName.contains(":") ? new class_2960(materialName) : new class_2960("minecraft", materialName);
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(id);
                return block.method_9564();
            }
        }
        catch (Exception e) {
            return class_2246.field_10340.method_9564();
        }
    }

    private static double getBlockTopHeight(String material, String blockData) {
        try {
            class_2680 state = ShipPlayerController.getBlockStateFromData(material, blockData);
            class_265 shape = state.method_26220(null, null);
            if (shape.method_1110()) {
                return 0.0;
            }
            double maxY = 0.0;
            double[] maxYRef = new double[]{0.0};
            shape.method_1089((minX, minY, minZ, maxX, maxY2, maxZ) -> {
                if (maxY2 > maxYRef[0]) {
                    maxYRef[0] = maxY2;
                }
            });
            maxY = maxYRef[0];
            if (maxY < 0.001) {
                return 1.0;
            }
            return maxY;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    private static class_243 applyMovementWithCollisions(class_746 player, class_243 startPos, class_243 movement, List<class_238> blocks) {
        boolean bl;
        class_238 playerBox = player.method_5829();
        double width = playerBox.field_1320 - playerBox.field_1323;
        double height = playerBox.field_1325 - playerBox.field_1322;
        double moveX = movement.field_1352;
        double moveZ = movement.field_1350;
        if (Math.abs(moveX) < 0.001 && Math.abs(moveZ) < 0.001) {
            return startPos;
        }
        class_238 testBox = new class_238(startPos.field_1352 - width / 2.0 + moveX, startPos.field_1351 - height / 2.0, startPos.field_1350 - width / 2.0 + moveZ, startPos.field_1352 + width / 2.0 + moveX, startPos.field_1351 + height / 2.0, startPos.field_1350 + width / 2.0 + moveZ);
        boolean hasCollision = false;
        for (class_238 class_2382 : blocks) {
            if (!testBox.method_994(class_2382)) continue;
            hasCollision = true;
            break;
        }
        if (!hasCollision) {
            return new class_243(startPos.field_1352 + moveX, startPos.field_1351, startPos.field_1350 + moveZ);
        }
        ArrayList<class_238> blockingBlocks = new ArrayList<class_238>();
        for (class_238 class_2383 : blocks) {
            if (!testBox.method_994(class_2383)) continue;
            blockingBlocks.add(class_2383);
        }
        boolean bl2 = false;
        for (class_238 class_2384 : blockingBlocks) {
            class_238 checkAboveBox = new class_238(startPos.field_1352 - width / 2.0, class_2384.field_1325 + 0.01, startPos.field_1350 - width / 2.0, startPos.field_1352 + width / 2.0, class_2384.field_1325 + 2.5, startPos.field_1350 + width / 2.0);
            for (class_238 block : blocks) {
                if (block == class_2384 || !checkAboveBox.method_994(block)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        if (bl) {
            double d = 0.3;
            double pushBackX = -moveX * d;
            double pushBackZ = -moveZ * d;
            class_243 pushedBackPos = new class_243(startPos.field_1352 + pushBackX, startPos.field_1351, startPos.field_1350 + pushBackZ);
            player.method_18800(pushBackX, player.method_18798().field_1351, pushBackZ);
            return pushedBackPos;
        }
        if (!player.method_24828()) {
            return ShipPlayerController.tryPartialMovement(startPos, moveX, moveZ, width, height, blocks);
        }
        double d = 0.0;
        boolean canStep = false;
        for (double step = 0.05; step <= 0.6; step += 0.05) {
            class_238 stepBox = new class_238(startPos.field_1352 - width / 2.0 + moveX, startPos.field_1351 - height / 2.0 + step, startPos.field_1350 - width / 2.0 + moveZ, startPos.field_1352 + width / 2.0 + moveX, startPos.field_1351 + height / 2.0 + step, startPos.field_1350 + width / 2.0 + moveZ);
            boolean collision = false;
            for (class_238 block : blocks) {
                if (!stepBox.method_994(block)) continue;
                collision = true;
                break;
            }
            if (collision) continue;
            d = step;
            canStep = true;
            break;
        }
        if (canStep) {
            return new class_243(startPos.field_1352 + moveX, startPos.field_1351 + d, startPos.field_1350 + moveZ);
        }
        return ShipPlayerController.tryPartialMovement(startPos, moveX, moveZ, width, height, blocks);
    }

    private static class_243 tryPartialMovement(class_243 startPos, double moveX, double moveZ, double width, double height, List<class_238> blocks) {
        class_243 currentPos = startPos;
        if (Math.abs(moveX) > 0.001) {
            class_238 testX = new class_238(currentPos.field_1352 - width / 2.0 + moveX, currentPos.field_1351 - height / 2.0, currentPos.field_1350 - width / 2.0, currentPos.field_1352 + width / 2.0 + moveX, currentPos.field_1351 + height / 2.0, currentPos.field_1350 + width / 2.0);
            boolean collisionX = false;
            for (class_238 block : blocks) {
                if (!testX.method_994(block)) continue;
                collisionX = true;
                break;
            }
            if (!collisionX) {
                currentPos = new class_243(currentPos.field_1352 + moveX, currentPos.field_1351, currentPos.field_1350);
            }
        }
        if (Math.abs(moveZ) > 0.001) {
            class_238 testZ = new class_238(currentPos.field_1352 - width / 2.0, currentPos.field_1351 - height / 2.0, currentPos.field_1350 - width / 2.0 + moveZ, currentPos.field_1352 + width / 2.0, currentPos.field_1351 + height / 2.0, currentPos.field_1350 + width / 2.0 + moveZ);
            boolean collisionZ = false;
            for (class_238 block : blocks) {
                if (!testZ.method_994(block)) continue;
                collisionZ = true;
                break;
            }
            if (!collisionZ) {
                currentPos = new class_243(currentPos.field_1352, currentPos.field_1351, currentPos.field_1350 + moveZ);
            }
        }
        return currentPos;
    }

    private static void syncPlayerPosition(class_746 player, String shipId) {
        double distSq;
        if (++ticksSinceLastSync < 2) {
            return;
        }
        class_243 currentPos = player.method_19538();
        if (lastSentPosition != null && (distSq = currentPos.method_1025(lastSentPosition)) < 0.01) {
            return;
        }
        ShipPacketHandler.ActiveShipClient ship = ShipPacketHandler.getShips().get(shipId);
        if (ship != null && ship.controlPoint != null) {
            class_243 shipPos = ship.controlPoint;
            double shipYaw = ship.yaw;
            class_243 relativeWorldPos = currentPos.method_1020(shipPos);
            double angleRad = Math.toRadians(-shipYaw);
            double cos = Math.cos(angleRad);
            double sin = Math.sin(angleRad);
            double localX = relativeWorldPos.field_1352 * cos - relativeWorldPos.field_1350 * sin;
            double localY = relativeWorldPos.field_1351;
            double localZ = relativeWorldPos.field_1352 * sin + relativeWorldPos.field_1350 * cos;
            boolean isMoving = player.field_3913.field_3905 != 0.0f || player.field_3913.field_3907 != 0.0f;
            float relativeYaw = player.method_36454() - (float)shipYaw;
            ShipClientPacketSender.sendPlayerPositionOnShip(shipId, localX, localY, localZ, relativeYaw, player.method_36455(), isMoving);
            lastSentPosition = currentPos;
            ticksSinceLastSync = 0;
            return;
        }
        lastSentPosition = currentPos;
        ticksSinceLastSync = 0;
    }

    public static class_243 calculateBlockWorldPos(ShipPacketHandler.ShipBlock block, ShipPacketHandler.ActiveShipClient ship, class_243 shipPos, double shipYaw) {
        Matrix4f matrix = new Matrix4f();
        matrix.identity();
        matrix.rotateY((float)Math.toRadians(-shipYaw));
        matrix.translate((float)((double)block.relativeX - ship.controlOffset.field_1352), (float)((double)block.relativeY - ship.controlOffset.field_1351), (float)((double)block.relativeZ - ship.controlOffset.field_1350));
        Vector4f transformed = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        matrix.transform(transformed);
        double finalOffsetX = transformed.x;
        double finalOffsetY = transformed.y;
        double finalOffsetZ = transformed.z;
        return new class_243(shipPos.field_1352 + finalOffsetX - 0.5, shipPos.field_1351 + finalOffsetY, shipPos.field_1350 + finalOffsetZ - 0.5);
    }

    private static class_243 rotateControlOffset(class_243 controlOffset, String orientation) {
        int rotation;
        switch (orientation) {
            case "SOUTH": {
                int n = 0;
                break;
            }
            case "WEST": {
                int n = 1;
                break;
            }
            case "NORTH": {
                int n = 2;
                break;
            }
            case "EAST": {
                int n = 3;
                break;
            }
            default: {
                int n = rotation = 0;
            }
        }
        if (rotation == 0) {
            return controlOffset;
        }
        double x = controlOffset.field_1352;
        double y = controlOffset.field_1351;
        double z = controlOffset.field_1350;
        return switch (rotation) {
            case 1 -> new class_243(-z, y, x);
            case 2 -> new class_243(-x, y, -z);
            case 3 -> new class_243(z, y, -x);
            default -> new class_243(x, y, z);
        };
    }

    public static class_243 calculateBlockCenter(class_243 blockPos, double shipYaw) {
        return new class_243(blockPos.field_1352 + 0.5, blockPos.field_1351 + 0.5, blockPos.field_1350 + 0.5);
    }

    public static class_243 getShipActualPosition(ShipPacketHandler.ActiveShipClient ship) {
        return ship.controlPoint;
    }

    public static double getShipActualYaw(ShipPacketHandler.ActiveShipClient ship) {
        return ship.yaw;
    }

    public static class_243 rotateVector(class_243 vec, double yaw) {
        double rad = Math.toRadians(yaw);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        return new class_243(vec.field_1352 * cos - vec.field_1350 * sin, vec.field_1351, vec.field_1352 * sin + vec.field_1350 * cos);
    }

    public static void reset() {
        currentShip = null;
        lastSentPosition = null;
        ticksSinceLastSync = 0;
        frozenRelativePosition = null;
        frozenVelocity = null;
    }

    private static void freezePlayerOnShip(class_746 player) {
        if (currentShip == null) {
            return;
        }
        ShipPacketHandler.ActiveShipClient ship = ShipPacketHandler.getShips().get(ShipPlayerController.currentShip.shipId);
        if (ship == null) {
            return;
        }
        class_243 shipPos = ShipPlayerController.getShipActualPosition(ship);
        double shipYaw = ShipPlayerController.getShipActualYaw(ship);
        if (frozenRelativePosition == null) {
            class_243 playerPos = player.method_19538();
            class_243 relativeToShip = playerPos.method_1020(shipPos);
            double angleRad = Math.toRadians(-shipYaw);
            double cos = Math.cos(angleRad);
            double sin = Math.sin(angleRad);
            double localX = relativeToShip.field_1352 * cos - relativeToShip.field_1350 * sin;
            double localY = relativeToShip.field_1351;
            double localZ = relativeToShip.field_1352 * sin + relativeToShip.field_1350 * cos;
            frozenRelativePosition = new class_243(localX, localY, localZ);
            frozenVelocity = player.method_18798();
        }
        class_243 rotatedOffset = ShipPlayerController.rotateVector(frozenRelativePosition, shipYaw);
        class_243 targetPos = shipPos.method_1019(rotatedOffset);
        player.method_33574(targetPos);
        player.method_18800(0.0, 0.0, 0.0);
        player.field_6017 = 0.0f;
        player.method_24830(true);
        ShipPlayerController.disableWalkingAnimation(player);
        currentShip.updatePosition(shipPos, shipYaw);
    }

    private static void unfreezePlayer(class_746 player) {
        if (frozenRelativePosition != null) {
            if (frozenVelocity != null) {
                if (player.method_24828()) {
                    player.method_18800(ShipPlayerController.frozenVelocity.field_1352, 0.0, ShipPlayerController.frozenVelocity.field_1350);
                } else {
                    player.method_18799(frozenVelocity);
                }
            }
            frozenRelativePosition = null;
            frozenVelocity = null;
        }
    }

    public static PlayerOnShip getCurrentShip() {
        return currentShip;
    }

    public static ShipPlayerController getInstance() {
        return new ShipPlayerController();
    }

    public static void setPhysicsDisabled(String shipId) {
        if (currentShip != null && ShipPlayerController.currentShip.shipId != null && ShipPlayerController.currentShip.shipId.equals(shipId)) {
            ShipPlayerController.reset();
        }
    }

    public static class PlayerOnShip {
        public final String shipId;
        public class_243 lastShipPosition;
        public double lastShipYaw;

        public PlayerOnShip(String shipId, class_243 shipPos, double shipYaw) {
            this.shipId = shipId;
            this.lastShipPosition = shipPos;
            this.lastShipYaw = shipYaw;
        }

        public void updatePosition(class_243 shipPos, double shipYaw) {
            this.lastShipPosition = shipPos;
            this.lastShipYaw = shipYaw;
        }
    }

    private static class GroundBlock {
        final ShipPacketHandler.ActiveShipClient ship;
        final class_243 shipPos;
        final double shipYaw;
        final class_243 blockPos;
        final double surfaceY;

        GroundBlock(ShipPacketHandler.ActiveShipClient ship, class_243 shipPos, double shipYaw, class_243 blockPos, double surfaceY) {
            this.ship = ship;
            this.shipPos = shipPos;
            this.shipYaw = shipYaw;
            this.blockPos = blockPos;
            this.surfaceY = surfaceY;
        }
    }
}

