/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.votive.airships.client.ships.ShipBoundaryRenderer;
import com.votive.airships.client.ships.ShipClientHandler;
import com.votive.airships.client.ships.ShipDebugLogger;
import com.votive.airships.client.ships.ShipRenderer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_742;

public class ShipPacketHandler {
    private static final class_2960 CHANNEL = new class_2960("votivemods", "ships");
    private static final Map<String, ActiveShipClient> ships = new ConcurrentHashMap<String, ActiveShipClient>();
    private static String controlledShipId = null;
    private static class_243 captainOffset = null;
    private static final Map<UUID, PassengerPosCache> otherPlayersPositions = new ConcurrentHashMap<UUID, PassengerPosCache>();
    private static final Map<String, ChunkedTransfer> activeTransfers = new ConcurrentHashMap<String, ChunkedTransfer>();
    private static final Set<UUID> headRotationLocked = ConcurrentHashMap.newKeySet();
    private static double extrapolationAmount = 0.0;
    private static double smoothingFactor = 0.1;
    private static boolean useDeadReckoning = false;
    private static boolean useRawPosition = false;
    private static boolean useSimpleLerp = false;
    private static boolean useFixedTimeLerp = true;
    private static int packetCountType0 = 0;
    private static int packetCountType1 = 0;
    private static long lastPacketStatsTime = 0L;

    public static void register() {
        System.out.println("=================================================");
        System.out.println("[VOTIVE-AIRSHIPS] ShipPacketHandler REGISTERED!");
        System.out.println("[VOTIVE-AIRSHIPS] useRawPosition = " + useRawPosition);
        System.out.println("[VOTIVE-AIRSHIPS] useSimpleLerp = " + useSimpleLerp);
        System.out.println("[VOTIVE-AIRSHIPS] useDeadReckoning = " + useDeadReckoning);
        System.out.println("=================================================");
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL, (client, handler, buf, responseSender) -> {
            try {
                byte packetType = buf.readByte();
                long now = System.currentTimeMillis();
                if (now - lastPacketStatsTime > 5000L) {
                    if (packetCountType0 + packetCountType1 > 0) {
                        System.out.println(String.format("[PACKET-STATS] Type0 (ShipData): %d | Type1 (Position): %d", packetCountType0, packetCountType1));
                    }
                    packetCountType0 = 0;
                    packetCountType1 = 0;
                    lastPacketStatsTime = now;
                }
                switch (packetType) {
                    case 0: {
                        ++packetCountType0;
                        ShipPacketHandler.handleShipData(buf, client);
                        break;
                    }
                    case 1: {
                        ++packetCountType1;
                        ShipPacketHandler.handleShipPosition(buf, client);
                        break;
                    }
                    case 2: {
                        ShipPacketHandler.handleControlStart(buf, client);
                        break;
                    }
                    case 3: {
                        ShipPacketHandler.handleControlStop(buf, client);
                        break;
                    }
                    case 4: {
                        ShipPacketHandler.handleShowBoundaries(buf, client);
                        break;
                    }
                    case 5: {
                        ShipPacketHandler.handleHideBoundaries(buf, client);
                        break;
                    }
                    case 6: {
                        ShipPacketHandler.handleShipRemove(buf, client);
                        break;
                    }
                    case 7: {
                        ShipPacketHandler.handleControlStartWithOffset(buf, client);
                        break;
                    }
                    case 8: {
                        ShipPacketHandler.handleShipOrientation(buf, client);
                        break;
                    }
                    case 10: {
                        ShipPacketHandler.handleDisableShipPhysics(buf, client);
                        break;
                    }
                    case 11: {
                        ShipPacketHandler.handleChunkedStart(buf, client);
                        break;
                    }
                    case 12: {
                        ShipPacketHandler.handleChunkedData(buf, client);
                        break;
                    }
                    case 13: {
                        ShipPacketHandler.handleChunkedEnd(buf, client);
                        break;
                    }
                    case 14: {
                        ShipPacketHandler.handleSteeringWheelRotation(buf, client);
                        break;
                    }
                    case 15: {
                        ShipPacketHandler.handleHeadRotationLock(buf, client);
                        break;
                    }
                    case 16: {
                        ShipPacketHandler.handlePassengerRelativePositions(buf, client);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u0430\u043a\u0435\u0442\u0430 \u043a\u043e\u0440\u0430\u0431\u043b\u044f: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    private static String readString(class_2540 buf) {
        int length = buf.readInt();
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void handleChunkedStart(class_2540 buf, class_310 client) {
        try {
            String transferId = ShipPacketHandler.readString(buf);
            String shipId = ShipPacketHandler.readString(buf);
            boolean isAirship = buf.readBoolean();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float yaw = buf.readFloat();
            UUID armorStandUUID = null;
            boolean hasArmorStand = buf.readBoolean();
            if (hasArmorStand) {
                long mostSig = buf.readLong();
                long leastSig = buf.readLong();
                armorStandUUID = new UUID(mostSig, leastSig);
            }
            int controlOffsetX = buf.readInt();
            int controlOffsetY = buf.readInt();
            int controlOffsetZ = buf.readInt();
            int totalBlocks = buf.readInt();
            UUID finalArmorStandUUID = armorStandUUID;
            class_243 controlPoint = new class_243(x, y, z);
            class_243 controlOffsetVec = new class_243((double)controlOffsetX, (double)controlOffsetY, (double)controlOffsetZ);
            client.execute(() -> {
                ChunkedTransfer transfer = new ChunkedTransfer();
                transfer.transferId = transferId;
                transfer.shipId = shipId;
                transfer.isAirship = isAirship;
                transfer.controlPoint = controlPoint;
                transfer.yaw = yaw;
                transfer.armorStandUUID = finalArmorStandUUID;
                transfer.controlOffset = controlOffsetVec;
                transfer.totalBlocks = totalBlocks;
                transfer.blocks = new ArrayList<ShipBlock>();
                transfer.startTime = System.currentTimeMillis();
                activeTransfers.put(transferId, transfer);
            });
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 handleChunkedStart: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void handleChunkedData(class_2540 buf, class_310 client) {
        try {
            String transferId = ShipPacketHandler.readString(buf);
            int chunkIndex = buf.readInt();
            int totalChunks = buf.readInt();
            int blockCount = buf.readInt();
            ArrayList<ShipBlock> chunkBlocks = new ArrayList<ShipBlock>();
            for (int i = 0; i < blockCount; ++i) {
                try {
                    ShipBlock block = new ShipBlock();
                    block.relativeX = buf.readInt();
                    block.relativeY = buf.readInt();
                    block.relativeZ = buf.readInt();
                    block.material = ShipPacketHandler.readString(buf);
                    block.blockData = ShipPacketHandler.readString(buf);
                    if (block.material == null || block.material.isEmpty()) {
                        System.err.println("\u041f\u0440\u043e\u043f\u0443\u0441\u043a \u0431\u043b\u043e\u043a\u0430 \u0441 \u043f\u0443\u0441\u0442\u044b\u043c material");
                        continue;
                    }
                    if (block.blockData != null) {
                        block.blockData = block.blockData.trim();
                        if (block.blockData.isEmpty() || block.blockData.equals("{}")) {
                            block.blockData = null;
                        }
                    }
                    chunkBlocks.add(block);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0431\u043b\u043e\u043a\u0430 #" + i + ": " + e.getMessage());
                }
            }
            client.execute(() -> {
                ChunkedTransfer transfer = activeTransfers.get(transferId);
                if (transfer != null) {
                    transfer.blocks.addAll(chunkBlocks);
                    ++transfer.receivedChunks;
                } else {
                    System.err.println("Transfer \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d: " + transferId);
                }
            });
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 handleChunkedData: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void handleChunkedEnd(class_2540 buf, class_310 client) {
        try {
            String transferId = ShipPacketHandler.readString(buf);
            int totalChunks = buf.readInt();
            client.execute(() -> {
                ChunkedTransfer transfer = activeTransfers.remove(transferId);
                if (transfer != null) {
                    if (transfer.blocks.size() != transfer.totalBlocks) {
                        System.err.println("\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435\u043f\u043e\u043b\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u0440\u0430\u0431\u043b\u044f " + transfer.shipId + "! \u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0431\u043b\u043e\u043a\u043e\u0432: " + transfer.blocks.size() + "/" + transfer.totalBlocks);
                        return;
                    }
                    long validBlocks = transfer.blocks.stream().filter(b -> b.material != null && !b.material.isEmpty()).count();
                    if (validBlocks != (long)transfer.blocks.size()) {
                        System.err.println("\u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415: \u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u043b\u043e\u043a\u0438 \u0438\u043c\u0435\u044e\u0442 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435! \u0412\u0430\u043b\u0438\u0434\u043d\u044b\u0445: " + validBlocks + "/" + transfer.blocks.size());
                    }
                    ActiveShipClient ship = ships.computeIfAbsent(transfer.shipId, k -> new ActiveShipClient());
                    ship.shipId = transfer.shipId;
                    ship.isAirship = transfer.isAirship;
                    boolean shouldUpdatePosition = false;
                    if (ship.controlPoint == null) {
                        shouldUpdatePosition = true;
                    } else {
                        double distance = ship.controlPoint.method_1022(transfer.controlPoint);
                        if (distance > 5.0) {
                            shouldUpdatePosition = true;
                            System.out.println("[CHUNKED] \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0430\u0446\u0438\u044f! dist=" + String.format("%.2f", distance));
                        }
                    }
                    if (shouldUpdatePosition) {
                        ship.previousControlPoint = ship.controlPoint != null ? ship.controlPoint : transfer.controlPoint;
                        ship.controlPoint = transfer.controlPoint;
                        ship.previousYaw = ship.yaw;
                        ship.yaw = transfer.yaw;
                        ship.lastUpdateTime = System.currentTimeMillis();
                    }
                    ship.blocks = transfer.blocks;
                    ship.visible = true;
                    ship.armorStandUUID = null;
                    ship.controlOffset = transfer.controlOffset;
                    ship.needsBlockMapRebuild = true;
                    ShipRenderer.clearCache();
                } else {
                    System.err.println("Transfer \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0438: " + transferId);
                }
            });
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 handleChunkedEnd: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void handleDisableShipPhysics(class_2540 buf, class_310 client) {
        try {
            int durationTicks = buf.readInt();
            client.execute(() -> {
                if (ShipClientHandler.getInstance() != null) {
                    ShipClientHandler.getInstance().disablePhysics(durationTicks);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handlePassengerRelativePositions(class_2540 buf, class_310 client) {
        try {
            String shipId = ShipPacketHandler.readString(buf);
            int count = buf.readInt();
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                ActiveShipClient shipData;
                long mostSig = buf.readLong();
                long leastSig = buf.readLong();
                UUID playerUUID = new UUID(mostSig, leastSig);
                double relX = buf.readDouble();
                double relY = buf.readDouble();
                double relZ = buf.readDouble();
                float relYaw = buf.readFloat();
                float pitch = buf.readFloat();
                boolean isCaptain = buf.readBoolean();
                boolean isMoving = buf.readBoolean();
                PassengerPosCache cache = otherPlayersPositions.computeIfAbsent(playerUUID, k -> new PassengerPosCache());
                cache.targetRelativePosition = new class_243(relX, relY, relZ);
                cache.targetYaw = relYaw;
                cache.targetPitch = pitch;
                cache.shipId = shipId;
                cache.isCaptain = isCaptain;
                cache.isMoving = isMoving;
                cache.lastUpdate = currentTime;
                cache.lastUpdateTime = currentTime;
                if (!isCaptain || (shipData = ships.get(shipId)) == null) continue;
                shipData.captainRelativePosition = new class_243(relX, relY, relZ);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updatePreviousPositionsEndTick() {
        for (ActiveShipClient ship : ships.values()) {
            if (ship.controlPoint == null) continue;
            ship.previousControlPoint = ship.controlPoint;
            ship.previousYaw = ship.yaw;
            ship.previousUpdateTime = ship.lastUpdateTime;
        }
    }

    public static void updatePassengerPositionsTick() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        block0: for (Map.Entry<UUID, PassengerPosCache> entry : otherPlayersPositions.entrySet()) {
            ActiveShipClient ship;
            UUID playerUUID = entry.getKey();
            PassengerPosCache posCache = entry.getValue();
            if (playerUUID.equals(client.field_1724.method_5667()) || posCache.shipId == null || currentTime - posCache.lastUpdateTime > 1000L || (ship = ships.get(posCache.shipId)) == null) continue;
            for (class_742 player : client.field_1687.method_18456()) {
                if (!player.method_5667().equals(playerUUID)) continue;
                ShipPacketHandler.applyShipMovementToPassengerTick(player, ship, posCache);
                continue block0;
            }
        }
    }

    @Deprecated
    public static void updatePassengerPositionsRender(float tickDelta) {
    }

    private static void applyShipMovementToPassengerTick(class_742 player, ActiveShipClient ship, PassengerPosCache posCache) {
        if (posCache.targetRelativePosition == null) {
            return;
        }
        if ("FreeCamera".equals(player.getClass().getSimpleName())) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_243 currentShipPos = ship.controlPoint;
        double currentShipYaw = ship.yaw;
        class_243 relativePos = posCache.isCaptain ? (ship.captainRelativePosition != null ? ship.captainRelativePosition : ship.controlOffset) : posCache.targetRelativePosition;
        class_243 rotatedOffset = ShipPacketHandler.rotateVector(relativePos, currentShipYaw);
        class_243 newWorldPos = currentShipPos.method_1019(rotatedOffset);
        player.method_23327(newWorldPos.field_1352, newWorldPos.field_1351, newWorldPos.field_1350);
        player.field_6014 = newWorldPos.field_1352;
        player.field_6036 = newWorldPos.field_1351;
        player.field_5969 = newWorldPos.field_1350;
        float finalYaw = (float)currentShipYaw + posCache.targetYaw;
        float finalPitch = posCache.targetPitch;
        player.method_36456(finalYaw);
        player.method_5636(finalYaw);
        player.method_5847(finalYaw);
        player.method_36457(finalPitch);
        player.field_5982 = finalYaw;
        player.field_6004 = finalPitch;
        player.field_6220 = finalYaw;
        player.field_6259 = finalYaw;
        if (!posCache.isMoving) {
            player.field_6225 = 0.0f;
            player.field_6211 = 0.0f;
            player.field_6249 = 0.0f;
            player.field_5973 = 0.0f;
            player.field_6039 = 0.0f;
        }
    }

    @Deprecated
    private static void applyShipMovementToPassengerRender(class_742 player, ActiveShipClient ship, PassengerPosCache posCache, float tickDelta) {
    }

    private static void handleShipData(class_2540 buf, class_310 client) {
        try {
            String shipId = ShipPacketHandler.readString(buf);
            boolean isAirship = buf.readBoolean();
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float yaw = buf.readFloat();
            UUID armorStandUUID = null;
            boolean hasArmorStand = buf.readBoolean();
            if (hasArmorStand) {
                long mostSig = buf.readLong();
                long leastSig = buf.readLong();
                armorStandUUID = new UUID(mostSig, leastSig);
            }
            int blockCount = buf.readInt();
            ArrayList<ShipBlock> blocks = new ArrayList<ShipBlock>();
            for (int i = 0; i < blockCount; ++i) {
                try {
                    ShipBlock block = new ShipBlock();
                    block.relativeX = buf.readInt();
                    block.relativeY = buf.readInt();
                    block.relativeZ = buf.readInt();
                    block.material = ShipPacketHandler.readString(buf);
                    block.blockData = ShipPacketHandler.readString(buf);
                    if (block.material == null || block.material.isEmpty()) {
                        System.err.println("\u041f\u0440\u043e\u043f\u0443\u0441\u043a \u0431\u043b\u043e\u043a\u0430 \u0441 \u043f\u0443\u0441\u0442\u044b\u043c material");
                        continue;
                    }
                    if (block.blockData != null) {
                        block.blockData = block.blockData.trim();
                        if (block.blockData.isEmpty() || block.blockData.equals("{}")) {
                            block.blockData = null;
                        }
                    }
                    blocks.add(block);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0431\u043b\u043e\u043a\u0430 #" + i + ": " + e.getMessage());
                }
            }
            int controlOffsetX = buf.readInt();
            int controlOffsetY = buf.readInt();
            int controlOffsetZ = buf.readInt();
            class_243 controlOffsetVec = new class_243((double)controlOffsetX, (double)controlOffsetY, (double)controlOffsetZ);
            UUID finalArmorStandUUID = armorStandUUID;
            boolean finalIsAirship = isAirship;
            client.execute(() -> {
                ActiveShipClient ship = ships.computeIfAbsent(shipId, k -> new ActiveShipClient());
                ship.shipId = shipId;
                ship.isAirship = finalIsAirship;
                class_243 newPos = new class_243(x, y, z);
                boolean shouldUpdatePosition = false;
                if (ship.controlPoint == null) {
                    shouldUpdatePosition = true;
                } else {
                    double distance = ship.controlPoint.method_1022(newPos);
                    if (distance > 5.0) {
                        shouldUpdatePosition = true;
                        System.out.println("[SHIP-DATA] \u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0430\u0446\u0438\u044f! dist=" + String.format("%.2f", distance));
                    }
                }
                if (shouldUpdatePosition) {
                    ship.previousControlPoint = ship.controlPoint != null ? ship.controlPoint : newPos;
                    ship.controlPoint = newPos;
                    ship.previousYaw = ship.yaw;
                    ship.yaw = yaw;
                    ship.lastUpdateTime = System.currentTimeMillis();
                }
                ship.blocks = blocks;
                ship.visible = true;
                ship.armorStandUUID = null;
                ship.controlOffset = controlOffsetVec;
                ship.needsBlockMapRebuild = true;
                ShipRenderer.clearCache();
            });
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 handleShipData: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void handleShipPosition(class_2540 buf, class_310 client) {
        try {
            String shipId = ShipPacketHandler.readString(buf);
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            double yaw = buf.readDouble();
            double speed = buf.readDouble();
            double angularVelocity = buf.readDouble();
            client.execute(() -> {
                double dist;
                ActiveShipClient ship = ships.get(shipId);
                if (ship == null) {
                    return;
                }
                class_243 oldPos = ship.controlPoint;
                class_243 newPos = new class_243(x, y, z);
                boolean shouldUpdate = true;
                if (oldPos != null && (dist = oldPos.method_1022(newPos)) > 0.01) {
                    System.out.println("[POS-PKT] dist=" + String.format("%.4f", dist) + " | speed=" + String.format("%.4f", speed));
                }
                long now = System.currentTimeMillis();
                ship.previousControlPoint = ship.controlPoint != null ? ship.controlPoint : newPos;
                ship.previousYaw = ship.yaw;
                ship.previousUpdateTime = ship.lastUpdateTime;
                ship.controlPoint = newPos;
                ship.yaw = yaw;
                ship.serverSpeed = speed;
                ship.serverAngularVelocity = angularVelocity;
                ship.lastUpdateTime = now;
                ShipDebugLogger.logPacketReceived(shipId, newPos, ship.previousControlPoint);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleControlStart(class_2540 buf, class_310 client) {
        try {
            String shipId = ShipPacketHandler.readString(buf);
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            client.execute(() -> {
                controlledShipId = shipId;
                captainOffset = class_243.field_1353;
                if (ShipClientHandler.getInstance() != null) {
                    ShipClientHandler.getInstance().handleControlStart(shipId, class_243.field_1353);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleControlStartWithOffset(class_2540 buf, class_310 client) {
        try {
            String shipId = ShipPacketHandler.readString(buf);
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            double offsetX = buf.readDouble();
            double offsetY = buf.readDouble();
            double offsetZ = buf.readDouble();
            client.execute(() -> {
                controlledShipId = shipId;
                captainOffset = new class_243(offsetX, offsetY, offsetZ);
                if (ShipClientHandler.getInstance() != null) {
                    ShipClientHandler.getInstance().handleControlStart(shipId, captainOffset);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleControlStop(class_2540 buf, class_310 client) {
        client.execute(() -> {
            if (ShipClientHandler.getInstance() != null) {
                ShipClientHandler.getInstance().handleControlStop();
            }
            controlledShipId = null;
            captainOffset = null;
        });
    }

    private static void handleShowBoundaries(class_2540 buf, class_310 client) {
        try {
            String orientation;
            double p1X = buf.readDouble();
            double p1Y = buf.readDouble();
            double p1Z = buf.readDouble();
            double p2X = buf.readDouble();
            double p2Y = buf.readDouble();
            double p2Z = buf.readDouble();
            double cpX = buf.readDouble();
            double cpY = buf.readDouble();
            double cpZ = buf.readDouble();
            byte orientationByte = buf.readByte();
            String finalOrientation = orientation = (switch (orientationByte) {
                case 0 -> "EAST";
                case 1 -> "SOUTH";
                case 2 -> "WEST";
                case 3 -> "NORTH";
                default -> "EAST";
            });
            client.execute(() -> ShipBoundaryRenderer.showBoundaries(new class_243(p1X, p1Y, p1Z), new class_243(p2X, p2Y, p2Z), new class_243(cpX, cpY, cpZ), finalOrientation));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleHideBoundaries(class_2540 buf, class_310 client) {
        client.execute(ShipBoundaryRenderer::hideBoundaries);
    }

    private static void handleShipRemove(class_2540 buf, class_310 client) {
        try {
            String shipId = ShipPacketHandler.readString(buf);
            client.execute(() -> ships.remove(shipId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void handleShipOrientation(class_2540 buf, class_310 client) {
        try {
            String shipId = ShipPacketHandler.readString(buf);
            String orientation = ShipPacketHandler.readString(buf);
            client.execute(() -> {
                ActiveShipClient ship = ships.get(shipId);
                if (ship != null) {
                    ship.orientation = orientation;
                    if (ShipClientHandler.getInstance() != null && shipId.equals(controlledShipId)) {
                        ShipClientHandler.getInstance().setShipOrientation(orientation);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, ActiveShipClient> getShips() {
        return ships;
    }

    public static String getControlledShipId() {
        return controlledShipId;
    }

    public static class_243 getCaptainOffset() {
        return captainOffset != null ? captainOffset : class_243.field_1353;
    }

    public static boolean isPassengerOnShip(UUID playerUUID) {
        if (playerUUID == null) {
            return false;
        }
        return otherPlayersPositions.containsKey(playerUUID);
    }

    public static Map<UUID, PassengerPosCache> getOtherPlayersPositions() {
        return otherPlayersPositions;
    }

    public static class_243 getShipOffsetForPlayer(UUID playerUUID, float tickDelta) {
        PassengerPosCache cache = otherPlayersPositions.get(playerUUID);
        if (cache == null || cache.shipId == null) {
            return null;
        }
        ActiveShipClient ship = ships.get(cache.shipId);
        if (ship == null) {
            return null;
        }
        class_310 client = class_310.method_1551();
        class_1297 armorStand = ship.getArmorStand(client);
        class_243 shipWorldPos = armorStand != null ? armorStand.method_30950(tickDelta) : ship.controlPoint;
        return shipWorldPos;
    }

    public static boolean isPlayerOnShip(UUID playerUUID) {
        if (playerUUID == null) {
            return false;
        }
        PassengerPosCache cache = otherPlayersPositions.get(playerUUID);
        return cache != null && cache.shipId != null;
    }

    public static void cleanupOldPositions() {
        long now = System.currentTimeMillis();
        otherPlayersPositions.entrySet().removeIf(entry -> now - ((PassengerPosCache)entry.getValue()).lastUpdate > 2000L);
    }

    public static void cleanupOldTransfers() {
        long now = System.currentTimeMillis();
        activeTransfers.entrySet().removeIf(entry -> {
            boolean timeout;
            boolean bl = timeout = now - ((ChunkedTransfer)entry.getValue()).startTime > 30000L;
            if (timeout) {
                System.err.println("Transfer timeout: " + (String)entry.getKey());
            }
            return timeout;
        });
    }

    public static void clearAllData() {
        ships.clear();
        otherPlayersPositions.clear();
        activeTransfers.clear();
        controlledShipId = null;
        captainOffset = null;
    }

    private static void handleHeadRotationLock(class_2540 buf, class_310 client) {
        try {
            long mostSig = buf.readLong();
            long leastSig = buf.readLong();
            UUID playerUUID = new UUID(mostSig, leastSig);
            boolean block = buf.readBoolean();
            client.execute(() -> {
                if (block) {
                    headRotationLocked.add(playerUUID);
                } else {
                    headRotationLocked.remove(playerUUID);
                }
            });
        }
        catch (Exception e) {
            System.err.println("[HeadLock] ERROR processing packet!");
            e.printStackTrace();
        }
    }

    public static boolean isHeadRotationLocked(UUID playerUUID) {
        return headRotationLocked.contains(playerUUID);
    }

    private static void handleSteeringWheelRotation(class_2540 buf, class_310 client) {
        try {
            String shipId = ShipPacketHandler.readString(buf);
            int turnDirection = buf.readInt();
            client.execute(() -> {
                ActiveShipClient ship = ships.get(shipId);
                if (ship != null) {
                    ship.steeringWheelRotation = turnDirection;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class_243 rotateVector(class_243 vec, double yaw) {
        double rad = Math.toRadians(yaw);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        return new class_243(vec.field_1352 * cos - vec.field_1350 * sin, vec.field_1351, vec.field_1352 * sin + vec.field_1350 * cos);
    }

    public void handleShipPacket(class_310 client, class_2540 buf) {
        try {
            byte packetType = buf.readByte();
            switch (packetType) {
                case 0: {
                    ShipPacketHandler.handleShipData(buf, client);
                    break;
                }
                case 1: {
                    ShipPacketHandler.handleShipPosition(buf, client);
                    break;
                }
                default: {
                    System.err.println("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043f\u0430\u043a\u0435\u0442\u0430 \u043a\u043e\u0440\u0430\u0431\u043b\u044f: " + packetType);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u0430\u043a\u0435\u0442\u0430 \u043a\u043e\u0440\u0430\u0431\u043b\u044f: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void handleControlStart(class_310 client, class_2540 buf) {
        ShipPacketHandler.handleControlStart(buf, client);
    }

    public void handleControlStop(class_310 client) {
        ShipPacketHandler.handleControlStop(null, client);
    }

    public void handlePositionUpdate(class_310 client, class_2540 buf) {
        ShipPacketHandler.handleShipPosition(buf, client);
    }

    public void handlePassengerSync(class_310 client, class_2540 buf) {
        ShipPacketHandler.handlePassengerRelativePositions(buf, client);
    }

    public static void setExtrapolationAmount(double amount) {
        extrapolationAmount = Math.max(0.0, Math.min(5.0, amount));
    }

    public static double getExtrapolationAmount() {
        return extrapolationAmount;
    }

    public static void increaseExtrapolation(double delta) {
        ShipPacketHandler.setExtrapolationAmount(extrapolationAmount + delta);
    }

    public static void decreaseExtrapolation(double delta) {
        ShipPacketHandler.setExtrapolationAmount(extrapolationAmount - delta);
    }

    public static void setSmoothingFactor(double factor) {
        smoothingFactor = Math.max(0.01, Math.min(1.0, factor));
    }

    public static double getSmoothingFactor() {
        return smoothingFactor;
    }

    public static void increaseSmoothing(double delta) {
        ShipPacketHandler.setSmoothingFactor(smoothingFactor + delta);
    }

    public static void decreaseSmoothing(double delta) {
        ShipPacketHandler.setSmoothingFactor(smoothingFactor - delta);
    }

    public static class ShipBlock {
        public int relativeX;
        public int relativeY;
        public int relativeZ;
        public String material;
        public String blockData;
    }

    public static class PassengerPosCache {
        public class_243 targetRelativePosition = null;
        public float targetYaw = 0.0f;
        public float targetPitch = 0.0f;
        public String shipId = null;
        public boolean isCaptain = false;
        public boolean isMoving = false;
        public long lastUpdate = System.currentTimeMillis();
        public long lastUpdateTime = System.currentTimeMillis();
    }

    public static class ActiveShipClient {
        public String shipId;
        public class_243 controlPoint;
        public class_243 previousControlPoint;
        public double yaw;
        public double previousYaw;
        public String orientation = "EAST";
        public List<ShipBlock> blocks;
        public boolean visible = true;
        public boolean isAirship = false;
        public UUID armorStandUUID = null;
        private class_1297 cachedArmorStand = null;
        private long armorStandCacheTime = 0L;
        private static final long ARMOR_STAND_CACHE_DURATION = 1000L;
        public class_243 controlOffset = class_243.field_1353;
        public class_243 captainRelativePosition = null;
        public int steeringWheelRotation = 0;
        public float previousSteeringRotation = 0.0f;
        public long lastUpdateTime = System.currentTimeMillis();
        public long previousUpdateTime = System.currentTimeMillis();
        private static final long INTERPOLATION_WINDOW = 200L;
        public double serverSpeed = 0.0;
        public double serverAngularVelocity = 0.0;
        public class_243 smoothedPosition = null;
        public double smoothedYaw = 0.0;
        public transient Map<class_2338, ShipBlock> blockMapCache = null;
        public transient boolean needsBlockMapRebuild = true;

        public class_243 getInterpolatedPosition(float tickDelta) {
            if (this.controlPoint == null) {
                return class_243.field_1353;
            }
            if (useRawPosition) {
                return this.controlPoint;
            }
            if (this.previousControlPoint == null) {
                return this.controlPoint;
            }
            long now = System.currentTimeMillis();
            long timeSince = now - this.lastUpdateTime;
            double progress = (double)timeSince / 50.0;
            progress = Math.min(progress, 1.0);
            class_243 interpolated = new class_243(class_3532.method_16436((double)progress, (double)this.previousControlPoint.field_1352, (double)this.controlPoint.field_1352), class_3532.method_16436((double)progress, (double)this.previousControlPoint.field_1351, (double)this.controlPoint.field_1351), class_3532.method_16436((double)progress, (double)this.previousControlPoint.field_1350, (double)this.controlPoint.field_1350));
            if (this.smoothedPosition == null) {
                this.smoothedPosition = interpolated;
            } else {
                double distance = interpolated.method_1022(this.smoothedPosition);
                double factor = distance < 0.05 ? 0.05 : (distance < 0.2 ? 0.1 : 0.2);
                this.smoothedPosition = new class_243(this.smoothedPosition.field_1352 + (interpolated.field_1352 - this.smoothedPosition.field_1352) * factor, this.smoothedPosition.field_1351 + (interpolated.field_1351 - this.smoothedPosition.field_1351) * factor, this.smoothedPosition.field_1350 + (interpolated.field_1350 - this.smoothedPosition.field_1350) * factor);
            }
            return this.smoothedPosition;
        }

        public double getInterpolatedYaw(float tickDelta) {
            double interpolatedYaw;
            double yawDiff;
            if (useRawPosition) {
                return this.yaw;
            }
            if (this.previousYaw == 0.0) {
                return this.yaw;
            }
            long now = System.currentTimeMillis();
            long timeSince = now - this.lastUpdateTime;
            double progress = (double)timeSince / 50.0;
            progress = Math.min(progress, 1.0);
            for (yawDiff = this.yaw - this.previousYaw; yawDiff > 180.0; yawDiff -= 360.0) {
            }
            while (yawDiff < -180.0) {
                yawDiff += 360.0;
            }
            for (interpolatedYaw = this.previousYaw + yawDiff * progress; interpolatedYaw > 180.0; interpolatedYaw -= 360.0) {
            }
            while (interpolatedYaw < -180.0) {
                interpolatedYaw += 360.0;
            }
            if (this.smoothedYaw == 0.0) {
                this.smoothedYaw = interpolatedYaw;
            } else {
                double yawError;
                for (yawError = interpolatedYaw - this.smoothedYaw; yawError > 180.0; yawError -= 360.0) {
                }
                while (yawError < -180.0) {
                    yawError += 360.0;
                }
                this.smoothedYaw += yawError * 0.07;
                while (this.smoothedYaw > 180.0) {
                    this.smoothedYaw -= 360.0;
                }
                while (this.smoothedYaw < -180.0) {
                    this.smoothedYaw += 360.0;
                }
            }
            return this.smoothedYaw;
        }

        public class_1297 getArmorStand(class_310 client) {
            if (this.armorStandUUID == null || client.field_1687 == null) {
                return null;
            }
            long now = System.currentTimeMillis();
            if (this.cachedArmorStand != null && !this.cachedArmorStand.method_31481() && now - this.armorStandCacheTime < 1000L) {
                return this.cachedArmorStand;
            }
            for (class_1297 entity : client.field_1687.method_18112()) {
                if (!entity.method_5667().equals(this.armorStandUUID)) continue;
                this.cachedArmorStand = entity;
                this.armorStandCacheTime = now;
                return entity;
            }
            this.cachedArmorStand = null;
            return null;
        }
    }

    private static class ChunkedTransfer {
        String transferId;
        String shipId;
        boolean isAirship = false;
        class_243 controlPoint;
        double yaw;
        UUID armorStandUUID;
        class_243 controlOffset;
        int totalBlocks;
        List<ShipBlock> blocks;
        int receivedChunks = 0;
        long startTime;

        private ChunkedTransfer() {
        }
    }
}

