/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.votive.airships.client.ships.ShipClientHandler;
import com.votive.airships.client.ships.ShipClientPacketSender;
import com.votive.airships.client.ships.ShipPacketHandler;
import java.util.Map;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ShipInteractionHandler {
    private static ShipInteractionHandler instance;
    private final class_310 client = class_310.method_1551();
    private static final double MAX_INTERACTION_DISTANCE = 5.0;

    public static void initialize() {
        if (instance == null) {
            instance = new ShipInteractionHandler();
        }
    }

    public static ShipInteractionHandler getInstance() {
        return instance;
    }

    private ShipInteractionHandler() {
    }

    public boolean handleClick(boolean isLeftClick) {
        class_746 player = this.client.field_1724;
        if (player == null) {
            return false;
        }
        ShipRaycastResult raycast = this.raycastShip(player);
        if (raycast == null) {
            return false;
        }
        boolean isSneaking = player.method_5715();
        if (!isLeftClick && isSneaking) {
            this.handlePlaceShip(raycast);
            return true;
        }
        if (!isLeftClick && !isSneaking) {
            this.handleStartControl(raycast);
            return true;
        }
        if (isLeftClick && !isSneaking) {
            ShipPacketHandler.ActiveShipClient ship = raycast.ship;
            if (ship.isAirship) {
                this.handleOpenMenu(raycast);
                return true;
            }
        }
        return false;
    }

    private ShipRaycastResult raycastShip(class_746 player) {
        class_243 cameraPos = player.method_5836(1.0f);
        class_243 lookVec = player.method_5828(1.0f);
        class_243 rayEnd = cameraPos.method_1019(lookVec.method_1021(5.0));
        ShipRaycastResult closestHit = null;
        double closestDistance = Double.MAX_VALUE;
        Map<String, ShipPacketHandler.ActiveShipClient> ships = ShipPacketHandler.getShips();
        for (Map.Entry<String, ShipPacketHandler.ActiveShipClient> entry : ships.entrySet()) {
            double distance;
            ShipRaycastResult hit;
            double distanceToShip;
            String shipId = entry.getKey();
            ShipPacketHandler.ActiveShipClient ship = entry.getValue();
            if (ship.controlPoint == null || ship.blocks == null || (distanceToShip = cameraPos.method_1022(ship.controlPoint)) > 15.0 || (hit = this.raycastShipBlocks(ship, shipId, cameraPos, rayEnd)) == null || !((distance = cameraPos.method_1022(hit.hitPosition)) < closestDistance)) continue;
            closestDistance = distance;
            closestHit = hit;
        }
        return closestHit;
    }

    private ShipRaycastResult raycastShipBlocks(ShipPacketHandler.ActiveShipClient ship, String shipId, class_243 rayStart, class_243 rayEnd) {
        class_243 controlOffset;
        class_243 rotatedOffset;
        class_243 controlWorldPos;
        class_243 hitPos;
        class_243 shipPos = ship.controlPoint;
        double shipYaw = ship.yaw;
        if (ship.controlOffset != null && (hitPos = this.raycastBox(rayStart, rayEnd, controlWorldPos = shipPos.method_1019(rotatedOffset = this.rotateVector(controlOffset = ship.controlOffset, shipYaw)), 0.5)) != null) {
            return new ShipRaycastResult(shipId, ship, hitPos, true);
        }
        for (int i = 0; i < ship.blocks.size(); i += 2) {
            ShipPacketHandler.ShipBlock block = ship.blocks.get(i);
            class_243 blockLocalPos = new class_243((double)block.relativeX + 0.5, (double)block.relativeY + 0.5, (double)block.relativeZ + 0.5);
            class_243 rotatedPos = this.rotateVector(blockLocalPos, shipYaw);
            class_243 blockWorldPos = shipPos.method_1019(rotatedPos);
            class_243 hitPos2 = this.raycastBox(rayStart, rayEnd, blockWorldPos, 0.5);
            if (hitPos2 == null) continue;
            return new ShipRaycastResult(shipId, ship, hitPos2, false);
        }
        return null;
    }

    private class_243 raycastBox(class_243 rayStart, class_243 rayEnd, class_243 boxCenter, double halfSize) {
        class_243 min = boxCenter.method_1023(halfSize, halfSize, halfSize);
        class_243 max = boxCenter.method_1031(halfSize, halfSize, halfSize);
        class_243 direction = rayEnd.method_1020(rayStart).method_1029();
        double length = rayStart.method_1022(rayEnd);
        for (double t = 0.0; t < length; t += 0.1) {
            class_243 point = rayStart.method_1019(direction.method_1021(t));
            if (!(point.field_1352 >= min.field_1352) || !(point.field_1352 <= max.field_1352) || !(point.field_1351 >= min.field_1351) || !(point.field_1351 <= max.field_1351) || !(point.field_1350 >= min.field_1350) || !(point.field_1350 <= max.field_1350)) continue;
            return point;
        }
        return null;
    }

    private class_243 rotateVector(class_243 vector, double yaw) {
        double rad = Math.toRadians(yaw);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = vector.field_1352 * cos - vector.field_1350 * sin;
        double z = vector.field_1352 * sin + vector.field_1350 * cos;
        return new class_243(x, vector.field_1351, z);
    }

    private void handlePlaceShip(ShipRaycastResult raycast) {
        ShipClientPacketSender.sendShipInteraction(raycast.shipId, ShipClientPacketSender.InteractionType.PLACE, raycast.hitPosition);
    }

    private void handleStartControl(ShipRaycastResult raycast) {
        if (ShipClientHandler.getInstance().isControllingShip()) {
            return;
        }
        ShipClientPacketSender.sendShipInteraction(raycast.shipId, ShipClientPacketSender.InteractionType.START_CONTROL, raycast.hitPosition);
    }

    private void handleOpenMenu(ShipRaycastResult raycast) {
        ShipClientPacketSender.sendShipInteraction(raycast.shipId, ShipClientPacketSender.InteractionType.OPEN_MENU, raycast.hitPosition);
    }

    private static class ShipRaycastResult {
        final String shipId;
        final ShipPacketHandler.ActiveShipClient ship;
        final class_243 hitPosition;
        final boolean isControlPoint;

        ShipRaycastResult(String shipId, ShipPacketHandler.ActiveShipClient ship, class_243 hitPosition, boolean isControlPoint) {
            this.shipId = shipId;
            this.ship = ship;
            this.hitPosition = hitPosition;
            this.isControlPoint = isControlPoint;
        }
    }
}

