/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.mojang.blaze3d.systems.RenderSystem;
import com.votive.airships.client.ships.ShipPacketHandler;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import org.joml.Matrix4f;

public class ShipHitboxRenderer {
    private static final class_310 client = class_310.method_1551();
    private static boolean debugMode = false;
    private static long lastToggleTime = 0L;

    public static void register() {
        WorldRenderEvents.AFTER_ENTITIES.register(ShipHitboxRenderer::renderHitboxes);
    }

    public static void tick() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(class_4587 matrices) {
        if (!debugMode || ShipHitboxRenderer.client.field_1687 == null || ShipHitboxRenderer.client.field_1724 == null) {
            return;
        }
        class_243 cameraPos = ShipHitboxRenderer.client.field_1773.method_19418().method_19326();
        float tickDelta = client.method_1488();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)2.0f);
        try {
            for (ShipPacketHandler.ActiveShipClient ship : ShipPacketHandler.getShips().values()) {
                double distance;
                class_1297 armorStand;
                if (!ship.visible || ship.blocks == null || ship.blocks.isEmpty()) continue;
                class_243 shipPos = ship.controlPoint;
                double shipYaw = ship.yaw;
                if (ship.armorStandUUID != null && (armorStand = ship.getArmorStand(client)) != null) {
                    shipPos = ship.getInterpolatedPosition(tickDelta);
                    shipYaw = ship.getInterpolatedYaw(tickDelta);
                }
                if ((distance = shipPos.method_1022(cameraPos)) > 256.0) continue;
                matrices.method_22903();
                matrices.method_22904(shipPos.field_1352 - cameraPos.field_1352, shipPos.field_1351 - cameraPos.field_1351, shipPos.field_1350 - cameraPos.field_1350);
                matrices.method_22907(class_7833.field_40716.rotationDegrees((float)(-shipYaw)));
                matrices.method_22904(-0.5, 0.0, -0.5);
                for (ShipPacketHandler.ShipBlock block : ship.blocks) {
                    try {
                        class_2680 state = ShipHitboxRenderer.getBlockState(block.material, block.blockData);
                        class_265 shape = state.method_26220(null, null);
                        matrices.method_22903();
                        matrices.method_22904((double)block.relativeX - ship.controlOffset.field_1352, (double)block.relativeY - ship.controlOffset.field_1351, (double)block.relativeZ - ship.controlOffset.field_1350);
                        shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> ShipHitboxRenderer.renderBox(matrices, buffer, tessellator, minX, minY, minZ, maxX, maxY, maxZ));
                        matrices.method_22909();
                    }
                    catch (Exception exception) {}
                }
                matrices.method_22909();
            }
        }
        catch (Exception e) {
            System.err.println("[VotiveRP] Exception in ShipHitboxRenderer");
            e.printStackTrace();
        }
        finally {
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.lineWidth((float)1.0f);
        }
    }

    public static void toggleDebugMode() {
        long now = System.currentTimeMillis();
        if (now - lastToggleTime < 300L) {
            return;
        }
        debugMode = !debugMode;
        lastToggleTime = now;
        if (ShipHitboxRenderer.client.field_1724 != null) {
            String message = debugMode ? "\u00a7a[DEBUG] \u0420\u0435\u043d\u0434\u0435\u0440 \u0445\u0438\u0442\u0431\u043e\u043a\u0441\u043e\u0432 \u043a\u043e\u0440\u0430\u0431\u043b\u0435\u0439: \u00a7f\u0412\u041a\u041b\u042e\u0427\u0415\u041d" : "\u00a7c[DEBUG] \u0420\u0435\u043d\u0434\u0435\u0440 \u0445\u0438\u0442\u0431\u043e\u043a\u0441\u043e\u0432 \u043a\u043e\u0440\u0430\u0431\u043b\u0435\u0439: \u00a7f\u0412\u042b\u041a\u041b\u042e\u0427\u0415\u041d";
            ShipHitboxRenderer.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), true);
        }
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderHitboxes(WorldRenderContext context) {
        if (!debugMode || ShipHitboxRenderer.client.field_1687 == null || ShipHitboxRenderer.client.field_1724 == null) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        class_243 cameraPos = context.camera().method_19326();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.lineWidth((float)2.0f);
        try {
            for (ShipPacketHandler.ActiveShipClient ship : ShipPacketHandler.getShips().values()) {
                double distance;
                class_1297 armorStand;
                if (!ship.visible || ship.blocks == null || ship.blocks.isEmpty()) continue;
                class_243 shipPos = ship.controlPoint;
                double shipYaw = ship.yaw;
                if (ship.armorStandUUID != null && (armorStand = ship.getArmorStand(client)) != null) {
                    shipPos = armorStand.method_30950(context.tickDelta());
                    shipYaw = armorStand.method_36454();
                }
                if ((distance = shipPos.method_1022(cameraPos)) > 256.0) continue;
                matrices.method_22903();
                matrices.method_22904(shipPos.field_1352 - cameraPos.field_1352, shipPos.field_1351 - cameraPos.field_1351, shipPos.field_1350 - cameraPos.field_1350);
                matrices.method_22907(class_7833.field_40716.rotationDegrees((float)(-shipYaw)));
                matrices.method_22904(-0.5, 0.0, -0.5);
                boolean isFirstBlock = true;
                for (ShipPacketHandler.ShipBlock block : ship.blocks) {
                    try {
                        class_2680 state = ShipHitboxRenderer.getBlockState(block.material, block.blockData);
                        class_265 shape = state.method_26220(null, null);
                        matrices.method_22903();
                        matrices.method_22904((double)block.relativeX - ship.controlOffset.field_1352, (double)block.relativeY - ship.controlOffset.field_1351, (double)block.relativeZ - ship.controlOffset.field_1350);
                        shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> ShipHitboxRenderer.renderBox(matrices, buffer, tessellator, minX, minY, minZ, maxX, maxY, maxZ));
                        matrices.method_22909();
                    }
                    catch (Exception exception) {}
                }
                matrices.method_22909();
            }
        }
        catch (Exception e) {
            System.err.println("[VotiveRP] Exception in ShipHitboxRenderer");
            e.printStackTrace();
        }
        finally {
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.lineWidth((float)1.0f);
        }
    }

    private static void renderBox(class_4587 matrices, class_287 buffer, class_289 tessellator, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        float r = 0.0f;
        float g = 1.0f;
        float b = 0.0f;
        float a = 0.8f;
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        buffer.method_22918(matrix, (float)minX, (float)minY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)minY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)minY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)minY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)minY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)minY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)minY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)minY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)maxY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)maxY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)maxY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)maxY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)maxY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)maxY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)maxY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)maxY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)minY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)maxY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)minY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)maxY, (float)minZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)minY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)maxX, (float)maxY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)minY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)minX, (float)maxY, (float)maxZ).method_22915(r, g, b, a).method_1344();
        tessellator.method_1350();
    }

    private static class_243 rotateControlOffset(class_243 controlOffset, String orientation) {
        int rotation;
        switch (orientation) {
            case "SOUTH": {
                int n = 0;
                break;
            }
            case "WEST": {
                int n = 1;
                break;
            }
            case "NORTH": {
                int n = 2;
                break;
            }
            case "EAST": {
                int n = 3;
                break;
            }
            default: {
                int n = rotation = 0;
            }
        }
        if (rotation == 0) {
            return controlOffset;
        }
        double x = controlOffset.field_1352;
        double y = controlOffset.field_1351;
        double z = controlOffset.field_1350;
        return switch (rotation) {
            case 1 -> new class_243(-z, y, x);
            case 2 -> new class_243(-x, y, -z);
            case 3 -> new class_243(z, y, -x);
            default -> new class_243(x, y, z);
        };
    }

    private static class_2680 getBlockState(String material, String blockData) {
        try {
            String materialName = material.toLowerCase();
            class_2960 id = materialName.contains(":") ? new class_2960(materialName) : new class_2960("minecraft", materialName);
            return ((class_2248)class_7923.field_41175.method_10223(id)).method_9564();
        }
        catch (Exception e) {
            return class_2246.field_10340.method_9564();
        }
    }
}

