/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class ShipDebugLogger {
    private static boolean enabled = true;
    private static long lastLogTime = 0L;
    private static int packetCount = 0;
    private static class_243 lastShipPos = null;
    private static class_243 lastPlayerPos = null;
    private static PrintWriter fileWriter = null;
    private static File logFile = null;

    private static void log(String message) {
        System.out.println(message);
        if (fileWriter != null) {
            fileWriter.println(message);
        }
    }

    public static void logPacketReceived(String shipId, class_243 newPos, class_243 previous) {
        if (!enabled) {
            return;
        }
        ++packetCount;
        long now = System.currentTimeMillis();
        long timeSinceLast = now - lastLogTime;
        if (fileWriter != null) {
            fileWriter.printf("[PACKET] time=%d | ship=%s | pos=(%.4f, %.4f, %.4f) | prev=(%.4f, %.4f, %.4f) | delta=%.4f%n", now, shipId.substring(0, 8), newPos.field_1352, newPos.field_1351, newPos.field_1350, previous != null ? previous.field_1352 : 0.0, previous != null ? previous.field_1351 : 0.0, previous != null ? previous.field_1350 : 0.0, previous != null ? newPos.method_1022(previous) : 0.0);
        }
        if (timeSinceLast >= 1000L) {
            double distance = lastShipPos != null && newPos != null ? lastShipPos.method_1022(newPos) : 0.0;
            String stats = String.format("[SHIP-DEBUG] \u041f\u0430\u043a\u0435\u0442\u043e\u0432 \u0437\u0430 \u0441\u0435\u043a\u0443\u043d\u0434\u0443: %d | \u041f\u0440\u043e\u0439\u0434\u0435\u043d\u043e: %.4f \u0431\u043b\u043e\u043a\u043e\u0432 | \u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b: %dms", packetCount, distance, timeSinceLast / (long)packetCount);
            ShipDebugLogger.log(stats);
            lastLogTime = now;
            packetCount = 0;
        }
        lastShipPos = newPos;
    }

    public static void logInterpolation(String type, double progress, class_243 previous, class_243 current, class_243 result) {
        if (!enabled || fileWriter == null) {
            return;
        }
        long now = System.currentTimeMillis();
        fileWriter.printf("[INTERP-%s] time=%d | progress=%.4f | prev=(%.4f,%.4f,%.4f) | curr=(%.4f,%.4f,%.4f) | result=(%.4f,%.4f,%.4f)%n", type, now, progress, previous.field_1352, previous.field_1351, previous.field_1350, current.field_1352, current.field_1351, current.field_1350, result.field_1352, result.field_1351, result.field_1350);
    }

    public static void logPlayerUpdate(String source, class_243 oldPos, class_243 newPos) {
        if (!enabled || fileWriter == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        long now = System.currentTimeMillis();
        double distance = oldPos != null ? oldPos.method_1022(newPos) : 0.0;
        fileWriter.printf("[PLAYER-%s] time=%d | moved=%.4f | pos=(%.4f,%.4f,%.4f) | prevX==X: %b%n", source, now, distance, newPos.field_1352, newPos.field_1351, newPos.field_1350, Math.abs(client.field_1724.field_6014 - client.field_1724.method_23317()) < 0.001);
        lastPlayerPos = newPos;
    }

    public static void logRender(String shipId, class_243 renderPos, float tickDelta) {
        if (!enabled || fileWriter == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now % 166L < 16L) {
            fileWriter.printf("[RENDER] time=%d | tickDelta=%.4f | pos=(%.4f,%.4f,%.4f)%n", now, Float.valueOf(tickDelta), renderPos.field_1352, renderPos.field_1351, renderPos.field_1350);
        }
    }

    public static void setEnabled(boolean enable) {
        enabled = enable;
        String msg = enable ? "[SHIP-DEBUG] \u041b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0412\u041a\u041b\u042e\u0427\u0415\u041d\u041e" : "[SHIP-DEBUG] \u041b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0412\u042b\u041a\u041b\u042e\u0427\u0415\u041d\u041e";
        ShipDebugLogger.log(msg);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void logPassenger(String message) {
        ShipDebugLogger.log(message);
    }

    public static void logServer(String message) {
        ShipDebugLogger.log("[SERVER] " + message);
    }

    public static void shutdown() {
        if (fileWriter != null) {
            fileWriter.println();
            fileWriter.println("=".repeat(80));
            fileWriter.println("LOG END - " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            fileWriter.println("=".repeat(80));
            fileWriter.close();
            System.out.println("[ShipDebugLogger] \u041b\u043e\u0433 \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d: " + logFile.getAbsolutePath());
        }
    }

    static {
        try {
            File logDir = new File("\u041b\u041e\u0413\u0418 \u041a\u041e\u0420\u0410\u0411\u041b\u0415\u0419");
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String timestamp = dateFormat.format(new Date());
            logFile = new File(logDir, "ship_debug_" + timestamp + ".log");
            fileWriter = new PrintWriter((Writer)new FileWriter(logFile, true), true);
            fileWriter.println("=".repeat(80));
            fileWriter.println("SHIP DEBUG LOG - " + timestamp);
            fileWriter.println("=".repeat(80));
            fileWriter.println();
            System.out.println("[ShipDebugLogger] \u041b\u043e\u0433\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u044e\u0442\u0441\u044f \u0432: " + logFile.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("[ShipDebugLogger] \u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u043b\u043e\u0433\u0430: " + e.getMessage());
        }
    }
}

