/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.votive.airships.client.ships.ShipPacketHandler;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ShipControlHandler {
    private static final class_2960 SHIP_CONTROL_CHANNEL = new class_2960("votivemods", "ship_control");
    private static final class_310 client = class_310.method_1551();
    private static boolean wasForwardPressed = false;
    private static boolean wasBackwardPressed = false;
    private static boolean wasSneakPressed = false;
    private static boolean wasDropPressed = false;
    private static boolean wasLeftPressed = false;
    private static boolean wasRightPressed = false;
    private static boolean wasJumpPressed = false;
    private static long lastWPressTime = 0L;
    private static boolean autopilotEnabled = false;
    private static final long DOUBLE_TAP_TIMEOUT = 300L;
    private static long lastSneakPressTime = 0L;
    private static int tickCounter = 0;
    private static String lastDirection = "NONE";
    private static String lastTurnDirection = "NONE";
    private static float lastYaw = 0.0f;

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> ShipControlHandler.tick());
    }

    public static void tick(class_310 client) {
        ShipControlHandler.tick();
    }

    private static void tick() {
        ShipPacketHandler.ActiveShipClient currentShip;
        if (ShipControlHandler.client.field_1724 == null || ShipControlHandler.client.field_1687 == null) {
            return;
        }
        ++tickCounter;
        String controlledShip = ShipPacketHandler.getControlledShipId();
        if (controlledShip == null) {
            wasForwardPressed = false;
            wasBackwardPressed = false;
            wasSneakPressed = false;
            wasDropPressed = false;
            lastDirection = "NONE";
            tickCounter = 0;
            return;
        }
        boolean forwardPressed = ShipControlHandler.client.field_1690.field_1894.method_1434();
        boolean backwardPressed = ShipControlHandler.client.field_1690.field_1881.method_1434();
        boolean sneakPressed = ShipControlHandler.client.field_1690.field_1832.method_1434();
        boolean jumpPressed = ShipControlHandler.client.field_1690.field_1903.method_1434();
        boolean leftPressed = ShipControlHandler.client.field_1690.field_1913.method_1434();
        boolean rightPressed = ShipControlHandler.client.field_1690.field_1849.method_1434();
        if (forwardPressed && !wasForwardPressed) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastWPressTime < 300L) {
                autopilotEnabled = !autopilotEnabled;
                ShipControlHandler.sendAutopilotToggle(controlledShip, autopilotEnabled);
                if (autopilotEnabled) {
                    ShipControlHandler.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7l\u0410\u0412\u0422\u041e\u041f\u0418\u041b\u041e\u0422 \u0412\u041a\u041b\u042e\u0427\u0415\u041d"), true);
                } else {
                    ShipControlHandler.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7l\u0410\u0412\u0422\u041e\u041f\u0418\u041b\u041e\u0422 \u0412\u042b\u041a\u041b\u042e\u0427\u0415\u041d"), true);
                }
            }
            lastWPressTime = currentTime;
        }
        if (sneakPressed && !wasSneakPressed) {
            if (autopilotEnabled) {
                autopilotEnabled = false;
                ShipControlHandler.sendAutopilotToggle(controlledShip, false);
            }
            ShipControlHandler.sendShipMovement(controlledShip, "STOP");
            ShipControlHandler.sendShipCommand(controlledShip, "DISMOUNT");
            ShipControlHandler.client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a7e\u0421\u043b\u0435\u0437\u0430\u0435\u043c \u0441 \u043a\u043e\u0440\u0430\u0431\u043b\u044f..."), true);
            wasSneakPressed = true;
            return;
        }
        String moveDirection = "NONE";
        if (autopilotEnabled) {
            moveDirection = "AUTOPILOT";
        } else if (forwardPressed && !backwardPressed) {
            moveDirection = "FORWARD";
        } else if (backwardPressed && !forwardPressed) {
            moveDirection = "BACKWARD";
        }
        ShipControlHandler.sendShipMovement(controlledShip, moveDirection);
        String turnDirection = "NONE";
        if (leftPressed && !rightPressed) {
            turnDirection = "LEFT";
        } else if (rightPressed && !leftPressed) {
            turnDirection = "RIGHT";
        }
        if (!turnDirection.equals(lastTurnDirection)) {
            ShipControlHandler.sendShipTurn(controlledShip, turnDirection);
            lastTurnDirection = turnDirection;
        }
        if ((currentShip = ShipPacketHandler.getShips().get(controlledShip)) != null && currentShip.isAirship) {
            String verticalDirection = "NONE";
            if (jumpPressed) {
                verticalDirection = "UP";
            }
            ShipControlHandler.sendVerticalMovement(controlledShip, verticalDirection);
        }
        wasForwardPressed = forwardPressed;
        wasBackwardPressed = backwardPressed;
        wasSneakPressed = sneakPressed;
        wasJumpPressed = jumpPressed;
        wasLeftPressed = leftPressed;
        wasRightPressed = rightPressed;
    }

    private static void sendShipMovement(String shipId, String direction) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(2);
        ShipControlHandler.writeString(buf, shipId);
        ShipControlHandler.writeString(buf, direction);
        ClientPlayNetworking.send((class_2960)SHIP_CONTROL_CHANNEL, (class_2540)buf);
    }

    private static void sendShipCommand(String shipId, String command) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(0);
        ShipControlHandler.writeString(buf, shipId);
        ShipControlHandler.writeString(buf, command);
        ClientPlayNetworking.send((class_2960)SHIP_CONTROL_CHANNEL, (class_2540)buf);
    }

    private static void sendShipTurn(String shipId, String turnDirection) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(3);
        ShipControlHandler.writeString(buf, shipId);
        ShipControlHandler.writeString(buf, turnDirection);
        ClientPlayNetworking.send((class_2960)SHIP_CONTROL_CHANNEL, (class_2540)buf);
    }

    private static void sendAutopilotToggle(String shipId, boolean enabled) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(5);
        ShipControlHandler.writeString(buf, shipId);
        buf.writeBoolean(enabled);
        ClientPlayNetworking.send((class_2960)SHIP_CONTROL_CHANNEL, (class_2540)buf);
    }

    public static boolean isAutopilotEnabled() {
        return autopilotEnabled;
    }

    private static void sendVerticalMovement(String shipId, String verticalDirection) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(6);
        ShipControlHandler.writeString(buf, shipId);
        ShipControlHandler.writeString(buf, verticalDirection);
        ClientPlayNetworking.send((class_2960)SHIP_CONTROL_CHANNEL, (class_2540)buf);
    }

    private static void writeString(class_2540 buf, String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    private static String getCardinalDirection(float yaw) {
        float normalizedYaw = (yaw % 360.0f + 360.0f) % 360.0f;
        if (normalizedYaw >= 315.0f || normalizedYaw < 45.0f) {
            return "\u042e\u0413 (SOUTH)";
        }
        if (normalizedYaw >= 45.0f && normalizedYaw < 135.0f) {
            return "\u0417\u0410\u041f\u0410\u0414 (WEST)";
        }
        if (normalizedYaw >= 135.0f && normalizedYaw < 225.0f) {
            return "\u0421\u0415\u0412\u0415\u0420 (NORTH)";
        }
        return "\u0412\u041e\u0421\u0422\u041e\u041a (EAST)";
    }
}

