/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.votive.airships.client.ships.ShipPacketHandler;
import com.votive.airships.client.ships.ShipPlayerController;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class ShipCollisionDetector {
    private static final double COLLISION_CHECK_DISTANCE = 1.0;

    public static boolean checkCollisionInDirection(ShipPacketHandler.ActiveShipClient ship, double direction, class_310 client) {
        if (client.field_1687 == null || ship == null || ship.blocks == null) {
            return false;
        }
        class_1297 armorStand = ship.getArmorStand(client);
        if (armorStand == null) {
            return false;
        }
        class_243 shipPos = armorStand.method_19538();
        double shipYaw = armorStand.method_36454();
        double checkDistance = 1.0 * direction;
        double radians = Math.toRadians(shipYaw);
        double forwardX = -Math.sin(radians);
        double forwardZ = Math.cos(radians);
        class_638 world = client.field_1687;
        int obstacleCount = 0;
        for (ShipPacketHandler.ShipBlock block : ship.blocks) {
            class_243 blockWorldPos = ShipPlayerController.calculateBlockWorldPos(block, ship, shipPos, shipYaw);
            class_243 futureBlockPos = new class_243(blockWorldPos.field_1352 + forwardX * checkDistance, blockWorldPos.field_1351, blockWorldPos.field_1350 + forwardZ * checkDistance);
            class_2338 worldPos = new class_2338((int)Math.floor(futureBlockPos.field_1352), (int)Math.floor(futureBlockPos.field_1351), (int)Math.floor(futureBlockPos.field_1350));
            class_2680 state = world.method_8320(worldPos);
            if (state.method_26215() || ShipCollisionDetector.isPassableWaterBlock(state)) continue;
            boolean isShipBlock = false;
            for (ShipPacketHandler.ShipBlock shipBlock : ship.blocks) {
                class_243 shipBlockPos = ShipPlayerController.calculateBlockWorldPos(shipBlock, ship, shipPos, shipYaw);
                class_2338 shipBlockWorldPos = new class_2338((int)Math.floor(shipBlockPos.field_1352), (int)Math.floor(shipBlockPos.field_1351), (int)Math.floor(shipBlockPos.field_1350));
                if (!worldPos.equals((Object)shipBlockWorldPos)) continue;
                isShipBlock = true;
                break;
            }
            if (isShipBlock) continue;
            ++obstacleCount;
        }
        return obstacleCount >= 3;
    }

    private static boolean isPassableWaterBlock(class_2680 state) {
        String blockName = state.method_26204().toString();
        return blockName.contains("water") || blockName.contains("kelp") || blockName.contains("seagrass") || blockName.contains("sea_grass") || blockName.contains("bubble_column");
    }

    private static ShipBounds calculateShipBounds(ShipPacketHandler.ActiveShipClient ship) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (ShipPacketHandler.ShipBlock block : ship.blocks) {
            if (block.relativeX < minX) {
                minX = block.relativeX;
            }
            if (block.relativeX > maxX) {
                maxX = block.relativeX;
            }
            if (block.relativeY < minY) {
                minY = block.relativeY;
            }
            if (block.relativeY > maxY) {
                maxY = block.relativeY;
            }
            if (block.relativeZ < minZ) {
                minZ = block.relativeZ;
            }
            if (block.relativeZ <= maxZ) continue;
            maxZ = block.relativeZ;
        }
        return new ShipBounds(minX, maxX, minY, maxY, minZ, maxZ);
    }

    private static class ShipBounds {
        int minX;
        int maxX;
        int minY;
        int maxY;
        int minZ;
        int maxZ;

        ShipBounds(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
            this.minZ = minZ;
            this.maxZ = maxZ;
        }
    }

    public static class CollisionState {
        public final boolean canMoveForward;
        public final boolean canMoveBackward;

        public CollisionState(boolean canMoveForward, boolean canMoveBackward) {
            this.canMoveForward = canMoveForward;
            this.canMoveBackward = canMoveBackward;
        }
    }
}

