/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ShipClientPacketSender {
    private static final class_2960 SHIP_INTERACTION = new class_2960("votivemods", "ship_interact");
    private static final class_2960 SHIP_CONTROL = new class_2960("votivemods", "ship_control");
    private static final class_2960 POSITION_CHANNEL = new class_2960("votivemods", "ship_position");
    private static final class_2960 COLLISION_CHANNEL = new class_2960("votivemods", "ship_collision");
    private static final class_2960 SHIP_REQUEST_CHANNEL = new class_2960("votivemods", "ship_request");

    public static void sendShipInteraction(String shipId, InteractionType type, class_243 hitPosition) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        try {
            byte[] shipIdBytes = shipId.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(shipIdBytes.length);
            buf.writeBytes(shipIdBytes);
            buf.writeByte(type.ordinal());
            buf.writeDouble(hitPosition.field_1352);
            buf.writeDouble(hitPosition.field_1351);
            buf.writeDouble(hitPosition.field_1350);
            ClientPlayNetworking.send((class_2960)SHIP_INTERACTION, (class_2540)buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendControlCommand(String shipId, String command) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        try {
            byte[] shipIdBytes = shipId.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(shipIdBytes.length);
            buf.writeBytes(shipIdBytes);
            byte[] commandBytes = command.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(commandBytes.length);
            buf.writeBytes(commandBytes);
            ClientPlayNetworking.send((class_2960)SHIP_CONTROL, (class_2540)buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendPlayerPositionOnShip(String shipId, double x, double y, double z, float yaw, float pitch, boolean isMoving) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        try {
            byte[] shipIdBytes = shipId.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(shipIdBytes.length);
            buf.writeBytes(shipIdBytes);
            buf.writeDouble(x);
            buf.writeDouble(y);
            buf.writeDouble(z);
            buf.writeFloat(yaw);
            buf.writeFloat(pitch);
            buf.writeBoolean(isMoving);
            ClientPlayNetworking.send((class_2960)POSITION_CHANNEL, (class_2540)buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendCollisionState(String shipId, boolean canMoveForward, boolean canMoveBackward) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        try {
            byte[] shipIdBytes = shipId.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(shipIdBytes.length);
            buf.writeBytes(shipIdBytes);
            buf.writeBoolean(canMoveForward);
            buf.writeBoolean(canMoveBackward);
            ClientPlayNetworking.send((class_2960)COLLISION_CHANNEL, (class_2540)buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void requestShipDataByArmorStand(UUID armorStandUUID) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        try {
            buf.writeLong(armorStandUUID.getMostSignificantBits());
            buf.writeLong(armorStandUUID.getLeastSignificantBits());
            ClientPlayNetworking.send((class_2960)SHIP_REQUEST_CHANNEL, (class_2540)buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum InteractionType {
        PLACE,
        START_CONTROL,
        OPEN_MENU;

    }
}

