/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.votive.airships.client.ships.ShipClientPacketSender;
import com.votive.airships.client.ships.ShipCollisionDetector;
import com.votive.airships.client.ships.ShipDebugLogger;
import com.votive.airships.client.ships.ShipPacketHandler;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class ShipClientHandler {
    private static ShipClientHandler instance;
    private final class_310 client = class_310.method_1551();
    private String shipOrientation = "EAST";
    private boolean physicsBlocked = false;
    private int physicsBlockedTicks = 0;
    private int collisionCheckTicks = 0;
    private static final int COLLISION_CHECK_INTERVAL = 2;
    private class_243 lastShipPosition = null;
    private double lastShipYaw = 0.0;

    public static void initialize() {
        if (instance == null) {
            instance = new ShipClientHandler();
        }
    }

    public static ShipClientHandler getInstance() {
        return instance;
    }

    public void disablePhysics(int durationTicks) {
        this.physicsBlocked = true;
        this.physicsBlockedTicks = durationTicks;
    }

    public boolean isPhysicsBlocked() {
        return this.physicsBlocked;
    }

    public void handleControlStart(String shipId, class_243 offset) {
    }

    public void tick() {
        class_1297 cameraEntity = this.client.method_1560();
        if (cameraEntity != null && "FreeCamera".equals(cameraEntity.getClass().getSimpleName())) {
            return;
        }
        if (this.physicsBlocked) {
            --this.physicsBlockedTicks;
            if (this.physicsBlockedTicks <= 0) {
                this.physicsBlocked = false;
                this.physicsBlockedTicks = 0;
            }
        }
        this.updatePassengerAttachment();
    }

    private void updatePassengerAttachment() {
        if (this.client.field_1724 == null) {
            return;
        }
        UUID playerUUID = this.client.field_1724.method_5667();
        ShipPacketHandler.PassengerPosCache passengerCache = ShipPacketHandler.getOtherPlayersPositions().get(playerUUID);
        if (System.currentTimeMillis() % 1000L < 50L && ShipDebugLogger.isEnabled()) {
            String role = passengerCache != null && passengerCache.isCaptain ? "CAPTAIN" : "PASSENGER";
            String msg = "[" + role + "] cache=" + (passengerCache != null) + " | shipId=" + (passengerCache != null ? passengerCache.shipId : "null");
            ShipDebugLogger.logPassenger(msg);
        }
        if (passengerCache != null && passengerCache.shipId != null) {
            ShipPacketHandler.ActiveShipClient ship = ShipPacketHandler.getShips().get(passengerCache.shipId);
            if (ship == null) {
                return;
            }
            class_243 currentShipPos = ship.controlPoint;
            double currentShipYaw = ship.yaw;
            if (this.lastShipPosition != null) {
                class_243 newPlayerPos;
                boolean isCaptain = passengerCache.isCaptain;
                class_243 shipMovement = currentShipPos.method_1020(this.lastShipPosition);
                double yawChange = currentShipYaw - this.lastShipYaw;
                class_243 currentPlayerPos = this.client.field_1724.method_19538();
                if (isCaptain) {
                    class_243 relativePos = passengerCache.targetRelativePosition;
                    if (relativePos != null) {
                        class_243 rotatedOffset = this.rotateVector(relativePos, (float)currentShipYaw);
                        newPlayerPos = currentShipPos.method_1019(rotatedOffset);
                        this.client.field_1724.field_6014 = newPlayerPos.field_1352;
                        this.client.field_1724.field_6036 = newPlayerPos.field_1351;
                        this.client.field_1724.field_5969 = newPlayerPos.field_1350;
                    } else {
                        newPlayerPos = currentPlayerPos.method_1019(shipMovement);
                    }
                } else if (Math.abs(yawChange) > 0.01) {
                    class_243 relativeToShip = currentPlayerPos.method_1020(this.lastShipPosition);
                    double rad = Math.toRadians(yawChange);
                    double cos = Math.cos(rad);
                    double sin = Math.sin(rad);
                    double rotatedX = relativeToShip.field_1352 * cos - relativeToShip.field_1350 * sin;
                    double rotatedZ = relativeToShip.field_1352 * sin + relativeToShip.field_1350 * cos;
                    newPlayerPos = currentShipPos.method_1031(rotatedX, relativeToShip.field_1351, rotatedZ);
                } else {
                    newPlayerPos = currentPlayerPos.method_1019(shipMovement);
                }
                this.client.field_1724.method_23327(newPlayerPos.field_1352, newPlayerPos.field_1351, newPlayerPos.field_1350);
                this.client.field_1724.field_6017 = 0.0f;
            } else {
                class_243 relativePos = passengerCache.targetRelativePosition;
                if (relativePos != null) {
                    class_243 rotatedOffset = this.rotateVector(relativePos, (float)currentShipYaw);
                    class_243 initialPos = currentShipPos.method_1019(rotatedOffset);
                    this.client.field_1724.method_23327(initialPos.field_1352, initialPos.field_1351, initialPos.field_1350);
                    this.client.field_1724.field_6014 = initialPos.field_1352;
                    this.client.field_1724.field_6036 = initialPos.field_1351;
                    this.client.field_1724.field_5969 = initialPos.field_1350;
                }
            }
            this.lastShipPosition = currentShipPos;
            this.lastShipYaw = currentShipYaw;
            if (passengerCache.isCaptain) {
                this.checkAndSendCollisions();
            }
        } else {
            this.lastShipPosition = null;
            this.lastShipYaw = 0.0;
        }
    }

    private void checkAndSendCollisions() {
        ++this.collisionCheckTicks;
        if (this.collisionCheckTicks < 2) {
            return;
        }
        this.collisionCheckTicks = 0;
        if (this.client.field_1724 == null) {
            return;
        }
        UUID playerUUID = this.client.field_1724.method_5667();
        ShipPacketHandler.PassengerPosCache passengerCache = ShipPacketHandler.getOtherPlayersPositions().get(playerUUID);
        if (passengerCache == null || !passengerCache.isCaptain || passengerCache.shipId == null) {
            return;
        }
        String shipId = passengerCache.shipId;
        ShipPacketHandler.ActiveShipClient ship = ShipPacketHandler.getShips().get(shipId);
        if (ship == null) {
            return;
        }
        boolean isSpectator = this.client.field_1724.method_7325();
        boolean canMoveForward = true;
        boolean canMoveBackward = true;
        if (!isSpectator) {
            boolean hasObstacleForward = ShipCollisionDetector.checkCollisionInDirection(ship, 1.0, this.client);
            boolean hasObstacleBackward = ShipCollisionDetector.checkCollisionInDirection(ship, -1.0, this.client);
            canMoveForward = !hasObstacleForward;
            canMoveBackward = !hasObstacleBackward;
        }
        ShipClientPacketSender.sendCollisionState(shipId, canMoveForward, canMoveBackward);
    }

    private class_243 rotateVector(class_243 vector, float yaw) {
        double rad = Math.toRadians(yaw);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        double x = vector.field_1352 * cos - vector.field_1350 * sin;
        double z = vector.field_1352 * sin + vector.field_1350 * cos;
        return new class_243(x, vector.field_1351, z);
    }

    public void handleControlStop() {
    }

    public void setShipOrientation(String orientation) {
        this.shipOrientation = orientation;
    }

    public String getShipOrientation() {
        return this.shipOrientation;
    }

    public boolean isControllingShip() {
        if (this.client == null || this.client.field_1724 == null) {
            return false;
        }
        UUID playerUUID = this.client.field_1724.method_5667();
        ShipPacketHandler.PassengerPosCache passengerCache = ShipPacketHandler.getOtherPlayersPositions().get(playerUUID);
        return passengerCache != null && passengerCache.isCaptain;
    }

    public float getShipYaw() {
        ShipPacketHandler.ActiveShipClient ship;
        if (this.client == null || this.client.field_1724 == null) {
            return 0.0f;
        }
        UUID playerUUID = this.client.field_1724.method_5667();
        ShipPacketHandler.PassengerPosCache passengerCache = ShipPacketHandler.getOtherPlayersPositions().get(playerUUID);
        if (passengerCache != null && passengerCache.shipId != null && (ship = ShipPacketHandler.getShips().get(passengerCache.shipId)) != null) {
            return (float)ship.yaw;
        }
        return 0.0f;
    }

    public void removeShip(String shipId) {
        ShipPacketHandler.getShips().remove(shipId);
    }
}

