/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class ShipBoundaryRenderer {
    private static boolean showingBoundaries = false;
    private static class_243 point1;
    private static class_243 point2;
    private static class_243 controlPoint;
    private static String orientation;

    public static void register() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(ShipBoundaryRenderer::render);
    }

    public static void showBoundaries(class_243 point1, class_243 point2, class_243 controlPoint, String orientation) {
        ShipBoundaryRenderer.point1 = point1;
        ShipBoundaryRenderer.point2 = point2;
        ShipBoundaryRenderer.controlPoint = controlPoint;
        ShipBoundaryRenderer.orientation = orientation;
        showingBoundaries = true;
    }

    public static void hideBoundaries() {
        showingBoundaries = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(class_4587 matrices) {
        if (!showingBoundaries || point1 == null || point2 == null || controlPoint == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        matrices.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.setShader(class_757::method_34540);
        try {
            double minX = Math.min(ShipBoundaryRenderer.point1.field_1352, ShipBoundaryRenderer.point2.field_1352);
            double minY = Math.min(ShipBoundaryRenderer.point1.field_1351, ShipBoundaryRenderer.point2.field_1351);
            double minZ = Math.min(ShipBoundaryRenderer.point1.field_1350, ShipBoundaryRenderer.point2.field_1350);
            double maxX = Math.max(ShipBoundaryRenderer.point1.field_1352, ShipBoundaryRenderer.point2.field_1352) + 1.0;
            double maxY = Math.max(ShipBoundaryRenderer.point1.field_1351, ShipBoundaryRenderer.point2.field_1351) + 1.0;
            double maxZ = Math.max(ShipBoundaryRenderer.point1.field_1350, ShipBoundaryRenderer.point2.field_1350) + 1.0;
            double x1 = minX - cameraPos.field_1352;
            double y1 = minY - cameraPos.field_1351;
            double z1 = minZ - cameraPos.field_1350;
            double x2 = maxX - cameraPos.field_1352;
            double y2 = maxY - cameraPos.field_1351;
            double z2 = maxZ - cameraPos.field_1350;
            RenderSystem.lineWidth((float)3.0f);
            ShipBoundaryRenderer.renderBoxWithFaces(matrices, x1, y1, z1, x2, y2, z2, 0.0f, 1.0f, 0.3f, 0.8f, 0.15f);
            double p1X = ShipBoundaryRenderer.point1.field_1352 - cameraPos.field_1352;
            double p1Y = ShipBoundaryRenderer.point1.field_1351 - cameraPos.field_1351;
            double p1Z = ShipBoundaryRenderer.point1.field_1350 - cameraPos.field_1350;
            ShipBoundaryRenderer.renderCubeWithFaces(matrices, p1X, p1Y, p1Z, 1.0f, 1.0f, 0.0f, 1.0f, 0.3f);
            double p2X = ShipBoundaryRenderer.point2.field_1352 - cameraPos.field_1352;
            double p2Y = ShipBoundaryRenderer.point2.field_1351 - cameraPos.field_1351;
            double p2Z = ShipBoundaryRenderer.point2.field_1350 - cameraPos.field_1350;
            ShipBoundaryRenderer.renderCubeWithFaces(matrices, p2X, p2Y, p2Z, 0.2f, 0.6f, 1.0f, 1.0f, 0.3f);
            double cpX = ShipBoundaryRenderer.controlPoint.field_1352 - cameraPos.field_1352;
            double cpY = ShipBoundaryRenderer.controlPoint.field_1351 - cameraPos.field_1351;
            double cpZ = ShipBoundaryRenderer.controlPoint.field_1350 - cameraPos.field_1350;
            ShipBoundaryRenderer.renderCubeWithFaces(matrices, cpX, cpY, cpZ, 1.0f, 0.0f, 0.0f, 1.0f, 0.3f);
            RenderSystem.lineWidth((float)5.0f);
            ShipBoundaryRenderer.renderOrientationArrow(matrices, cpX, cpY, cpZ, orientation);
        }
        catch (Exception e) {
            System.err.println("[VotiveRP] Exception in ShipBoundaryRenderer");
            e.printStackTrace();
        }
        finally {
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
        matrices.method_22909();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void render(WorldRenderContext context) {
        if (!showingBoundaries || point1 == null || point2 == null || controlPoint == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        class_243 cameraPos = context.camera().method_19326();
        matrices.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.setShader(class_757::method_34540);
        try {
            double minX = Math.min(ShipBoundaryRenderer.point1.field_1352, ShipBoundaryRenderer.point2.field_1352);
            double minY = Math.min(ShipBoundaryRenderer.point1.field_1351, ShipBoundaryRenderer.point2.field_1351);
            double minZ = Math.min(ShipBoundaryRenderer.point1.field_1350, ShipBoundaryRenderer.point2.field_1350);
            double maxX = Math.max(ShipBoundaryRenderer.point1.field_1352, ShipBoundaryRenderer.point2.field_1352) + 1.0;
            double maxY = Math.max(ShipBoundaryRenderer.point1.field_1351, ShipBoundaryRenderer.point2.field_1351) + 1.0;
            double maxZ = Math.max(ShipBoundaryRenderer.point1.field_1350, ShipBoundaryRenderer.point2.field_1350) + 1.0;
            double x1 = minX - cameraPos.field_1352;
            double y1 = minY - cameraPos.field_1351;
            double z1 = minZ - cameraPos.field_1350;
            double x2 = maxX - cameraPos.field_1352;
            double y2 = maxY - cameraPos.field_1351;
            double z2 = maxZ - cameraPos.field_1350;
            RenderSystem.lineWidth((float)3.0f);
            ShipBoundaryRenderer.renderBoxWithFaces(matrices, x1, y1, z1, x2, y2, z2, 0.0f, 1.0f, 0.3f, 0.8f, 0.15f);
            double p1X = ShipBoundaryRenderer.point1.field_1352 - cameraPos.field_1352;
            double p1Y = ShipBoundaryRenderer.point1.field_1351 - cameraPos.field_1351;
            double p1Z = ShipBoundaryRenderer.point1.field_1350 - cameraPos.field_1350;
            ShipBoundaryRenderer.renderCubeWithFaces(matrices, p1X, p1Y, p1Z, 1.0f, 1.0f, 0.0f, 1.0f, 0.3f);
            double p2X = ShipBoundaryRenderer.point2.field_1352 - cameraPos.field_1352;
            double p2Y = ShipBoundaryRenderer.point2.field_1351 - cameraPos.field_1351;
            double p2Z = ShipBoundaryRenderer.point2.field_1350 - cameraPos.field_1350;
            ShipBoundaryRenderer.renderCubeWithFaces(matrices, p2X, p2Y, p2Z, 0.2f, 0.6f, 1.0f, 1.0f, 0.3f);
            double cpX = ShipBoundaryRenderer.controlPoint.field_1352 - cameraPos.field_1352;
            double cpY = ShipBoundaryRenderer.controlPoint.field_1351 - cameraPos.field_1351;
            double cpZ = ShipBoundaryRenderer.controlPoint.field_1350 - cameraPos.field_1350;
            ShipBoundaryRenderer.renderCubeWithFaces(matrices, cpX, cpY, cpZ, 1.0f, 0.0f, 0.0f, 1.0f, 0.3f);
            RenderSystem.lineWidth((float)5.0f);
            ShipBoundaryRenderer.renderOrientationArrow(matrices, cpX, cpY, cpZ, orientation);
        }
        catch (Exception e) {
            System.err.println("[VotiveRP] Exception in ShipBoundaryRenderer");
            e.printStackTrace();
        }
        finally {
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
        matrices.method_22909();
    }

    private static void renderOrientationArrow(class_4587 matrices, double x, double y, double z, String orientation) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        double centerX = x + 0.5;
        double centerY = y + 1.5;
        double centerZ = z + 0.5;
        double arrowLength = 2.0;
        double arrowHeadSize = 0.4;
        float r = 1.0f;
        float g = 1.0f;
        float b = 0.0f;
        float a = 1.0f;
        double endX = centerX;
        double endZ = centerZ;
        switch (orientation.toUpperCase()) {
            case "EAST": {
                endX = centerX + arrowLength;
                r = 1.0f;
                g = 0.2f;
                b = 0.2f;
                break;
            }
            case "WEST": {
                endX = centerX - arrowLength;
                r = 0.2f;
                g = 0.4f;
                b = 1.0f;
                break;
            }
            case "SOUTH": {
                endZ = centerZ + arrowLength;
                r = 0.2f;
                g = 1.0f;
                b = 0.2f;
                break;
            }
            case "NORTH": {
                endZ = centerZ - arrowLength;
                r = 1.0f;
                g = 0.6f;
                b = 0.0f;
            }
        }
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        ShipBoundaryRenderer.addLine(buffer, matrix, centerX, centerY, centerZ, endX, centerY, endZ, r, g, b, a);
        switch (orientation.toUpperCase()) {
            case "EAST": {
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX - arrowHeadSize, centerY + arrowHeadSize, endZ, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX - arrowHeadSize, centerY - arrowHeadSize, endZ, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX - arrowHeadSize, centerY, endZ + arrowHeadSize, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX - arrowHeadSize, centerY, endZ - arrowHeadSize, r, g, b, a);
                break;
            }
            case "WEST": {
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX + arrowHeadSize, centerY + arrowHeadSize, endZ, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX + arrowHeadSize, centerY - arrowHeadSize, endZ, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX + arrowHeadSize, centerY, endZ + arrowHeadSize, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX + arrowHeadSize, centerY, endZ - arrowHeadSize, r, g, b, a);
                break;
            }
            case "SOUTH": {
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX + arrowHeadSize, centerY, endZ - arrowHeadSize, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX - arrowHeadSize, centerY, endZ - arrowHeadSize, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX, centerY + arrowHeadSize, endZ - arrowHeadSize, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX, centerY - arrowHeadSize, endZ - arrowHeadSize, r, g, b, a);
                break;
            }
            case "NORTH": {
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX + arrowHeadSize, centerY, endZ + arrowHeadSize, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX - arrowHeadSize, centerY, endZ + arrowHeadSize, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX, centerY + arrowHeadSize, endZ + arrowHeadSize, r, g, b, a);
                ShipBoundaryRenderer.addLine(buffer, matrix, endX, centerY, endZ, endX, centerY - arrowHeadSize, endZ + arrowHeadSize, r, g, b, a);
            }
        }
        tessellator.method_1350();
    }

    private static void renderBoxWithFaces(class_4587 matrices, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float lineAlpha, float faceAlpha) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        ShipBoundaryRenderer.addQuad(buffer, matrix, x1, y1, z1, x2, y1, z1, x2, y1, z2, x1, y1, z2, r, g, b, faceAlpha);
        ShipBoundaryRenderer.addQuad(buffer, matrix, x1, y2, z2, x2, y2, z2, x2, y2, z1, x1, y2, z1, r, g, b, faceAlpha);
        ShipBoundaryRenderer.addQuad(buffer, matrix, x1, y1, z1, x1, y2, z1, x2, y2, z1, x2, y1, z1, r, g, b, faceAlpha);
        ShipBoundaryRenderer.addQuad(buffer, matrix, x2, y1, z2, x2, y2, z2, x1, y2, z2, x1, y1, z2, r, g, b, faceAlpha);
        ShipBoundaryRenderer.addQuad(buffer, matrix, x1, y1, z2, x1, y2, z2, x1, y2, z1, x1, y1, z1, r, g, b, faceAlpha);
        ShipBoundaryRenderer.addQuad(buffer, matrix, x2, y1, z1, x2, y2, z1, x2, y2, z2, x2, y1, z2, r, g, b, faceAlpha);
        tessellator.method_1350();
        buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        ShipBoundaryRenderer.addLine(buffer, matrix, x1, y1, z1, x2, y1, z1, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x2, y1, z1, x2, y1, z2, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x2, y1, z2, x1, y1, z2, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x1, y1, z2, x1, y1, z1, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x1, y2, z1, x2, y2, z1, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x2, y2, z1, x2, y2, z2, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x2, y2, z2, x1, y2, z2, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x1, y2, z2, x1, y2, z1, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x1, y1, z1, x1, y2, z1, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x2, y1, z1, x2, y2, z1, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x2, y1, z2, x2, y2, z2, r, g, b, lineAlpha);
        ShipBoundaryRenderer.addLine(buffer, matrix, x1, y1, z2, x1, y2, z2, r, g, b, lineAlpha);
        tessellator.method_1350();
    }

    private static void renderCubeWithFaces(class_4587 matrices, double x, double y, double z, float r, float g, float b, float lineAlpha, float faceAlpha) {
        double size = 1.0;
        ShipBoundaryRenderer.renderBoxWithFaces(matrices, x, y, z, x + size, y + size, z + size, r, g, b, lineAlpha, faceAlpha);
    }

    private static void addQuad(class_287 buffer, Matrix4f matrix, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, float r, float g, float b, float a) {
        buffer.method_22918(matrix, (float)x1, (float)y1, (float)z1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y2, (float)z2).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)x3, (float)y3, (float)z3).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)x4, (float)y4, (float)z4).method_22915(r, g, b, a).method_1344();
    }

    private static void addLine(class_287 buffer, Matrix4f matrix, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        buffer.method_22918(matrix, (float)x1, (float)y1, (float)z1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, (float)x2, (float)y2, (float)z2).method_22915(r, g, b, a).method_1344();
    }

    static {
        orientation = "EAST";
    }
}

