/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.votive.airships.client.ships.ShipPacketHandler;
import com.votive.airships.client.ships.ShipPlayerController;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2824;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ShipBlockInteractionHandler {
    private static final class_2960 CHANNEL = new class_2960("votivemods", "ship_control");
    private static final class_310 client = class_310.method_1551();
    private static boolean wasUseKeyPressed = false;

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> ShipBlockInteractionHandler.tick());
    }

    private static void tick() {
        if (ShipBlockInteractionHandler.client.field_1724 == null || ShipBlockInteractionHandler.client.field_1687 == null) {
            return;
        }
        if (ShipBlockInteractionHandler.client.field_1755 != null) {
            wasUseKeyPressed = ShipBlockInteractionHandler.client.field_1690.field_1904.method_1434();
            return;
        }
        boolean useKeyPressed = ShipBlockInteractionHandler.client.field_1690.field_1904.method_1434();
        if (useKeyPressed && !wasUseKeyPressed) {
            ShipBlockInteractionHandler.handleRightClick();
        }
        wasUseKeyPressed = useKeyPressed;
    }

    private static void handleRightClick() {
        class_243 eyePos = ShipBlockInteractionHandler.client.field_1724.method_33571();
        class_243 lookVec = ShipBlockInteractionHandler.client.field_1724.method_5828(1.0f);
        class_243 rayEnd = eyePos.method_1019(lookVec.method_1021(5.0));
        for (ShipPacketHandler.ActiveShipClient ship : ShipPacketHandler.getShips().values()) {
            class_1533 helmFrame;
            if (!ship.visible) continue;
            class_243 shipPos = ship.getInterpolatedPosition(client.method_1488());
            double shipYaw = ship.getInterpolatedYaw(client.method_1488());
            if (ship.controlOffset != null && (helmFrame = ShipBlockInteractionHandler.findHelmItemFrame(ship, shipPos, shipYaw, eyePos, lookVec)) != null) {
                ShipBlockInteractionHandler.sendHelmInteractPacket(helmFrame);
                return;
            }
            if (ship.blocks == null) continue;
            for (ShipPacketHandler.ShipBlock block : ship.blocks) {
                if (!ShipBlockInteractionHandler.isContainer(block.material)) continue;
                class_243 blockWorldPos = ShipBlockInteractionHandler.calculateBlockWorldPosition(block, ship, shipPos, shipYaw);
                class_238 blockBox = new class_238(blockWorldPos.field_1352, blockWorldPos.field_1351, blockWorldPos.field_1350, blockWorldPos.field_1352 + 1.0, blockWorldPos.field_1351 + 1.0, blockWorldPos.field_1350 + 1.0);
                Optional rayHit = blockBox.method_992(eyePos, rayEnd);
                if (!rayHit.isPresent()) continue;
                ShipBlockInteractionHandler.sendOpenContainerPacket(ship.shipId, block.relativeX, block.relativeY, block.relativeZ);
                return;
            }
        }
    }

    private static class_1533 findHelmItemFrame(ShipPacketHandler.ActiveShipClient ship, class_243 shipPos, double shipYaw, class_243 eyePos, class_243 lookVec) {
        if (ShipBlockInteractionHandler.client.field_1687 == null) {
            return null;
        }
        class_243 helmLocalPos = ship.controlOffset;
        double yawRad = Math.toRadians(shipYaw);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        double rotatedX = helmLocalPos.field_1352 * cos - helmLocalPos.field_1350 * sin;
        double rotatedZ = helmLocalPos.field_1352 * sin + helmLocalPos.field_1350 * cos;
        class_243 helmWorldPos = new class_243(shipPos.field_1352 + rotatedX, shipPos.field_1351 + helmLocalPos.field_1351, shipPos.field_1350 + rotatedZ);
        class_238 helmBox = new class_238(helmWorldPos.field_1352 - 0.75, helmWorldPos.field_1351 - 0.25, helmWorldPos.field_1350 - 0.75, helmWorldPos.field_1352 + 0.75, helmWorldPos.field_1351 + 2.25, helmWorldPos.field_1350 + 0.75);
        class_243 rayEnd = eyePos.method_1019(lookVec.method_1021(5.0));
        Optional rayHit = helmBox.method_992(eyePos, rayEnd);
        if (!rayHit.isPresent()) {
            return null;
        }
        class_238 searchBox = new class_238(helmWorldPos.method_1023(2.0, 2.0, 2.0), helmWorldPos.method_1031(2.0, 2.0, 2.0));
        for (class_1297 entity : ShipBlockInteractionHandler.client.field_1687.method_8335(null, searchBox)) {
            class_1533 frame;
            if (!(entity instanceof class_1533) || !ShipBlockInteractionHandler.isHelmFrame(frame = (class_1533)entity)) continue;
            return frame;
        }
        return null;
    }

    private static boolean isHelmFrame(class_1533 frame) {
        class_1799 item = frame.method_6940();
        if (item.method_7960() || !item.method_31574(class_1802.field_8145)) {
            return false;
        }
        class_2487 nbt = item.method_7969();
        if (nbt == null || !nbt.method_10545("CustomModelData")) {
            return false;
        }
        return nbt.method_10550("CustomModelData") == 564342;
    }

    private static void sendHelmInteractPacket(class_1533 frame) {
        if (ShipBlockInteractionHandler.client.field_1761 == null || ShipBlockInteractionHandler.client.field_1724 == null) {
            return;
        }
        client.method_1562().method_2883((class_2596)class_2824.method_34207((class_1297)frame, (boolean)ShipBlockInteractionHandler.client.field_1724.method_5715(), (class_1268)class_1268.field_5808));
        ShipBlockInteractionHandler.client.field_1724.method_6104(class_1268.field_5808);
    }

    private static boolean isContainer(String material) {
        return material.contains("CHEST") || material.contains("BARREL") || material.contains("SHULKER_BOX") || material.contains("FURNACE") || material.contains("HOPPER") || material.contains("DISPENSER") || material.contains("DROPPER");
    }

    private static class_243 calculateBlockWorldPosition(ShipPacketHandler.ShipBlock block, ShipPacketHandler.ActiveShipClient ship, class_243 shipPos, double shipYaw) {
        return ShipPlayerController.calculateBlockWorldPos(block, ship, shipPos, shipYaw);
    }

    private static void sendOpenContainerPacket(String shipId, int x, int y, int z) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeByte(4);
        byte[] shipIdBytes = shipId.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(shipIdBytes.length);
        buf.writeBytes(shipIdBytes);
        buf.writeInt(x);
        buf.writeInt(y);
        buf.writeInt(z);
        ClientPlayNetworking.send((class_2960)CHANNEL, (class_2540)buf);
    }
}

