/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.votive.airships.client.ships.ShipClientPacketSender;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1531;

public class ShipArmorStandTracker {
    private static final Set<UUID> requestedArmorStands = new HashSet<UUID>();
    private static final Map<UUID, StoredPosition> lastKnownPositions = new HashMap<UUID, StoredPosition>();

    public static void register() {
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1531) {
                class_1531 armorStand = (class_1531)entity;
                ShipArmorStandTracker.onArmorStandLoaded(armorStand);
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1687.method_8510() % 600L == 0L) {
                requestedArmorStands.clear();
            }
        });
    }

    private static void onArmorStandLoaded(class_1531 armorStand) {
        UUID uuid = armorStand.method_5667();
        if (requestedArmorStands.contains(uuid)) {
            return;
        }
        ShipClientPacketSender.requestShipDataByArmorStand(uuid);
        requestedArmorStands.add(uuid);
    }

    private static class StoredPosition {
        double x;
        double y;
        double z;
        float yaw;
        float pitch;
        long time;

        StoredPosition(class_1297 entity) {
            this.x = entity.method_23317();
            this.y = entity.method_23318();
            this.z = entity.method_23321();
            this.yaw = entity.method_36454();
            this.pitch = entity.method_36455();
            this.time = System.currentTimeMillis();
        }
    }
}

