/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.ships;

import com.votive.airships.client.ships.HelmModelLoader;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_7833;

public class HelmRenderer {
    private static final class_310 client = class_310.method_1551();
    private static volatile class_1087 helmModel;
    private static volatile class_1087 helmBaseModel;
    private static volatile class_1087 helmWheelModel;
    private static volatile boolean modelsLoaded;
    private static final int HELM_CUSTOM_MODEL_DATA = 564342;
    private static final List<class_1533> helmFrameCache;
    private static long lastCacheUpdate;
    private static final long CACHE_UPDATE_INTERVAL = 1000L;
    private static final double MAX_RENDER_DISTANCE = 64.0;

    public static void register() {
        WorldRenderEvents.AFTER_ENTITIES.register(HelmRenderer::renderHelms);
        WorldRenderEvents.START.register(context -> {
            if (!modelsLoaded) {
                HelmRenderer.loadModelOnce();
            }
        });
    }

    private static void renderHelms(WorldRenderContext context) {
        if (HelmRenderer.client.field_1687 == null || HelmRenderer.client.field_1724 == null) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        class_4597.class_4598 vertexConsumers = client.method_22940().method_23000();
        class_243 cameraPos = context.camera().method_19326();
        float tickDelta = context.tickDelta();
        long now = System.currentTimeMillis();
        if (now - lastCacheUpdate > 1000L) {
            HelmRenderer.updateHelmFrameCache();
            lastCacheUpdate = now;
        }
        int renderedCount = 0;
        for (class_1533 frame : helmFrameCache) {
            if (frame.method_31481()) continue;
            class_243 framePos = frame.method_30950(tickDelta);
            double distance = framePos.method_1022(cameraPos);
            if (distance > 64.0) {
                System.out.println("[HELM] Skipping helm at " + frame.method_19538() + " (too far: " + distance + ")");
                continue;
            }
            int rotation = frame.method_6934();
            String orientation = switch (rotation) {
                case 2 -> "WEST";
                case 4 -> "NORTH";
                case 6 -> "EAST";
                default -> "SOUTH";
            };
            System.out.println("[HELM] Rendering helm at " + frame.method_19538() + " (distance: " + distance + ", orientation: " + orientation + ")");
            HelmRenderer.renderHelm(matrices, (class_4597)vertexConsumers, frame, orientation, cameraPos, tickDelta);
            ++renderedCount;
        }
        if (renderedCount > 0) {
            System.out.println("[HELM] Rendered " + renderedCount + " helms this frame");
        }
        vertexConsumers.method_22993();
    }

    private static void updateHelmFrameCache() {
        helmFrameCache.clear();
        if (HelmRenderer.client.field_1687 == null) {
            return;
        }
        int totalFrames = 0;
        int flintFrames = 0;
        int helmFrames = 0;
        for (class_1297 entity : HelmRenderer.client.field_1687.method_18112()) {
            if (!(entity instanceof class_1533)) continue;
            class_1533 frame = (class_1533)entity;
            ++totalFrames;
            class_1799 item = frame.method_6940();
            if (item.method_7960() || !item.method_31574(class_1802.field_8145)) continue;
            ++flintFrames;
            class_2487 nbt = item.method_7969();
            if (nbt == null || !nbt.method_10545("CustomModelData")) {
                System.out.println("[HELM] Found FLINT frame but NO CustomModelData! Item: " + item);
                continue;
            }
            int customModelData = nbt.method_10550("CustomModelData");
            System.out.println("[HELM] Found FLINT frame with CustomModelData = " + customModelData + " (need 564342)");
            if (customModelData != 564342) continue;
            helmFrameCache.add(frame);
            ++helmFrames;
            System.out.println("[HELM] \u2705 Added helm frame to cache! Position: " + frame.method_19538());
        }
        if (helmFrames > 0) {
            System.out.println("[HELM] Cache updated: " + helmFrames + " helm frames found (total frames: " + totalFrames + ", flint frames: " + flintFrames + ")");
        }
    }

    private static void renderHelm(class_4587 matrices, class_4597 vertexConsumers, class_1533 frame, String orientation, class_243 cameraPos, float tickDelta) {
        class_1087 modelToRender;
        class_243 framePos = frame.method_30950(tickDelta);
        matrices.method_22903();
        matrices.method_22904(framePos.field_1352 - cameraPos.field_1352, framePos.field_1351 - cameraPos.field_1351 + 0.25, framePos.field_1350 - cameraPos.field_1350);
        float yaw = HelmRenderer.getYawFromOrientation(orientation);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
        matrices.method_22904(-0.5, 0.0, -0.5);
        if (!modelsLoaded) {
            HelmRenderer.loadModelOnce();
        }
        class_776 blockRenderer = client.method_1541();
        class_1087 class_10872 = helmModel != null ? helmModel : (modelToRender = helmBaseModel != null ? helmBaseModel : helmWheelModel);
        if (modelToRender != null) {
            try {
                class_2338 blockPos = new class_2338((int)Math.floor(framePos.field_1352), (int)Math.floor(framePos.field_1351), (int)Math.floor(framePos.field_1350));
                int light = class_761.method_23794((class_1920)HelmRenderer.client.field_1687, (class_2338)blockPos);
                blockRenderer.method_3350().method_3367(matrices.method_23760(), vertexConsumers.getBuffer(class_1921.method_23581()), null, modelToRender, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
            }
            catch (Exception e) {
                HelmRenderer.renderFallback(matrices, vertexConsumers, blockRenderer);
            }
        } else {
            HelmRenderer.renderFallback(matrices, vertexConsumers, blockRenderer);
        }
        matrices.method_22909();
    }

    private static float getYawFromOrientation(String orientation) {
        return switch (orientation) {
            case "SOUTH" -> 0.0f;
            case "WEST" -> 90.0f;
            case "NORTH" -> 180.0f;
            case "EAST" -> 270.0f;
            default -> 0.0f;
        };
    }

    private static synchronized void loadModelOnce() {
        if (modelsLoaded) {
            return;
        }
        modelsLoaded = true;
        try {
            if (client.method_1554() != null) {
                class_1087 model = client.method_1554().method_4742(HelmModelLoader.HELM_MAIN);
                if (model != null && model != client.method_1554().method_4744()) {
                    helmModel = model;
                    System.out.println("[HELM] Main model loaded successfully");
                } else {
                    helmModel = null;
                }
                class_1087 baseModel = client.method_1554().method_4742(HelmModelLoader.HELM_BASE_MAIN);
                if (baseModel != null && baseModel != client.method_1554().method_4744()) {
                    helmBaseModel = baseModel;
                    System.out.println("[HELM] Base model loaded successfully");
                } else {
                    helmBaseModel = null;
                }
                class_1087 wheelModel = client.method_1554().method_4742(HelmModelLoader.HELM_WHEEL_MAIN);
                if (wheelModel != null && wheelModel != client.method_1554().method_4744()) {
                    helmWheelModel = wheelModel;
                    System.out.println("[HELM] Wheel model loaded successfully");
                } else {
                    helmWheelModel = null;
                }
                if (helmModel == null && helmBaseModel == null && helmWheelModel == null) {
                    System.err.println("[HELM] No models could be loaded, will use fallback");
                } else {
                    System.out.println("[HELM] Models loading complete");
                }
            }
        }
        catch (Exception e) {
            helmModel = null;
            helmBaseModel = null;
            helmWheelModel = null;
            System.err.println("[HELM] Failed to load helm models: " + e.getMessage());
        }
    }

    private static void renderFallback(class_4587 matrices, class_4597 vertexConsumers, class_776 blockRenderer) {
        try {
            class_2680 fenceState = class_2246.field_10620.method_9564();
            blockRenderer.method_3353(fenceState, matrices, vertexConsumers, 0xF000F0, class_4608.field_21444);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        modelsLoaded = false;
        helmFrameCache = new ArrayList<class_1533>();
        lastCacheUpdate = 0L;
    }
}

