/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.mixins.ship;

import com.votive.airships.client.ships.ShipClientHandler;
import com.votive.airships.client.ships.ShipPacketHandler;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_591;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_591.class})
public class PlayerEntityModelMixin<T extends class_1309> {
    @Unique
    private float votiverp$currentSteeringAngle = 0.0f;
    @Unique
    private float votiverp$targetSteeringAngle = 0.0f;

    @Inject(method={"setAngles(Lnet/minecraft/entity/LivingEntity;FFFFF)V"}, at={@At(value="RETURN")})
    private void onSetAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        ShipPacketHandler.ActiveShipClient ship;
        if (!(entity instanceof class_742)) {
            return;
        }
        class_742 player = (class_742)entity;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        class_591 model = (class_591)this;
        String controlledShipId = null;
        int steeringDirection = 0;
        boolean isActuallyCaptain = false;
        if (entity == client.field_1724) {
            if (ShipClientHandler.getInstance().isControllingShip()) {
                controlledShipId = ShipPacketHandler.getControlledShipId();
                isActuallyCaptain = true;
            }
        } else {
            ShipPacketHandler.PassengerPosCache cache = ShipPacketHandler.getOtherPlayersPositions().get(player.method_5667());
            if (cache != null && cache.isCaptain && cache.shipId != null) {
                controlledShipId = cache.shipId;
                isActuallyCaptain = true;
                ShipPacketHandler.ActiveShipClient ship2 = ShipPacketHandler.getShips().get(controlledShipId);
                if (ship2 != null) {
                    steeringDirection = ship2.steeringWheelRotation;
                }
            }
        }
        if (!isActuallyCaptain) {
            this.votiverp$targetSteeringAngle = 0.0f;
            this.votiverp$smoothReset(model);
            return;
        }
        if (controlledShipId == null) {
            this.votiverp$targetSteeringAngle = 0.0f;
            this.votiverp$smoothReset(model);
            return;
        }
        if (entity == client.field_1724 && (ship = ShipPacketHandler.getShips().get(controlledShipId)) != null) {
            steeringDirection = ship.steeringWheelRotation;
        }
        this.votiverp$targetSteeringAngle = (float)steeringDirection * 0.7f;
        float interpolationSpeed = 0.05f;
        if (Math.abs(this.votiverp$targetSteeringAngle - this.votiverp$currentSteeringAngle) > 0.01f) {
            float diff = this.votiverp$targetSteeringAngle - this.votiverp$currentSteeringAngle;
            this.votiverp$currentSteeringAngle += diff * interpolationSpeed;
        } else {
            this.votiverp$currentSteeringAngle = this.votiverp$targetSteeringAngle;
        }
        float steeringNormalized = this.votiverp$currentSteeringAngle / 0.7f;
        float rightArmBasePitch = (float)Math.toRadians(-105.0);
        float rightArmBaseYaw = (float)Math.toRadians(35.0);
        float rightArmBaseRoll = (float)Math.toRadians(25.0);
        float rightArmCircularPitch = 0.0f;
        float rightArmCircularYaw = 0.0f;
        float rightArmCircularRoll = this.votiverp$currentSteeringAngle * (float)Math.toRadians(-60.0);
        model.field_3401.field_3654 = rightArmBasePitch + rightArmCircularPitch;
        model.field_3401.field_3675 = rightArmBaseYaw + rightArmCircularYaw;
        model.field_3401.field_3674 = rightArmBaseRoll + rightArmCircularRoll;
        model.field_3486.field_3654 = rightArmBasePitch + rightArmCircularPitch;
        model.field_3486.field_3675 = rightArmBaseYaw + rightArmCircularYaw;
        model.field_3486.field_3674 = rightArmBaseRoll + rightArmCircularRoll;
        float leftArmBasePitch = (float)Math.toRadians(-65.0);
        float leftArmBaseYaw = (float)Math.toRadians(-35.0);
        float leftArmBaseRoll = (float)Math.toRadians(-25.0);
        float leftArmCircularPitch = 0.0f;
        float leftArmCircularYaw = 0.0f;
        float leftArmCircularRoll = this.votiverp$currentSteeringAngle * (float)Math.toRadians(-60.0);
        model.field_27433.field_3654 = leftArmBasePitch + leftArmCircularPitch;
        model.field_27433.field_3675 = leftArmBaseYaw + leftArmCircularYaw;
        model.field_27433.field_3674 = leftArmBaseRoll + leftArmCircularRoll;
        model.field_3484.field_3654 = leftArmBasePitch + leftArmCircularPitch;
        model.field_3484.field_3675 = leftArmBaseYaw + leftArmCircularYaw;
        model.field_3484.field_3674 = leftArmBaseRoll + leftArmCircularRoll;
        if (ShipPacketHandler.isHeadRotationLocked(player.method_5667())) {
            model.field_3398.field_3675 = 0.0f;
            model.field_3398.field_3654 = 0.0f;
            model.field_3394.field_3675 = 0.0f;
            model.field_3394.field_3654 = 0.0f;
            model.field_3391.field_3675 = 0.0f;
        }
    }

    @Unique
    private void votiverp$smoothReset(class_591<?> model) {
        float resetSpeed = 0.1f;
        if (Math.abs(this.votiverp$currentSteeringAngle) > 0.01f) {
            this.votiverp$currentSteeringAngle *= 1.0f - resetSpeed;
            float scale = this.votiverp$currentSteeringAngle / 0.7f;
            model.field_3401.field_3654 += scale * (float)Math.toRadians(-105.0);
            model.field_3401.field_3675 += scale * (float)Math.toRadians(35.0);
            model.field_3401.field_3674 += scale * (float)Math.toRadians(25.0);
            model.field_3486.field_3654 += scale * (float)Math.toRadians(-105.0);
            model.field_3486.field_3675 += scale * (float)Math.toRadians(35.0);
            model.field_3486.field_3674 += scale * (float)Math.toRadians(25.0);
            model.field_27433.field_3654 += scale * (float)Math.toRadians(-65.0);
            model.field_27433.field_3675 += scale * (float)Math.toRadians(-35.0);
            model.field_27433.field_3674 += scale * (float)Math.toRadians(-25.0);
            model.field_3484.field_3654 += scale * (float)Math.toRadians(-65.0);
            model.field_3484.field_3675 += scale * (float)Math.toRadians(-35.0);
            model.field_3484.field_3674 += scale * (float)Math.toRadians(-25.0);
        } else {
            this.votiverp$currentSteeringAngle = 0.0f;
        }
    }
}

