/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client.mixins.btp;

import com.votive.airships.client.ships.ShipPacketHandler;
import com.votive.airships.client.ships.ShipPlayerController;
import io.socol.betterthirdperson.api.TickPhase;
import io.socol.betterthirdperson.api.adapter.IMovementInputAdapter;
import io.socol.betterthirdperson.api.adapter.IPlayerAdapter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"io.socol.betterthirdperson.api.CustomCameraManager"}, remap=false)
public class BTPCameraManagerMixin {
    @Inject(method={"onPlayerTick"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onPlayerTick(IPlayerAdapter playerAdapter, TickPhase tickPhase, CallbackInfo ci) {
        if (BTPCameraManagerMixin.isPlayerOnShip()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleMovementInputs"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onHandleMovementInputs(IPlayerAdapter playerAdapter, IMovementInputAdapter movementInputAdapter, TickPhase tickPhase, CallbackInfo ci) {
        if (BTPCameraManagerMixin.isPlayerOnShip()) {
            ci.cancel();
        }
    }

    private static boolean isPlayerOnShip() {
        String controlledShipId = ShipPacketHandler.getControlledShipId();
        ShipPlayerController.PlayerOnShip passengerShip = ShipPlayerController.getCurrentShip();
        return controlledShipId != null || passengerShip != null;
    }
}

