/*
 * Decompiled with CFR 0.152.
 */
package com.votive.airships.client;

import com.votive.airships.client.ships.HelmModelLoader;
import com.votive.airships.client.ships.HelmRenderer;
import com.votive.airships.client.ships.ShipBlockInteractionHandler;
import com.votive.airships.client.ships.ShipBoundaryRenderer;
import com.votive.airships.client.ships.ShipClientHandler;
import com.votive.airships.client.ships.ShipCollisionDetector;
import com.votive.airships.client.ships.ShipControlHandler;
import com.votive.airships.client.ships.ShipDebugKeys;
import com.votive.airships.client.ships.ShipHitboxRenderer;
import com.votive.airships.client.ships.ShipInteractionHandler;
import com.votive.airships.client.ships.ShipLoadHandler;
import com.votive.airships.client.ships.ShipMouseHandler;
import com.votive.airships.client.ships.ShipPacketHandler;
import com.votive.airships.client.ships.ShipPlayerController;
import com.votive.airships.client.ships.ShipRenderer;
import com.votive.airships.client.util.LogSpamFilter;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VotiveAirshipsClient
implements ClientModInitializer {
    public static final String MOD_ID = "votive-airships";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"VotiveAirships");
    public static ShipClientHandler shipClientHandler;
    public static ShipRenderer shipRenderer;
    public static ShipPacketHandler shipPacketHandler;
    public static ShipControlHandler shipControlHandler;
    public static ShipPlayerController shipPlayerController;
    public static ShipBoundaryRenderer shipBoundaryRenderer;
    public static ShipHitboxRenderer shipHitboxRenderer;
    public static ShipCollisionDetector shipCollisionDetector;
    public static ShipBlockInteractionHandler shipBlockInteractionHandler;
    public static ShipInteractionHandler shipInteractionHandler;
    public static ShipMouseHandler shipMouseHandler;
    public static ShipLoadHandler shipLoadHandler;

    public static class_2960 id(String path) {
        return new class_2960("votiveairships", path);
    }

    public void onInitializeClient() {
        LOGGER.info("VotiveAirships Client Mod initializing...");
        LogSpamFilter.register();
        HelmModelLoader.register();
        ShipClientHandler.initialize();
        shipClientHandler = ShipClientHandler.getInstance();
        shipRenderer = new ShipRenderer();
        shipPacketHandler = new ShipPacketHandler();
        shipControlHandler = new ShipControlHandler();
        shipPlayerController = new ShipPlayerController();
        shipBoundaryRenderer = new ShipBoundaryRenderer();
        shipHitboxRenderer = new ShipHitboxRenderer();
        shipCollisionDetector = new ShipCollisionDetector();
        shipBlockInteractionHandler = new ShipBlockInteractionHandler();
        ShipInteractionHandler.initialize();
        shipInteractionHandler = ShipInteractionHandler.getInstance();
        shipMouseHandler = new ShipMouseHandler();
        this.registerPacketReceivers();
        this.registerEventHandlers();
        LOGGER.info("VotiveAirships Client Mod initialized successfully!");
    }

    private void registerPacketReceivers() {
        ShipPacketHandler.register();
    }

    private void registerEventHandlers() {
        HelmRenderer.register();
        ShipBlockInteractionHandler.register();
        ShipMouseHandler.register();
        ShipLoadHandler.register();
        ShipDebugKeys.register();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1724 != null) {
                shipClientHandler.tick();
                ShipControlHandler.tick(client);
                shipRenderer.tick();
                ShipPacketHandler.updatePassengerPositionsTick();
            }
        });
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            ShipRenderer.render(context.matrixStack(), context.tickDelta());
            ShipBoundaryRenderer.render(context.matrixStack());
            ShipHitboxRenderer.render(context.matrixStack());
        });
    }
}

