/*
 * Decompiled with CFR 0.152.
 */
package schauweg.smoothswapping.config;

import org.jetbrains.annotations.NotNull;

public class Vec2
implements Comparable<Vec2> {
    static double Resolution = 72.0;
    static int xoffset = 120;
    static int yoffset = 120;
    public double[] v = new double[2];
    static final double radg = Math.atan(1.0) / 45.0;

    public Vec2(double x, double y) {
        this.set(x, y);
    }

    public Vec2(Vec2 src) {
        this(src.v[0], src.v[1]);
    }

    public Vec2(double theta) {
        this.set(Math.cos(theta *= radg), Math.sin(theta));
    }

    public int length() {
        return this.v.length;
    }

    public Vec2 set(double x, double y) {
        this.v[0] = x;
        this.v[1] = y;
        return this;
    }

    public int[] convert() {
        int[] iv = new int[2];
        this.convert(iv);
        return iv;
    }

    public void convert(int[] iv) {
        iv[0] = (int)((double)xoffset + this.v[0] * Resolution);
        iv[1] = (int)((double)yoffset - this.v[1] * Resolution);
    }

    public static Vec2 sum(Vec2 a, Vec2 b) {
        return new Vec2(a.v[0] + b.v[0], a.v[1] + b.v[1]);
    }

    public Vec2 sum(Vec2 b) {
        this.v[0] = this.v[0] + b.v[0];
        this.v[1] = this.v[1] + b.v[1];
        return this;
    }

    public Vec2 sumScalar(double b) {
        this.v[0] = this.v[0] + b;
        this.v[1] = this.v[1] + b;
        return this;
    }

    public Vec2 diffScalar(double b) {
        this.v[0] = this.v[0] - b;
        this.v[1] = this.v[1] - b;
        return this;
    }

    public Vec2 divideScalar(double b) {
        this.v[0] = this.v[0] / b;
        this.v[1] = this.v[1] / b;
        return this;
    }

    public Vec2 multiplyScalar(double b) {
        this.v[0] = this.v[0] * b;
        this.v[1] = this.v[1] * b;
        return this;
    }

    public Vec2 diff(Vec2 b) {
        this.v[0] = -b.v[0];
        this.v[1] = -b.v[1];
        return this;
    }

    public static Vec2 diff(Vec2 a, Vec2 b) {
        return new Vec2(a.v[0] - b.v[0], a.v[1] - b.v[1]);
    }

    public double magn() {
        return Math.sqrt(this.v[0] * this.v[0] + this.v[1] * this.v[1]);
    }

    public Vec2 scale(double s) {
        this.v[0] = this.v[0] * s;
        this.v[1] = this.v[1] * s;
        return this;
    }

    public Vec2 copy() {
        return new Vec2(this);
    }

    public Vec2 translate(double tx, double ty) {
        this.v[0] = this.v[0] + tx;
        this.v[1] = this.v[1] + ty;
        return this;
    }

    public Vec2 translate(Vec2 b) {
        this.v[0] = this.v[0] + b.v[0];
        this.v[1] = this.v[1] + b.v[1];
        return this;
    }

    public Vec2 rotate(double theta) {
        double c = Math.cos(theta *= radg);
        double s = Math.sin(theta);
        double t = this.v[1] * c + this.v[0] * s;
        this.v[0] = this.v[0] * c - this.v[1] * s;
        this.v[1] = t;
        return this;
    }

    public Vec2 perp() {
        double t = this.v[0];
        this.v[0] = -this.v[1];
        this.v[1] = t;
        return this;
    }

    public static Vec2 perp(Vec2 a) {
        return new Vec2(-a.v[1], a.v[0]);
    }

    public static double perpdot(Vec2 a, Vec2 b) {
        return a.v[0] * b.v[1] - a.v[1] * b.v[0];
    }

    public static double dot(Vec2 a, Vec2 b) {
        return a.v[0] * b.v[0] + a.v[1] * b.v[1];
    }

    public static double distance(Vec2 a, Vec2 b) {
        return Vec2.diff(a, b).magn();
    }

    public static double angle(Vec2 a, Vec2 b) {
        double c = Vec2.dot(a, b);
        double s = Vec2.perpdot(a, b);
        return Math.atan2(s, c) / radg;
    }

    public void setSize(double sz) {
        double vnorm = this.magn();
        if (vnorm == 0.0) {
            return;
        }
        this.v[0] = this.v[0] * (sz /= vnorm);
        this.v[1] = this.v[1] * sz;
    }

    public String toString() {
        return String.format("[%.3g %.3g]", this.v[0], this.v[1]);
    }

    @Override
    public int compareTo(@NotNull Vec2 o) {
        return Double.compare(this.v[0], o.v[0]);
    }
}

