/*
 * Decompiled with CFR 0.152.
 */
package schauweg.smoothswapping.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import schauweg.smoothswapping.SmoothSwapping;
import schauweg.smoothswapping.config.Config;

public class ConfigManager {
    private static File file;
    private static Config config;

    private static void prepareConfigFile() {
        if (file != null) {
            return;
        }
        file = FabricLoader.getInstance().getConfigDir().resolve("smoothswapping.json").toFile();
    }

    public static Config initializeConfig() {
        if (config != null) {
            return config;
        }
        config = new Config();
        ConfigManager.load();
        return config;
    }

    private static void load() {
        ConfigManager.prepareConfigFile();
        try {
            BufferedReader br;
            Config parsed;
            if (!file.exists()) {
                ConfigManager.save();
            }
            if (file.exists() && (parsed = (Config)SmoothSwapping.GSON.fromJson((Reader)(br = new BufferedReader(new FileReader(file))), Config.class)) != null) {
                config = parsed;
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't load Login Toast configuration file; reverting to defaults");
            e.printStackTrace();
        }
    }

    public static void save() {
        ConfigManager.prepareConfigFile();
        String jsonString = SmoothSwapping.GSON.toJson((Object)config);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save Login Toast configuration file");
            e.printStackTrace();
        }
    }

    public static Config getConfig() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }
}

