/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.sgson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.zeydie.sgson.SGsonBase;
import com.zeydie.sgson.streams.FileReaderStream;
import com.zeydie.sgson.streams.FileWriterStream;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class SGsonFile
extends SGsonBase {
    @NotNull
    private final File file;
    @NotNull
    private final FileReaderStream fileReaderStream;
    @NotNull
    private final FileWriterStream fileWriterStream;

    public <S extends String> SGsonFile(@NonNull S path) {
        this((File)((Object)Paths.get(path, new String[0])));
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    public <P extends Path> SGsonFile(@NonNull P path) {
        this(path.toFile());
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    public <F extends File> SGsonFile(@NonNull F file) {
        this(file, new GsonBuilder());
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
    }

    public <F extends File, G extends GsonBuilder> SGsonFile(@NonNull F file, @NonNull G gsonBuilder) {
        this(file, gsonBuilder.create());
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (gsonBuilder == null) {
            throw new NullPointerException("gsonBuilder is marked non-null but is null");
        }
    }

    public <F extends File, G extends Gson> SGsonFile(@NonNull F file, @NonNull G gson) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
        this.setGson(gson);
        this.file = file;
        this.fileReaderStream = new FileReaderStream(this);
        this.fileWriterStream = new FileWriterStream(this);
    }

    @NotNull
    public static <S extends String> SGsonFile create(@NonNull S path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new SGsonFile(path);
    }

    @NotNull
    public static <P extends Path> SGsonFile create(@NonNull P path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new SGsonFile(path);
    }

    @NotNull
    public static <F extends File> SGsonFile create(@NonNull F file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return new SGsonFile(file);
    }

    @NotNull
    public static <S extends String> SGsonFile createPretty(@NonNull S path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return (SGsonFile)new SGsonFile(path).setPretty();
    }

    @NotNull
    public static <P extends Path> SGsonFile createPretty(@NonNull P path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return (SGsonFile)new SGsonFile(path).setPretty();
    }

    @NotNull
    public static <F extends File> SGsonFile createPretty(@NonNull F file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return (SGsonFile)new SGsonFile(file).setPretty();
    }

    @NotNull
    public final <T> T fromJsonToObject(@NonNull T object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        return this.fromJsonToObject(object, false);
    }

    @NotNull
    public final <T> T fromJsonToObject(@NonNull T object, boolean rewrite) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (rewrite || !this.file.exists() || this.file.length() <= 0L) {
            this.writeJsonFile((CharSequence)this.fromObjectToJson(object));
        }
        return this.fromJsonToObject(this.getJsonFile(), object);
    }

    @NotNull
    public final String getJsonFile() {
        return this.fileReaderStream.getJsonFile();
    }

    public final <O> void writeJsonFile(@NonNull O object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        this.writeJsonFile((CharSequence)this.fromObjectToJson(object));
    }

    public final <S extends CharSequence> void writeJsonFile(@NonNull S json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        this.fileWriterStream.writeJsonFile(json);
    }

    @NotNull
    @Generated
    public File getFile() {
        return this.file;
    }

    @NotNull
    @Generated
    public FileReaderStream getFileReaderStream() {
        return this.fileReaderStream;
    }

    @NotNull
    @Generated
    public FileWriterStream getFileWriterStream() {
        return this.fileWriterStream;
    }
}

