/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.pekhuisyn.common.client;

import com.google.common.collect.BiMap;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.zeydie.pekhuisyn.api.ScaleDataPacket;
import com.zeydie.pekhuisyn.api.ScaleTypes;
import com.zeydie.pekhuisyn.common.PekhuiSyn;
import com.zeydie.sgson.SGsonBase;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import lombok.NonNull;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.util.ModLoaderUtils;

@Environment(value=EnvType.CLIENT)
public final class PekhuiSynClient
implements ClientModInitializer {
    private static final Set<String> requestedPlayers = new HashSet<String>();
    private static final Map<String, Long> requestTimestamps = new HashMap<String, Long>();

    public void onInitializeClient() {
        this.startNetwork();
        this.registerEntityTracker();
        this.startCacheCleanup();
    }

    private void startNetwork() {
        if (ModLoaderUtils.isModLoaded((String)"fabric-networking-api-v1")) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)PekhuiSyn.CHANNEL, (client, handler, buf, responseSender) -> {
                byte[] bytes = new byte[buf.readableBytes()];
                buf.readBytes(bytes);
                String json = new String(bytes, StandardCharsets.UTF_8);
                ScaleDataPacket scaleDataPacket = SGsonBase.create().fromJsonToObject(json, new ScaleDataPacket());
                final String playerName = scaleDataPacket.getPlayerName();
                final Map<ScaleTypes, Float> typesScales = scaleDataPacket.getTypesScales();
                client.execute(new Runnable(){
                    final /* synthetic */ PekhuiSynClient this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        class_638 world = client.field_1687;
                        if (world != null) {
                            Optional<class_1657> playerEntityOptional = world.method_18456().stream().filter(input -> input.method_5477().getString().equals(playerName)).findFirst();
                            if (playerEntityOptional.isPresent()) {
                                class_1657 playerEntity = playerEntityOptional.get();
                                for (ScaleTypes scaleTypes : typesScales.keySet()) {
                                    ScaleType scaleType = this.getScaleType(scaleTypes);
                                    class_2960 typeId = ScaleRegistries.getId((BiMap)ScaleRegistries.SCALE_TYPES, (Object)scaleType);
                                    Float scale = (Float)typesScales.get((Object)scaleTypes);
                                    ((ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (class_2960)typeId)).getScaleData((class_1297)playerEntity).setScale(scale.floatValue());
                                }
                            }
                        } else {
                            client.execute((Runnable)this);
                        }
                    }

                    @NotNull
                    private ScaleType getScaleType(@NonNull ScaleTypes type) {
                        if (type == null) {
                            throw new NullPointerException("type is marked non-null but is null");
                        }
                        switch (type) {
                            case BASE: {
                                return virtuoel.pehkui.api.ScaleTypes.BASE;
                            }
                            case WIDTH: {
                                return virtuoel.pehkui.api.ScaleTypes.WIDTH;
                            }
                            case HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.HEIGHT;
                            }
                            case EYE_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.EYE_HEIGHT;
                            }
                            case HITBOX_WIDTH: {
                                return virtuoel.pehkui.api.ScaleTypes.HITBOX_WIDTH;
                            }
                            case HITBOX_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.HITBOX_HEIGHT;
                            }
                            case MODEL_WIDTH: {
                                return virtuoel.pehkui.api.ScaleTypes.MODEL_WIDTH;
                            }
                            case MODEL_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.MODEL_HEIGHT;
                            }
                            case THIRD_PERSON: {
                                return virtuoel.pehkui.api.ScaleTypes.THIRD_PERSON;
                            }
                            case MOTION: {
                                return virtuoel.pehkui.api.ScaleTypes.MOTION;
                            }
                            case FALLING: {
                                return virtuoel.pehkui.api.ScaleTypes.FALLING;
                            }
                            case STEP_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.STEP_HEIGHT;
                            }
                            case VIEW_BOBBING: {
                                return virtuoel.pehkui.api.ScaleTypes.VIEW_BOBBING;
                            }
                            case VISIBILITY: {
                                return virtuoel.pehkui.api.ScaleTypes.VISIBILITY;
                            }
                            case JUMP_HEIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.JUMP_HEIGHT;
                            }
                            case FLIGHT: {
                                return virtuoel.pehkui.api.ScaleTypes.FLIGHT;
                            }
                            case REACH: {
                                return virtuoel.pehkui.api.ScaleTypes.REACH;
                            }
                            case BLOCK_REACH: {
                                return virtuoel.pehkui.api.ScaleTypes.BLOCK_REACH;
                            }
                            case ENTITY_REACH: {
                                return virtuoel.pehkui.api.ScaleTypes.ENTITY_REACH;
                            }
                            case MINING_SPEED: {
                                return virtuoel.pehkui.api.ScaleTypes.MINING_SPEED;
                            }
                            case ATTACK_SPEED: {
                                return virtuoel.pehkui.api.ScaleTypes.ATTACK_SPEED;
                            }
                            case KNOCKBACK: {
                                return virtuoel.pehkui.api.ScaleTypes.KNOCKBACK;
                            }
                            case ATTACK: {
                                return virtuoel.pehkui.api.ScaleTypes.ATTACK;
                            }
                            case DEFENSE: {
                                return virtuoel.pehkui.api.ScaleTypes.DEFENSE;
                            }
                            case HEALTH: {
                                return virtuoel.pehkui.api.ScaleTypes.HEALTH;
                            }
                            case DROPS: {
                                return virtuoel.pehkui.api.ScaleTypes.DROPS;
                            }
                            case HELD_ITEM: {
                                return virtuoel.pehkui.api.ScaleTypes.HELD_ITEM;
                            }
                            case PROJECTILES: {
                                return virtuoel.pehkui.api.ScaleTypes.PROJECTILES;
                            }
                            case EXPLOSIONS: {
                                return virtuoel.pehkui.api.ScaleTypes.EXPLOSIONS;
                            }
                        }
                        return virtuoel.pehkui.api.ScaleTypes.INVALID;
                    }
                });
            });
        } else {
            PekhuiSyn.LOGGER.error("Failed to register Pehkui's packet handlers! Is Fabric API's networking module missing?");
        }
    }

    private void registerEntityTracker() {
        if (!ModLoaderUtils.isModLoaded((String)"fabric-networking-api-v1")) {
            return;
        }
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                final class_310 client = class_310.method_1551();
                if (client.field_1724 != null && !player.method_5667().equals(client.field_1724.method_5667())) {
                    final String playerName = player.method_5477().getString();
                    new Timer().schedule(new TimerTask(this){
                        final /* synthetic */ PekhuiSynClient this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            client.execute(() -> {
                                this.this$0.requestScaleData(playerName);
                                this.this$0.requestBodyPartsData(playerName);
                            });
                        }
                    }, 100L);
                }
            }
        });
    }

    private void startCacheCleanup() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1687.method_8510() % 200L == 0L) {
                long currentTime = System.currentTimeMillis();
                requestTimestamps.entrySet().removeIf(entry -> {
                    if (currentTime - (Long)entry.getValue() > 10000L) {
                        requestedPlayers.remove(entry.getKey());
                        return true;
                    }
                    return false;
                });
            }
        });
    }

    private void requestScaleData(String playerName) {
        if (requestedPlayers.contains(playerName)) {
            return;
        }
        try {
            requestedPlayers.add(playerName);
            requestTimestamps.put(playerName, System.currentTimeMillis());
            String requestJson = "{\"action\":\"request\",\"playerName\":\"" + playerName + "\"}";
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(requestJson);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)PekhuiSyn.CHANNEL, (class_2540)buf);
        }
        catch (Exception e) {
            requestedPlayers.remove(playerName);
            requestTimestamps.remove(playerName);
            e.printStackTrace();
        }
    }

    private static void markPlayerReceived(String playerName) {
    }

    private void requestBodyPartsData(String playerName) {
        try {
            String requestJson = "{\"action\":\"request\",\"playerName\":\"" + playerName + "\"}";
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(requestJson);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            class_2960 bodyPartsChannel = new class_2960("bodyparts", "body_part_update");
            ClientPlayNetworking.send((class_2960)bodyPartsChannel, (class_2540)buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

