/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.util.VersionUtils;

public final class ReflectionUtils {
    public static final Class<?> ENTITY_DAMAGE_SOURCE;
    public static final MethodHandle GET_ATTACKER;
    public static final MethodHandle GET_FLYING_SPEED;
    public static final MethodHandle SET_FLYING_SPEED;

    @Nullable
    public static class_1297 getAttacker(class_1282 source) {
        if (ENTITY_DAMAGE_SOURCE != null) {
            if (ENTITY_DAMAGE_SOURCE.isInstance(source)) {
                try {
                    return GET_ATTACKER.invoke(ENTITY_DAMAGE_SOURCE.cast(source));
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
        return source.method_5529();
    }

    public static float getFlyingSpeed(class_1309 entity) {
        try {
            return GET_FLYING_SPEED.invoke(entity);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFlyingSpeed(class_1309 entity, float speed) {
        try {
            SET_FLYING_SPEED.invoke(entity, speed);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(c -> {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException | SecurityException exception) {
                return null;
            }
        });
    }

    public static void setField(Optional<Class<?>> classObj, String fieldName, Object object, Object value) {
        ReflectionUtils.getField(classObj, fieldName).ifPresent(f -> {
            try {
                f.set(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }

    public static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(c -> {
            try {
                Method m = c.getMethod(methodName, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return null;
            }
        });
    }

    public static <T> Optional<Constructor<T>> getConstructor(Optional<Class<T>> clazz, Class<?> ... params) {
        return clazz.map(c -> {
            try {
                return c.getConstructor(params);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static Optional<Class<?>> getClass(String className, String ... classNames) {
        Optional<Class<?>> ret = ReflectionUtils.getClass(className);
        for (String name : classNames) {
            if (ret.isPresent()) {
                return ret;
            }
            ret = ReflectionUtils.getClass(name);
        }
        return ret;
    }

    public static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
    }

    private ReflectionUtils() {
    }

    static {
        MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
        Int2ObjectArrayMap h = new Int2ObjectArrayMap();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String mapped = "unset";
        Class<?> clazz = null;
        try {
            boolean is1193Minus;
            boolean bl = is1193Minus = VersionUtils.MINOR < 19 || VersionUtils.MINOR == 19 && VersionUtils.PATCH <= 3;
            if (is1193Minus) {
                mapped = mappingResolver.mapClassName("intermediary", "net.minecraft.class_1285");
                clazz = Class.forName(mapped);
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_1285", "method_5529", "()Lnet/minecraft/class_1297;");
                Method m = clazz.getMethod(mapped, new Class[0]);
                h.put(0, (Object)lookup.unreflect(m));
                mapped = mappingResolver.mapFieldName("intermediary", "net.minecraft.class_1309", "field_6281", "F");
                Field f = class_1309.class.getField(mapped);
                f.setAccessible(true);
                h.put(1, (Object)lookup.unreflectGetter(f));
                h.put(2, (Object)lookup.unreflectSetter(f));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            Pehkui.LOGGER.error("Current name lookup: {}", new Object[]{mapped});
            Pehkui.LOGGER.catching((Throwable)e);
        }
        ENTITY_DAMAGE_SOURCE = clazz;
        GET_ATTACKER = (MethodHandle)h.get(0);
        GET_FLYING_SPEED = (MethodHandle)h.get(1);
        SET_FLYING_SPEED = (MethodHandle)h.get(2);
    }
}

