/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_2096;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.command.argument.ScaleEasingArgumentType;
import virtuoel.pehkui.command.argument.ScaleModifierArgumentType;
import virtuoel.pehkui.command.argument.ScaleOperationArgumentType;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.server.command.ScaleCommand;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.VersionUtils;

public class CommandUtils {
    public static final Method REGISTER_ARGUMENT_TYPE;
    public static final Method TEST_FLOAT_RANGE;
    public static final Method SEND_FEEDBACK;

    public static void registerCommands() {
        if (ModLoaderUtils.isModLoaded("fabric-command-api-v2")) {
            V2ApiClassloading.registerV2ApiCommands();
        } else if (ModLoaderUtils.isModLoaded("fabric-command-api-v1")) {
            CommandUtils.registerV1ApiCommands();
        }
    }

    public static void registerArgumentTypes() {
        if (ModLoaderUtils.isModLoaded("fabric-command-api-v2") && ModLoaderUtils.isModLoaded("fabric-registry-sync-v0")) {
            V2ApiClassloading.registerArgumentTypes();
        } else if (VersionUtils.MINOR <= 18) {
            CommandUtils.registerArgumentTypes(CommandUtils::registerConstantArgumentType);
        }
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        ScaleCommand.register(dispatcher);
        DebugCommand.register(dispatcher);
    }

    private static void registerV1ApiCommands() {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Method staticRegister = CommandUtils.class.getDeclaredMethod("registerV1ApiCommands", CommandDispatcher.class, Boolean.TYPE);
            MethodHandle staticRegisterHandle = lookup.unreflect(staticRegister);
            MethodType staticRegisterType = staticRegisterHandle.type();
            Class<?> callbackClass = Class.forName("net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback");
            Event registerEvent = (Event)callbackClass.getField("EVENT").get(null);
            Method register = callbackClass.getDeclaredMethod("register", CommandDispatcher.class, Boolean.TYPE);
            MethodType registerType = MethodType.methodType(register.getReturnType(), register.getParameterTypes());
            MethodType factoryMethodType = MethodType.methodType(callbackClass);
            CallSite lambdaFactory = LambdaMetafactory.metafactory(lookup, "register", factoryMethodType, registerType, staticRegisterHandle, staticRegisterType);
            MethodHandle factoryInvoker = lambdaFactory.getTarget();
            Object eventLambda = factoryInvoker.asType(factoryMethodType).invokeWithArguments(Collections.emptyList());
            registerEvent.register(eventLambda);
        }
        catch (Throwable e) {
            Pehkui.LOGGER.catching(e);
        }
    }

    protected static void registerV1ApiCommands(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        CommandUtils.registerCommands(dispatcher);
    }

    public static void registerArgumentTypes(ArgumentTypeConsumer consumer) {
        consumer.register(Pehkui.id("scale_type"), ScaleTypeArgumentType.class, ScaleTypeArgumentType::scaleType);
        consumer.register(Pehkui.id("scale_modifier"), ScaleModifierArgumentType.class, ScaleModifierArgumentType::scaleModifier);
        consumer.register(Pehkui.id("scale_operation"), ScaleOperationArgumentType.class, ScaleOperationArgumentType::operation);
        consumer.register(Pehkui.id("scale_easing"), ScaleEasingArgumentType.class, ScaleEasingArgumentType::scaleEasing);
    }

    public static void sendFeedback(class_2168 source, Supplier<class_2561> text, boolean broadcastToOps) {
        if (SEND_FEEDBACK != null) {
            try {
                SEND_FEEDBACK.invoke((Object)source, text.get(), broadcastToOps);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Pehkui.LOGGER.catching((Throwable)e);
            }
        }
        source.method_9226(text, broadcastToOps);
    }

    public static boolean testFloatRange(class_2096.class_2099 range, float value) {
        if (TEST_FLOAT_RANGE != null) {
            try {
                return (Boolean)TEST_FLOAT_RANGE.invoke((Object)range, Float.valueOf(value));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Pehkui.LOGGER.catching((Throwable)e);
            }
        }
        return false;
    }

    public static <T extends ArgumentType<?>> void registerConstantArgumentType(class_2960 id, Class<? extends T> argClass, Supplier<T> supplier) {
        if (REGISTER_ARGUMENT_TYPE != null) {
            try {
                REGISTER_ARGUMENT_TYPE.invoke(null, id.toString(), argClass, class_2319.class.getConstructor(Supplier.class).newInstance(supplier));
            }
            catch (Throwable e) {
                Pehkui.LOGGER.catching(e);
            }
        }
    }

    public static CompletableFuture<Suggestions> suggestIdentifiersIgnoringNamespace(String namespace, Iterable<class_2960> candidates, SuggestionsBuilder builder) {
        CommandUtils.forEachMatchingIgnoringNamespace(namespace, candidates, builder.getRemaining().toLowerCase(Locale.ROOT), Function.identity(), id -> builder.suggest(String.valueOf(id)));
        return builder.buildFuture();
    }

    public static <T> void forEachMatchingIgnoringNamespace(String namespace, Iterable<T> candidates, String string, Function<T, class_2960> idFunc, Consumer<T> action) {
        boolean hasColon = string.indexOf(58) > -1;
        for (T object : candidates) {
            class_2960 id = idFunc.apply(object);
            if (hasColon) {
                if (!CommandUtils.wordStartsWith(string, id.toString(), '_')) continue;
                action.accept(object);
                continue;
            }
            if (!CommandUtils.wordStartsWith(string, id.method_12836(), '_') && (!id.method_12836().equals(namespace) || !CommandUtils.wordStartsWith(string, id.method_12832(), '_'))) continue;
            action.accept(object);
        }
    }

    public static boolean wordStartsWith(String string, String substring, char wordSeparator) {
        int i = 0;
        while (!substring.startsWith(string, i)) {
            if ((i = substring.indexOf(wordSeparator, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();
        Int2ObjectArrayMap h = new Int2ObjectArrayMap();
        String mapped = "unset";
        try {
            boolean is119Minus;
            boolean is116Minus = VersionUtils.MINOR <= 16;
            boolean is118Minus = VersionUtils.MINOR <= 18;
            boolean bl = is119Minus = VersionUtils.MINOR <= 19;
            if (is118Minus) {
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2316", "method_10017", "(Ljava/lang/String;Ljava/lang/Class;Lnet/minecraft/class_2314;)V");
                h.put(0, (Object)class_2316.class.getMethod(mapped, String.class, Class.class, class_2314.class));
            }
            mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2096$class_2099", "method_9047", is116Minus ? "(F)Z" : "(D)Z");
            h.put(1, (Object)class_2096.class_2099.class.getMethod(mapped, is116Minus ? Float.TYPE : Double.TYPE));
            if (is119Minus) {
                mapped = mappingResolver.mapMethodName("intermediary", "net.minecraft.class_2168", "method_9226", "(Lnet/minecraft/class_2561;Z)V");
                h.put(2, (Object)class_2168.class.getMethod(mapped, class_2561.class, Boolean.TYPE));
            }
        }
        catch (NoSuchMethodException | SecurityException e1) {
            Pehkui.LOGGER.error("Last method lookup: {}", new Object[]{mapped});
            Pehkui.LOGGER.catching((Throwable)e1);
        }
        REGISTER_ARGUMENT_TYPE = (Method)h.get(0);
        TEST_FLOAT_RANGE = (Method)h.get(1);
        SEND_FEEDBACK = (Method)h.get(2);
    }

    private static class V2ApiClassloading {
        private V2ApiClassloading() {
        }

        private static void registerV2ApiCommands() {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, dedicated) -> CommandUtils.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        }

        private static void registerArgumentTypes() {
            CommandUtils.registerArgumentTypes(new ArgumentTypeConsumer(){

                @Override
                public <T extends ArgumentType<?>> void register(class_2960 id, Class<T> argClass, Supplier<T> supplier) {
                    ArgumentTypeRegistry.registerArgumentType((class_2960)id, argClass, (class_2314)class_2319.method_41999(supplier));
                }
            });
        }
    }

    @FunctionalInterface
    public static interface ArgumentTypeConsumer {
        public <T extends ArgumentType<?>> void register(class_2960 var1, Class<T> var2, Supplier<T> var3);
    }
}

