/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import virtuoel.pehkui.util.BackwardsCompatibility;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.VersionUtils;

public class PehkuiMixinConfigPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE = "virtuoel.pehkui.mixin";
    private static final boolean REACH_ATTRIBUTES_LOADED = ModLoaderUtils.isModLoaded("reach-entity-attributes");
    private static final boolean STEP_HEIGHT_ATTRIBUTES_LOADED = ModLoaderUtils.isModLoaded("step-height-entity-attribute");
    private static final boolean IDENTITY_LOADED = ModLoaderUtils.isModLoaded("identity");
    private static final boolean MAGNA_LOADED = ModLoaderUtils.isModLoaded("magna");
    private static final boolean OPTIFABRIC_LOADED = ModLoaderUtils.isModLoaded("optifabric");
    private static final boolean PATCHWORK_ENTITY_EVENTS_LOADED = ModLoaderUtils.isModLoaded("patchwork-events-entity");

    public void onLoad(String mixinPackage) {
        if (!mixinPackage.startsWith(MIXIN_PACKAGE)) {
            throw new IllegalArgumentException(String.format("Invalid package: Expected \"%s\", but found \"%s\".", MIXIN_PACKAGE, mixinPackage));
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.startsWith(MIXIN_PACKAGE)) {
            throw new IllegalArgumentException(String.format("Invalid package for class \"%s\": Expected \"%s\", but found \"%s\".", targetClassName, MIXIN_PACKAGE, mixinClassName));
        }
        if (!VersionUtils.shouldApplyCompatibilityMixin(mixinClassName)) {
            return false;
        }
        if (mixinClassName.endsWith("InGameOverlayRendererMixin")) {
            return OPTIFABRIC_LOADED == mixinClassName.contains(".optifine.compat.");
        }
        if (mixinClassName.endsWith("EntityCalculateDimensionsMixin")) {
            return PATCHWORK_ENTITY_EVENTS_LOADED == mixinClassName.contains(".patchwork.compat.");
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.reach")) {
            return REACH_ATTRIBUTES_LOADED == mixinClassName.contains(".reach.compat.");
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.step_height")) {
            return STEP_HEIGHT_ATTRIBUTES_LOADED == mixinClassName.contains("virtuoel.pehkui.mixin.step_height.compat.");
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.identity.compat")) {
            return IDENTITY_LOADED;
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.magna.compat")) {
            return MAGNA_LOADED;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (mixinClassName.equals("virtuoel.pehkui.mixin.pehkui.compat.ScaleTypeMixin")) {
            BackwardsCompatibility.addFieldsIfNeeded(name -> targetClass.visitField(9, name, "L" + targetClass.name + ";", null, null));
        }
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

