/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.itemsbobbing.mixin.client.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zeydie.itemsbobbing.ItemsBobbing;
import com.zeydie.itemsbobbing.gui.ButtonInfo;
import com.zeydie.itemsbobbing.gui.WebMapScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_507;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_490.class})
public abstract class InventoryScreenMixin
extends class_465<class_1723> {
    private static final class_2960 CUSTOM_INVENTORY_TEXTURE = new class_2960("itemsbobbing", "textures/gui/custom_inventory.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int ACTUAL_TEXTURE_WIDTH = 256;
    private static final int ACTUAL_TEXTURE_HEIGHT = 256;
    private static final class_2960 BUTTON_RING = new class_2960("itemsbobbing", "textures/gui/ring.png");
    private static final class_2960 BUTTON_RING_HOVER = new class_2960("itemsbobbing", "textures/gui/ring_hovered.png");
    private static final class_2960 BUTTON_CRAFT = new class_2960("itemsbobbing", "textures/gui/craft.png");
    private static final class_2960 BUTTON_CRAFT_HOVER = new class_2960("itemsbobbing", "textures/gui/craft_hovered.png");
    private static final class_2960 BUTTON_MAP = new class_2960("itemsbobbing", "textures/gui/map.png");
    private static final class_2960 BUTTON_MAP_HOVER = new class_2960("itemsbobbing", "textures/gui/map_hovered.png");
    private static final class_2960 BUTTON_PERSONE = new class_2960("itemsbobbing", "textures/gui/person.png");
    private static final class_2960 BUTTON_PERSONE_HOVER = new class_2960("itemsbobbing", "textures/gui/person_hovered.png");
    private static final int BUTTONS_SIZE = 16;
    private final List<ButtonInfo> buttons = new ArrayList<ButtonInfo>();
    private boolean hasRenderedButtons = false;
    private List<class_1735> originalSlots = new ArrayList<class_1735>();
    private static final Map<String, float[]> BONUS_POSITIONS = new HashMap<String, float[]>();
    @Shadow
    private class_507 field_2929;
    @Shadow
    private boolean field_2931;

    private void initButtons() {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.buttons.clear();
        this.buttons.add(new ButtonInfo(BUTTON_RING, BUTTON_RING_HOVER, x + 115, y + 7, "\u0410\u043a\u0441\u0435\u0441\u0441\u0443\u0430\u0440\u044b", "accessory_menu"));
        this.buttons.add(new ButtonInfo(BUTTON_CRAFT, BUTTON_CRAFT_HOVER, x + 134, y + 7, "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432", "craft"));
        this.buttons.add(new ButtonInfo(BUTTON_MAP, BUTTON_MAP_HOVER, x + 152, y + 7, "\u041a\u0430\u0440\u0442\u0430", "spawn_map"));
        this.buttons.add(new ButtonInfo(BUTTON_PERSONE, BUTTON_PERSONE_HOVER, x + 152, y + 62, "\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u0436", "character_menu"));
    }

    protected InventoryScreenMixin(class_1723 handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    @Inject(method={"drawBackground"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDrawBackground(class_4587 matrices, float delta, int mouseX, int mouseY, CallbackInfo ci) {
        ci.cancel();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)CUSTOM_INVENTORY_TEXTURE);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        int x = (this.field_22789 - 256) / 2;
        int y = (this.field_22790 - 256) / 2;
        InventoryScreenMixin.method_25290((class_4587)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)256, (int)256, (int)256, (int)256);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            this.drawEntity(x + 51, y + 69, 30, (class_1657)player);
        }
    }

    @Redirect(method={"drawForeground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/font/TextRenderer;draw(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/text/Text;FFI)I"))
    private int redirectDrawText(class_327 textRenderer, class_4587 matrices, class_2561 text, float x, float y, int color) {
        if (text.getString().equals("Crafting") || text.getString().equals("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435")) {
            return 0;
        }
        return textRenderer.method_30883(matrices, text, x, y, color);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void modifySlotsBeforeRender(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.originalSlots.isEmpty()) {
            this.originalSlots = new ArrayList<class_1735>((Collection<class_1735>)((class_1723)this.field_2797).field_7761);
        }
        ArrayList<class_1735> filteredSlots = new ArrayList<class_1735>();
        for (class_1735 slot : ((class_1723)this.field_2797).field_7761) {
            if (this.isCraftingSlot(slot)) continue;
            filteredSlots.add(slot);
        }
        ((class_1723)this.field_2797).field_7761.clear();
        ((class_1723)this.field_2797).field_7761.addAll(filteredSlots);
        this.hasRenderedButtons = false;
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void restoreSlotsAfterRender(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!this.originalSlots.isEmpty()) {
            ((class_1723)this.field_2797).field_7761.clear();
            ((class_1723)this.field_2797).field_7761.addAll(this.originalSlots);
        }
        if (!this.hasRenderedButtons) {
            this.renderButtons(matrices, mouseX, mouseY);
            this.hasRenderedButtons = true;
        }
        this.renderDiceBonuses(matrices);
    }

    private void renderDiceBonuses(class_4587 matrices) {
        int x = (this.field_22789 - 256) / 2;
        int y = (this.field_22790 - 256) / 2;
        List<String> types = Arrays.asList("attack", "defend", "escape", "mattack", "mdefend", "mescape");
        for (String type : types) {
            int bonus = ItemsBobbing.diceBonuses.getOrDefault(type, 0);
            String diceText = String.valueOf(bonus);
            float[] pos = BONUS_POSITIONS.get(type);
            float diceX = (float)x + pos[0];
            float diceY = (float)y + pos[1];
            float scale = pos[2];
            int color = -13817819;
            int shadowColor = 539830309;
            matrices.method_22903();
            matrices.method_22905(scale, scale, 1.0f);
            this.field_22793.method_1729(matrices, diceText, diceX / scale + 1.0f, diceY / scale + 1.0f, shadowColor);
            this.field_22793.method_1729(matrices, diceText, diceX / scale, diceY / scale, color);
            matrices.method_22909();
        }
    }

    private void renderButtons(class_4587 matrices, int mouseX, int mouseY) {
        class_310 client = class_310.method_1551();
        client.method_22940().method_23000().method_22993();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ButtonInfo hoveredButton = null;
        for (ButtonInfo button : this.buttons) {
            if (!button.isHovered(mouseX, mouseY)) continue;
            hoveredButton = button;
            break;
        }
        for (ButtonInfo button : this.buttons) {
            try {
                boolean isHovered = button == hoveredButton;
                class_2960 texture = isHovered ? button.hoverTexture : button.texture;
                if (texture == null) continue;
                RenderSystem.setShaderTexture((int)0, (class_2960)texture);
                class_332.method_25290((class_4587)matrices, (int)button.posX, (int)button.posY, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            catch (Exception exception) {}
        }
        if (hoveredButton != null) {
            this.renderHoverText(matrices, mouseX, mouseY, hoveredButton.hoverText);
        }
        RenderSystem.disableBlend();
    }

    private void renderHoverText(class_4587 matrices, int mouseX, int mouseY, String text) {
        int textX = mouseX + 10;
        int textY = mouseY - 10;
        int padding = 2;
        int textWidth = this.field_22793.method_1727(text);
        int textHeight = 8;
        int borderWidth = 1;
        class_332.method_25294((class_4587)matrices, (int)(textX - padding - borderWidth), (int)(textY - padding - borderWidth), (int)(textX + textWidth + padding + borderWidth), (int)(textY + textHeight + padding + borderWidth), (int)-1);
        class_332.method_25294((class_4587)matrices, (int)(textX - padding), (int)(textY - padding), (int)(textX + textWidth + padding), (int)(textY + textHeight + padding), (int)-16777216);
        this.field_22793.method_1729(matrices, text, (float)textX, (float)textY, 0xFFFFFF);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        for (ButtonInfo buttonInfo : this.buttons) {
            if (!buttonInfo.isHovered((int)mouseX, (int)mouseY)) continue;
            if (buttonInfo.command.equals("spawn_map")) {
                class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new WebMapScreen()));
                cir.setReturnValue((Object)true);
                return;
            }
            class_310.method_1551().method_1562().method_45730(buttonInfo.command);
            cir.setReturnValue((Object)true);
            return;
        }
        int recipeButtonX = this.field_2776 + 104;
        int recipeButtonY = this.field_22790 / 2 - 22;
        if (mouseX >= (double)recipeButtonX && mouseX <= (double)(recipeButtonX + 20) && mouseY >= (double)recipeButtonY && mouseY <= (double)(recipeButtonY + 18)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/InventoryScreen;addDrawableChild(Lnet/minecraft/client/gui/Element;)Lnet/minecraft/client/gui/Element;")}, cancellable=true)
    private void cancelRecipeButtonAddition(CallbackInfo ci) {
        ci.cancel();
        this.field_2929.method_2597(this.field_22789, this.field_22790, this.field_22787, this.field_2931, (class_1729)this.field_2797);
        this.field_2776 = this.field_2929.method_2595(this.field_22789, this.field_2792);
        this.method_25429((class_364)this.field_2929);
        this.method_20085((class_364)this.field_2929);
        this.initButtons();
    }

    private boolean isCraftingSlot(class_1735 slot) {
        return slot.field_7874 >= 0 && slot.field_7874 <= 4;
    }

    private void drawEntity(int x, int y, int size, class_1657 entity) {
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_46416((float)x, (float)y, 1050.0f);
        matrixStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        matrixStack2.method_46416(0.0f, 0.0f, 1000.0f);
        matrixStack2.method_22905((float)size, (float)size, (float)size);
        float fixedBodyYaw = 10.0f;
        float fixedHeadYaw = -20.0f;
        float fixedPitch = 0.0f;
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateY((float)Math.toRadians(fixedBodyYaw));
        quaternionf.mul((Quaternionfc)quaternionf2);
        matrixStack2.method_22907(quaternionf);
        float originalBodyYaw = entity.field_6283;
        float originalYaw = entity.method_36454();
        float originalPitch = entity.method_36455();
        float originalPrevHeadYaw = entity.field_6259;
        float originalHeadYaw = entity.field_6241;
        entity.field_6283 = 180.0f + fixedBodyYaw;
        entity.method_36456(180.0f + fixedHeadYaw);
        entity.method_36457(fixedPitch);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, -1.35, -1.7, 0.0, 0.0f, 1.0f, matrixStack2, (class_4597)immediate, 0xF000F0));
        immediate.method_22993();
        entityRenderDispatcher.method_3948(true);
        entity.field_6283 = originalBodyYaw;
        entity.method_36456(originalYaw);
        entity.method_36457(originalPitch);
        entity.field_6259 = originalPrevHeadYaw;
        entity.field_6241 = originalHeadYaw;
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    static {
        BONUS_POSITIONS.put("attack", new float[]{148.0f, 82.0f, 0.7f});
        BONUS_POSITIONS.put("defend", new float[]{174.0f, 82.0f, 0.7f});
        BONUS_POSITIONS.put("escape", new float[]{199.0f, 82.0f, 0.7f});
        BONUS_POSITIONS.put("mattack", new float[]{148.0f, 94.0f, 0.7f});
        BONUS_POSITIONS.put("mdefend", new float[]{174.0f, 94.0f, 0.7f});
        BONUS_POSITIONS.put("mescape", new float[]{199.0f, 94.0f, 0.7f});
    }
}

