/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.itemsbobbing.mixin.client.crafting;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zeydie.itemsbobbing.gui.ButtonInfo;
import com.zeydie.itemsbobbing.gui.WebMapScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_479.class})
public abstract class CraftingScreenMixin
extends class_465<class_1714> {
    private static final class_2960 CUSTOM_CRAFTING_TEXTURE = new class_2960("itemsbobbing", "textures/gui/custom_craft.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final class_2960 BUTTON_MAP = new class_2960("itemsbobbing", "textures/gui/map.png");
    private static final class_2960 BUTTON_MAP_HOVER = new class_2960("itemsbobbing", "textures/gui/map_hovered.png");
    private static final class_2960 BUTTON_BACKPACK = new class_2960("itemsbobbing", "textures/gui/backpack.png");
    private static final class_2960 BUTTON_BACKPACK_HOVER = new class_2960("itemsbobbing", "textures/gui/backpack_hovered.png");
    private static final class_2960 BUTTON_RING = new class_2960("itemsbobbing", "textures/gui/ring.png");
    private static final class_2960 BUTTON_RING_HOVER = new class_2960("itemsbobbing", "textures/gui/ring_hovered.png");
    private final List<ButtonInfo> buttons = new ArrayList<ButtonInfo>();
    private int offsetX = 0;

    protected CraftingScreenMixin(class_1714 handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void initButtons(CallbackInfo ci) {
        this.buttons.clear();
        this.updateButtonPositions();
    }

    private void updateButtonPositions() {
        int bgX = (this.field_22789 - 256) / 2 + this.offsetX;
        int bgY = (this.field_22790 - 256) / 2;
        this.buttons.clear();
        this.buttons.add(new ButtonInfo(BUTTON_MAP, BUTTON_MAP_HOVER, bgX + 192, bgY + 52, "\u041a\u0430\u0440\u0442\u0430", "spawn_map"));
        this.buttons.add(new ButtonInfo(BUTTON_BACKPACK, BUTTON_BACKPACK_HOVER, bgX + 138, bgY + 52, "\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c", "player_inventory"));
        this.buttons.add(new ButtonInfo(BUTTON_RING, BUTTON_RING_HOVER, bgX + 155, bgY + 52, "\u0410\u043a\u0441\u0435\u0441\u0441\u0443\u0430\u0440\u044b", "accessory_menu"));
    }

    @Inject(method={"drawBackground"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDrawBackground(class_4587 matrices, float delta, int mouseX, int mouseY, CallbackInfo ci) {
        ci.cancel();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)CUSTOM_CRAFTING_TEXTURE);
        int x = (this.field_22789 - 256) / 2 + this.offsetX;
        int y = (this.field_22790 - 256) / 2;
        CraftingScreenMixin.method_25290((class_4587)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)256, (int)256, (int)256, (int)256);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void renderButtons(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ButtonInfo hoveredButton = null;
        for (ButtonInfo button : this.buttons) {
            if (!button.isHovered(mouseX, mouseY)) continue;
            hoveredButton = button;
            break;
        }
        for (ButtonInfo button : this.buttons) {
            try {
                boolean isHovered = button == hoveredButton;
                class_2960 texture = isHovered ? button.hoverTexture : button.texture;
                if (texture == null) continue;
                RenderSystem.setShaderTexture((int)0, (class_2960)texture);
                CraftingScreenMixin.method_25290((class_4587)matrices, (int)button.posX, (int)button.posY, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            catch (Exception exception) {}
        }
        if (hoveredButton != null) {
            this.method_25424(matrices, class_2561.method_30163((String)hoveredButton.hoverText), mouseX, mouseY);
        }
        RenderSystem.disableBlend();
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        class_465 screen = this;
        if (screen instanceof class_479) {
            class_479 craftingScreen = (class_479)screen;
            for (ButtonInfo buttonInfo : this.buttons) {
                if (!buttonInfo.isHovered((int)mouseX, (int)mouseY)) continue;
                if (craftingScreen.method_2659().method_2605()) {
                    craftingScreen.method_2659().method_2591();
                }
                if (buttonInfo.command.equals("spawn_map")) {
                    class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new WebMapScreen()));
                    cir.setReturnValue((Object)true);
                    return;
                }
                class_310.method_1551().method_1562().method_45730(buttonInfo.command);
                cir.setReturnValue((Object)true);
                return;
            }
        }
    }

    @Inject(method={"handledScreenTick"}, at={@At(value="HEAD")})
    private void updateOffset(CallbackInfo ci) {
        int newOffsetX;
        class_479 screen = (class_479)this;
        int n = newOffsetX = screen.method_2659().method_2605() ? 77 : 0;
        if (newOffsetX != this.offsetX) {
            this.offsetX = newOffsetX;
            this.updateButtonPositions();
        }
    }
}

