/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.itemsbobbing.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zeydie.itemsbobbing.gui.DynmapIconLoader;
import com.zeydie.itemsbobbing.gui.DynmapMarker;
import com.zeydie.itemsbobbing.gui.DynmapMarkersLoader;
import com.zeydie.itemsbobbing.gui.DynmapTileLoader;
import com.zeydie.itemsbobbing.gui.PlayerSkinLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.lwjgl.opengl.GL11;

public class WebMapScreen
extends class_437 {
    private final DynmapTileLoader tileLoader;
    private final DynmapIconLoader iconLoader;
    private final PlayerSkinLoader skinLoader;
    private static final class_2960 MAP_BACKGROUND = new class_2960("itemsbobbing", "textures/gui/map_background.png");
    private static final String WORLD_NAME = "ivent_east_3";
    private static final String MAP_NAME = "flat";
    private static final double PLAYER_Z_OFFSET = 0.0;
    private static final double POI_Z_OFFSET = 0.0;
    private static final double MAP_MIN_X = -3061.0;
    private static final double MAP_MIN_Z = -2651.0;
    private static final double MAP_MAX_X = 3527.0;
    private static final double MAP_MAX_Z = 2680.0;
    private double cameraWorldX = 0.0;
    private double cameraWorldZ = 0.0;
    private int zoomLevel = 1;
    private float visualZoom = 0.84f;
    private float targetVisualZoom = 0.84f;
    private static final int MIN_ZOOM_LEVEL = 0;
    private static final int MAX_ZOOM_LEVEL = 1;
    private boolean isDragging = false;
    private double dragStartWorldX = 0.0;
    private double dragStartWorldZ = 0.0;
    private double dragStartMouseX = 0.0;
    private double dragStartMouseY = 0.0;
    private final Map<String, TileData> loadedTiles = new HashMap<String, TileData>();
    private final Set<String> loadingTiles = new HashSet<String>();
    private final List<DynmapMarker> markers = new ArrayList<DynmapMarker>();
    private DynmapMarker hoveredMarker = null;
    private class_4185 closeButton;
    private static final int MAX_CONCURRENT_LOADS = 16;
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 512;
    private static final int GUI_WIDTH = 340;
    private static final int GUI_HEIGHT = 289;
    private static final int MAP_AREA_WIDTH = 331;
    private static final int MAP_AREA_HEIGHT = 281;
    private static final int TILESCALE = 0;
    private static final int MAPZOOMOUT = 2;

    public WebMapScreen() {
        super((class_2561)class_2561.method_43470((String)"Dynmap - Flores Votive RP"));
        this.tileLoader = new DynmapTileLoader();
        this.iconLoader = new DynmapIconLoader();
        this.skinLoader = new PlayerSkinLoader();
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            this.cameraWorldX = client.field_1724.method_23317();
            this.cameraWorldZ = client.field_1724.method_23321();
        } else {
            this.cameraWorldX = 233.0;
            this.cameraWorldZ = 14.5;
        }
        this.visualZoom = 0.2f;
        this.targetVisualZoom = 0.2f;
    }

    protected void method_25426() {
        super.method_25426();
        this.constrainCamera();
        int textureX = (this.field_22789 - 512) / 2;
        int textureY = (this.field_22790 - 512) / 2;
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonX = textureX + (512 - buttonWidth) / 2;
        int buttonY = textureY + 512 - 110;
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u0417\u0430\u043a\u0440\u044b\u0442\u044c"), button -> {
            this.method_25419();
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                client.field_1724.field_3944.method_45731("player_inventory");
            }
        }).method_46434(buttonX, buttonY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.closeButton);
        DynmapMarkersLoader.loadMarkersAsync(loadedMarkers -> {
            this.markers.clear();
            this.markers.addAll(loadedMarkers);
            HashSet<String> uniqueIcons = new HashSet<String>();
            for (DynmapMarker marker : loadedMarkers) {
                if (marker.getIcon() == null || marker.getIcon().isEmpty()) continue;
                uniqueIcons.add(marker.getIcon());
            }
            for (String iconName : uniqueIcons) {
                this.iconLoader.loadIconAsync(iconName, textureId -> {});
            }
        });
    }

    private LatLng minecraftToLatLng(double worldX, double worldY, double worldZ) {
        double lng = worldX;
        double lat = -worldZ;
        int baseOffset = 128;
        double scaledLat = -(lat - (double)baseOffset);
        double scaledLng = lng;
        return new LatLng(scaledLat, scaledLng);
    }

    private double[] latLngToMinecraft(LatLng latLng, double worldY) {
        double lng;
        int baseOffset = 128;
        double lat = -latLng.lat + (double)baseOffset;
        double worldX = lng = latLng.lng;
        double worldZ = -lat;
        return new double[]{worldX, worldY, worldZ};
    }

    private double[] latLngToTiles(LatLng latLng, int zoomLevel) {
        int tileSize = this.tileLoader.getTileSize();
        int scale = 1 << zoomLevel;
        double tileX = latLng.lng / (double)(tileSize * scale);
        double tileY = latLng.lat / (double)(tileSize * scale);
        return new double[]{tileX, tileY};
    }

    private LatLng tilesToLatLng(double tileX, double tileY, int zoomLevel) {
        int tileSize = this.tileLoader.getTileSize();
        int scale = 1 << zoomLevel;
        double lng = tileX * (double)(tileSize * scale);
        double lat = tileY * (double)(tileSize * scale);
        return new LatLng(lat, lng);
    }

    private double[] latLngToPixels(LatLng latLng, int zoomLevel) {
        double[] tiles = this.latLngToTiles(latLng, zoomLevel);
        int tileSize = this.tileLoader.getTileSize();
        double pixelX = tiles[0] * (double)tileSize;
        double pixelY = tiles[1] * (double)tileSize;
        return new double[]{pixelX, pixelY};
    }

    private LatLng pixelsToLatLng(double pixelX, double pixelY, int zoomLevel) {
        int tileSize = this.tileLoader.getTileSize();
        double tileX = pixelX / (double)tileSize;
        double tileY = pixelY / (double)tileSize;
        return this.tilesToLatLng(tileX, tileY, zoomLevel);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        for (TileData tile : this.loadedTiles.values()) {
            tile.tick();
        }
        WebMapScreen.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)-1065320320);
        int x = (this.field_22789 - 512) / 2;
        int y = (this.field_22790 - 512) / 2;
        int mapX = x + 90;
        int mapY = y + 115 - 5;
        this.renderMapTilesInGUI(matrices, mapX, mapY, 331, 281);
        this.renderMarkers(matrices, mapX, mapY, mouseX, mouseY);
        this.renderPlayerPosition(matrices, mapX, mapY);
        this.renderMapUI(matrices, mapX, mapY, mouseX, mouseY);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)MAP_BACKGROUND);
        WebMapScreen.method_25290((class_4587)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)512, (int)512, (int)512, (int)512);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void renderMapTilesInGUI(class_4587 matrices, int guiX, int guiY, int guiWidth, int guiHeight) {
        WebMapScreen.method_44379((int)guiX, (int)guiY, (int)(guiX + guiWidth), (int)(guiY + guiHeight));
        matrices.method_22903();
        int centerX = guiX + guiWidth / 2;
        int centerY = guiY + guiHeight / 2;
        matrices.method_46416((float)centerX, (float)centerY, 0.0f);
        matrices.method_22905(this.visualZoom, this.visualZoom, 1.0f);
        matrices.method_46416((float)(-centerX), (float)(-centerY), 0.0f);
        int tileSize = this.tileLoader.getTileSize();
        int screenCenterX = centerX;
        int screenCenterY = centerY;
        LatLng cameraLatLng = this.minecraftToLatLng(this.cameraWorldX, 64.0, this.cameraWorldZ);
        double[] cameraTiles = this.latLngToTiles(cameraLatLng, this.zoomLevel);
        double cameraTileX = cameraTiles[0];
        double cameraTileZ = cameraTiles[1];
        int tilesWide = (int)((float)guiWidth / ((float)tileSize * this.visualZoom) + 3.0f);
        int tilesHigh = (int)((float)guiHeight / ((float)tileSize * this.visualZoom) + 3.0f);
        int centerTileX = (int)Math.floor(cameraTileX);
        int centerTileZ = (int)Math.floor(cameraTileZ);
        double offsetX = (cameraTileX - (double)centerTileX) * (double)tileSize;
        double offsetZ = (cameraTileZ - (double)centerTileZ) * (double)tileSize;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int tilesRendered = 0;
        int tilesLoading = 0;
        ArrayList<int[]> tilesToLoad = new ArrayList<int[]>();
        for (int dx = -tilesWide / 2; dx <= tilesWide / 2; ++dx) {
            int dz = -tilesHigh / 2;
            while (dz <= tilesHigh / 2) {
                tilesToLoad.add(new int[]{dx, dz++});
            }
        }
        tilesToLoad.sort((a, b) -> {
            double distA = Math.sqrt(a[0] * a[0] + a[1] * a[1]);
            double distB = Math.sqrt(b[0] * b[0] + b[1] * b[1]);
            return Double.compare(distA, distB);
        });
        for (int[] tile : tilesToLoad) {
            int dx = tile[0];
            int dz = tile[1];
            int tileX = centerTileX + dx;
            int tileZ = centerTileZ + dz;
            String tileKey = String.format("%s_%s_%d_%d_%d", WORLD_NAME, MAP_NAME, this.zoomLevel, tileX, tileZ);
            int screenX = (int)((double)(screenCenterX + dx * tileSize) - offsetX);
            int screenY = (int)((double)(screenCenterY + dz * tileSize) - offsetZ);
            TileData tileData = this.loadedTiles.get(tileKey);
            if (tileData != null && tileData.isReady()) {
                try {
                    if (tileData.texture == null || tileData.id == null) {
                        WebMapScreen.method_25294((class_4587)matrices, (int)screenX, (int)screenY, (int)(screenX + tileSize), (int)(screenY + tileSize), (int)-1850217);
                        continue;
                    }
                    float alpha = tileData.getAlpha();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    RenderSystem.setShaderTexture((int)0, (class_2960)tileData.id);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                    GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
                    WebMapScreen.method_25290((class_4587)matrices, (int)screenX, (int)screenY, (float)0.0f, (float)0.0f, (int)tileSize, (int)tileSize, (int)tileSize, (int)tileSize);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ++tilesRendered;
                }
                catch (Exception e) {
                    WebMapScreen.method_25294((class_4587)matrices, (int)screenX, (int)screenY, (int)(screenX + tileSize), (int)(screenY + tileSize), (int)-1850217);
                }
                continue;
            }
            if (tileData != null && !tileData.isReady()) {
                WebMapScreen.method_25294((class_4587)matrices, (int)screenX, (int)screenY, (int)(screenX + tileSize), (int)(screenY + tileSize), (int)-1850217);
                continue;
            }
            if (!this.loadingTiles.contains(tileKey) && this.loadingTiles.size() < 16) {
                this.loadingTiles.add(tileKey);
                ++tilesLoading;
                this.tileLoader.loadTileAsync(WORLD_NAME, MAP_NAME, this.zoomLevel, tileX, tileZ, textureId -> {
                    class_1043 texture;
                    this.loadingTiles.remove(tileKey);
                    if (textureId != null && (texture = this.tileLoader.getCachedTexture(tileKey)) != null) {
                        TileData newTileData = new TileData(textureId, texture);
                        this.loadedTiles.put(tileKey, newTileData);
                    }
                });
                for (int preloadZoom = 0; preloadZoom <= 1; ++preloadZoom) {
                    String preloadKey;
                    if (preloadZoom == this.zoomLevel || this.loadedTiles.containsKey(preloadKey = String.format("%s_%s_%d_%d_%d", WORLD_NAME, MAP_NAME, preloadZoom, tileX, tileZ)) || this.loadingTiles.contains(preloadKey) || this.loadingTiles.size() >= 16) continue;
                    this.loadingTiles.add(preloadKey);
                    int finalPreloadZoom = preloadZoom;
                    this.tileLoader.loadTileAsync(WORLD_NAME, MAP_NAME, preloadZoom, tileX, tileZ, textureId -> {
                        class_1043 texture;
                        this.loadingTiles.remove(preloadKey);
                        if (textureId != null && (texture = this.tileLoader.getCachedTexture(preloadKey)) != null) {
                            TileData newTileData = new TileData(textureId, texture);
                            this.loadedTiles.put(preloadKey, newTileData);
                        }
                    });
                }
                WebMapScreen.method_25294((class_4587)matrices, (int)screenX, (int)screenY, (int)(screenX + tileSize), (int)(screenY + tileSize), (int)-1850217);
                continue;
            }
            if (this.loadingTiles.contains(tileKey)) {
                WebMapScreen.method_25294((class_4587)matrices, (int)screenX, (int)screenY, (int)(screenX + tileSize), (int)(screenY + tileSize), (int)-1850217);
                ++tilesLoading;
                continue;
            }
            WebMapScreen.method_25294((class_4587)matrices, (int)screenX, (int)screenY, (int)(screenX + tileSize), (int)(screenY + tileSize), (int)-1850217);
        }
        RenderSystem.disableBlend();
        matrices.method_22909();
        WebMapScreen.method_44380();
        if (class_310.method_1551().field_1690.field_1866) {
            String debugText = String.format("Tiles: %d rendered, %d loading, %d cached", tilesRendered, tilesLoading, this.loadedTiles.size());
            WebMapScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)debugText), (int)10, (int)50, (int)0xFFFF00);
        }
    }

    private void renderMapUI(class_4587 matrices, int mapX, int mapY, int mouseX, int mouseY) {
        String coordsText;
        if (mouseX >= mapX && mouseX <= mapX + 331 && mouseY >= mapY && mouseY <= mapY + 281) {
            double mouseOffsetPxX = (float)(mouseX - (mapX + 165)) / this.visualZoom;
            double mouseOffsetPxY = (float)(mouseY - (mapY + 140)) / this.visualZoom;
            LatLng cameraLatLng = this.minecraftToLatLng(this.cameraWorldX, 64.0, this.cameraWorldZ);
            double[] cameraPixels = this.latLngToPixels(cameraLatLng, this.zoomLevel);
            double mousePixelX = cameraPixels[0] + mouseOffsetPxX;
            double mousePixelY = cameraPixels[1] + mouseOffsetPxY;
            LatLng mouseLatLng = this.pixelsToLatLng(mousePixelX, mousePixelY, this.zoomLevel);
            double[] mouseWorld = this.latLngToMinecraft(mouseLatLng, 64.0);
            double worldX = Math.round(mouseWorld[0]);
            double worldZ = Math.round(mouseWorld[2]);
            coordsText = String.format("X:%.0f Z:%.0f", worldX, worldZ);
        } else {
            coordsText = "X: ---, Z: ---";
        }
        this.drawSmoothText(matrices, coordsText, mapX + 5, mapY + 5, 0xFFFFFF);
        String[] instructions = new String[]{"\u041b\u041a\u041c - \u0434\u0432\u0438\u0433\u0430\u0442\u044c | \u041a\u043e\u043b\u0435\u0441\u043e - \u043f\u0440\u0438\u0431\u043b\u0438\u0437\u0438\u0442\u044c/\u043e\u0442\u0434\u0430\u043b\u0438\u0442\u044c"};
        int y = mapY + 281 - 15;
        for (String instruction : instructions) {
            this.drawSmoothText(matrices, instruction, mapX + 5, y, 0xAAAAAA);
            y += 10;
        }
    }

    private void renderMarkers(class_4587 matrices, int mapX, int mapY, int mouseX, int mouseY) {
        if (this.markers.isEmpty()) {
            return;
        }
        int centerX = mapX + 165;
        int centerY = mapY + 140;
        LatLng cameraLatLng = this.minecraftToLatLng(this.cameraWorldX, 64.0, this.cameraWorldZ);
        double[] cameraPixels = this.latLngToPixels(cameraLatLng, this.zoomLevel);
        this.hoveredMarker = null;
        for (DynmapMarker marker : this.markers) {
            String cleanDesc;
            boolean useSimpleSquare;
            int labelY;
            boolean isHovered;
            double zOffset = marker.getType() == DynmapMarker.MarkerType.PLAYER ? 0.0 : 0.0;
            double markerWorldZ = marker.getZ() + zOffset;
            LatLng markerLatLng = this.minecraftToLatLng(marker.getX(), marker.getY(), markerWorldZ);
            double[] markerPixels = this.latLngToPixels(markerLatLng, this.zoomLevel);
            double pixelOffsetX = markerPixels[0] - cameraPixels[0];
            double pixelOffsetY = markerPixels[1] - cameraPixels[1];
            int markerScreenX = (int)((double)centerX + pixelOffsetX * (double)this.visualZoom);
            int markerScreenY = (int)((double)centerY + pixelOffsetY * (double)this.visualZoom);
            if (markerScreenX < mapX || markerScreenX > mapX + 331 || markerScreenY < mapY || markerScreenY > mapY + 281) continue;
            int[] realSize = this.iconLoader.getIconSize(marker.getIcon());
            int iconWidth = realSize != null ? realSize[0] : marker.getIconWidth();
            int iconHeight = realSize != null ? realSize[1] : marker.getIconHeight();
            float iconScale = this.visualZoom;
            int scaledWidth = (int)((float)iconWidth * iconScale);
            int scaledHeight = (int)((float)iconHeight * iconScale);
            int iconX = markerScreenX - scaledWidth / 2;
            int iconY = markerScreenY - scaledHeight / 2;
            boolean bl = isHovered = mouseX >= iconX && mouseX <= iconX + scaledWidth && mouseY >= iconY && mouseY <= iconY + scaledHeight;
            if (isHovered) {
                this.hoveredMarker = marker;
            }
            if (marker.getType() == DynmapMarker.MarkerType.PLAYER) {
                class_2960 skinTexture = this.skinLoader.getPlayerSkin(marker.getLabel());
                if (skinTexture != null) {
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(isHovered ? 1.0f : 0.9f));
                    RenderSystem.setShaderTexture((int)0, (class_2960)skinTexture);
                    RenderSystem.enableBlend();
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    int headSize = (int)(32.0f * this.visualZoom);
                    int headX = markerScreenX - headSize / 2;
                    int headY = markerScreenY - headSize / 2;
                    matrices.method_22903();
                    matrices.method_46416((float)headX, (float)headY, 0.0f);
                    matrices.method_22905(this.visualZoom * 2.0f, this.visualZoom * 2.0f, 1.0f);
                    WebMapScreen.method_25290((class_4587)matrices, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                    WebMapScreen.method_25290((class_4587)matrices, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                    matrices.method_22909();
                    RenderSystem.disableBlend();
                } else {
                    WebMapScreen.method_25294((class_4587)matrices, (int)(markerScreenX - 3), (int)(markerScreenY - 3), (int)(markerScreenX + 3), (int)(markerScreenY + 3), (int)(isHovered ? -256 : -16742145));
                }
                if (!isHovered) continue;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                int labelX = markerScreenX - this.field_22793.method_1727(marker.getLabel()) / 2;
                labelY = markerScreenY - 16;
                WebMapScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)marker.getLabel()), (int)labelX, (int)labelY, (int)0xFFFFFF);
                RenderSystem.disableBlend();
                continue;
            }
            if (marker.getType() != DynmapMarker.MarkerType.POI) continue;
            boolean bl2 = useSimpleSquare = this.visualZoom <= 0.15f;
            if (useSimpleSquare) {
                int squareSize = 6;
                String iconName = marker.getIcon();
                color = iconName.contains("house") || iconName.contains("home") ? (isHovered ? -22016 : -30720) : (iconName.contains("chest") || iconName.contains("bank") ? (isHovered ? -256 : -2237184) : (iconName.contains("portal") || iconName.contains("gate") ? (isHovered ? -5635841 : -7864099) : (iconName.contains("flag") || iconName.contains("claim") ? (isHovered ? -16711681 : -16720419) : (iconName.contains("shop") || iconName.contains("market") ? (isHovered ? -16711936 : -16720640) : (isHovered ? -65536 : -2293760)))));
                WebMapScreen.method_25294((class_4587)matrices, (int)(markerScreenX - squareSize / 2), (int)(markerScreenY - squareSize / 2), (int)(markerScreenX + squareSize / 2), (int)(markerScreenY + squareSize / 2), (int)color);
            } else {
                class_2960 iconTexture = this.iconLoader.getCachedIcon(marker.getIcon());
                if (iconTexture != null) {
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(isHovered ? 1.0f : 0.9f));
                    RenderSystem.setShaderTexture((int)0, (class_2960)iconTexture);
                    RenderSystem.enableBlend();
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    matrices.method_22903();
                    matrices.method_46416((float)iconX, (float)iconY, 0.0f);
                    matrices.method_22905(iconScale, iconScale, 1.0f);
                    WebMapScreen.method_25290((class_4587)matrices, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)iconWidth, (int)iconHeight, (int)iconWidth, (int)iconHeight);
                    matrices.method_22909();
                    RenderSystem.disableBlend();
                } else {
                    color = isHovered ? -256 : -16711936;
                    WebMapScreen.method_25294((class_4587)matrices, (int)(markerScreenX - 4), (int)(markerScreenY - 8), (int)(markerScreenX + 4), (int)markerScreenY, (int)color);
                    WebMapScreen.method_25294((class_4587)matrices, (int)(markerScreenX - 4), (int)(markerScreenY - 8), (int)(markerScreenX + 4), (int)(markerScreenY - 7), (int)-16777216);
                    WebMapScreen.method_25294((class_4587)matrices, (int)(markerScreenX - 4), (int)(markerScreenY - 8), (int)(markerScreenX - 3), (int)markerScreenY, (int)-16777216);
                    WebMapScreen.method_25294((class_4587)matrices, (int)(markerScreenX + 3), (int)(markerScreenY - 8), (int)(markerScreenX + 4), (int)markerScreenY, (int)-16777216);
                    WebMapScreen.method_25294((class_4587)matrices, (int)(markerScreenX - 4), (int)(markerScreenY - 1), (int)(markerScreenX + 4), (int)markerScreenY, (int)-16777216);
                    if (!this.iconLoader.isIconLoaded(marker.getIcon())) {
                        this.iconLoader.loadIconAsync(marker.getIcon(), textureId -> {});
                    }
                }
            }
            if (!isHovered) continue;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            int labelX = markerScreenX - this.field_22793.method_1727(marker.getLabel()) / 2;
            labelY = iconY - 10;
            WebMapScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)marker.getLabel()), (int)labelX, (int)labelY, (int)0xFFFFFF);
            if (!marker.getDescription().isEmpty() && !(cleanDesc = marker.getDescription().replaceAll("<[^>]*>", "").trim()).isEmpty() && cleanDesc.length() < 100) {
                matrices.method_22903();
                matrices.method_22905(0.75f, 0.75f, 1.0f);
                int descX = (int)(((float)markerScreenX - (float)this.field_22793.method_1727(cleanDesc) * 0.75f / 2.0f) / 0.75f);
                int descY = (int)((float)(labelY + 10) / 0.75f);
                WebMapScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)cleanDesc), (int)descX, (int)descY, (int)0xAAAAAA);
                matrices.method_22909();
            }
            RenderSystem.disableBlend();
        }
    }

    private void renderPlayerPosition(class_4587 matrices, int mapX, int mapY) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        double playerX = client.field_1724.method_23317();
        double playerY = client.field_1724.method_23318();
        double playerZ = client.field_1724.method_23321();
        int centerX = mapX + 165;
        int centerY = mapY + 140;
        LatLng cameraLatLng = this.minecraftToLatLng(this.cameraWorldX, 64.0, this.cameraWorldZ);
        double[] cameraPixels = this.latLngToPixels(cameraLatLng, this.zoomLevel);
        LatLng playerLatLng = this.minecraftToLatLng(playerX, playerY, playerZ);
        double[] playerPixels = this.latLngToPixels(playerLatLng, this.zoomLevel);
        double pixelOffsetX = playerPixels[0] - cameraPixels[0];
        double pixelOffsetY = playerPixels[1] - cameraPixels[1];
        int playerScreenX = (int)((double)centerX + pixelOffsetX * (double)this.visualZoom);
        int playerScreenY = (int)((double)centerY + pixelOffsetY * (double)this.visualZoom);
        if (playerScreenX < mapX || playerScreenX > mapX + 331 || playerScreenY < mapY || playerScreenY > mapY + 281) {
            return;
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        String playerName = client.field_1724.method_5477().getString();
        class_2960 skinTexture = this.skinLoader.getPlayerSkin(playerName);
        if (skinTexture == null) {
            skinTexture = client.field_1724.method_3117();
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)skinTexture);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        int playerMarkerSize = (int)(32.0f * this.visualZoom);
        int playerIconX = playerScreenX - playerMarkerSize / 2;
        int playerIconY = playerScreenY - playerMarkerSize / 2;
        matrices.method_22903();
        matrices.method_46416((float)playerIconX, (float)playerIconY, 0.0f);
        matrices.method_22905(this.visualZoom * 2.0f, this.visualZoom * 2.0f, 1.0f);
        WebMapScreen.method_25290((class_4587)matrices, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        WebMapScreen.method_25290((class_4587)matrices, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        matrices.method_22909();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        String youAreHere = "\u0412\u044b \u0437\u0434\u0435\u0441\u044c";
        int textWidth = this.field_22793.method_1727(youAreHere);
        int textX = playerScreenX - textWidth / 2;
        int textY = playerIconY - 12;
        GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        WebMapScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)youAreHere), (int)textX, (int)textY, (int)0xFFFF00);
        RenderSystem.disableBlend();
        RenderSystem.disableBlend();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int x = (this.field_22789 - 512) / 2;
            int y = (this.field_22790 - 512) / 2;
            int mapX = x + 90;
            int mapY = y + 115 - 10;
            if (mouseX >= (double)mapX && mouseX <= (double)(mapX + 331) && mouseY >= (double)mapY && mouseY <= (double)(mapY + 281)) {
                this.isDragging = true;
                double clickOffsetX = (mouseX - (double)(mapX + 165)) / (double)this.visualZoom;
                double clickOffsetY = (mouseY - (double)(mapY + 140)) / (double)this.visualZoom;
                LatLng cameraLatLng = this.minecraftToLatLng(this.cameraWorldX, 64.0, this.cameraWorldZ);
                double[] cameraPixels = this.latLngToPixels(cameraLatLng, this.zoomLevel);
                double clickPixelX = cameraPixels[0] + clickOffsetX;
                double clickPixelY = cameraPixels[1] + clickOffsetY;
                LatLng clickLatLng = this.pixelsToLatLng(clickPixelX, clickPixelY, this.zoomLevel);
                double[] clickWorld = this.latLngToMinecraft(clickLatLng, 64.0);
                this.dragStartWorldX = clickWorld[0];
                this.dragStartWorldZ = clickWorld[2];
                this.dragStartMouseX = mouseX;
                this.dragStartMouseY = mouseY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void constrainCamera() {
        double mapWorldWidth = 6588.0;
        double mapWorldHeight = 5331.0;
        LatLng minCornerLatLng = this.minecraftToLatLng(-3061.0, 64.0, -2651.0);
        LatLng maxCornerLatLng = this.minecraftToLatLng(3527.0, 64.0, 2680.0);
        double[] minCornerPixels = this.latLngToPixels(minCornerLatLng, this.zoomLevel);
        double[] maxCornerPixels = this.latLngToPixels(maxCornerLatLng, this.zoomLevel);
        double mapPixelWidth = Math.abs(maxCornerPixels[0] - minCornerPixels[0]);
        double mapPixelHeight = Math.abs(maxCornerPixels[1] - minCornerPixels[1]);
        double effectiveZoom = Math.min(this.visualZoom, this.targetVisualZoom);
        double viewPixelWidth = 331.0 / effectiveZoom;
        double viewPixelHeight = 281.0 / effectiveZoom;
        LatLng cameraLatLng = this.minecraftToLatLng(this.cameraWorldX, 64.0, this.cameraWorldZ);
        double[] cameraPixels = this.latLngToPixels(cameraLatLng, this.zoomLevel);
        double maxOffsetX = Math.max(0.0, (mapPixelWidth - viewPixelWidth) / 2.0);
        double maxOffsetY = Math.max(0.0, (mapPixelHeight - viewPixelHeight) / 2.0);
        double mapCenterPixelX = (minCornerPixels[0] + maxCornerPixels[0]) / 2.0;
        double mapCenterPixelY = (minCornerPixels[1] + maxCornerPixels[1]) / 2.0;
        double offsetX = cameraPixels[0] - mapCenterPixelX;
        double offsetY = cameraPixels[1] - mapCenterPixelY;
        offsetX = Math.max(-maxOffsetX, Math.min(offsetX, maxOffsetX));
        offsetY = Math.max(-maxOffsetY, Math.min(offsetY, maxOffsetY));
        double constrainedPixelX = mapCenterPixelX + offsetX;
        double constrainedPixelY = mapCenterPixelY + offsetY;
        LatLng constrainedLatLng = this.pixelsToLatLng(constrainedPixelX, constrainedPixelY, this.zoomLevel);
        double[] constrainedWorld = this.latLngToMinecraft(constrainedLatLng, 64.0);
        this.cameraWorldX = constrainedWorld[0];
        this.cameraWorldZ = constrainedWorld[2];
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            int x = (this.field_22789 - 512) / 2;
            int y = (this.field_22790 - 512) / 2;
            int mapX = x + 90;
            int mapY = y + 115 - 10;
            double currentOffsetX = (mouseX - (double)(mapX + 165)) / (double)this.visualZoom;
            double currentOffsetY = (mouseY - (double)(mapY + 140)) / (double)this.visualZoom;
            LatLng cameraLatLng = this.minecraftToLatLng(this.cameraWorldX, 64.0, this.cameraWorldZ);
            double[] cameraPixels = this.latLngToPixels(cameraLatLng, this.zoomLevel);
            double currentPixelX = cameraPixels[0] + currentOffsetX;
            double currentPixelY = cameraPixels[1] + currentOffsetY;
            LatLng currentLatLng = this.pixelsToLatLng(currentPixelX, currentPixelY, this.zoomLevel);
            double[] currentWorld = this.latLngToMinecraft(currentLatLng, 64.0);
            double worldDeltaX = this.dragStartWorldX - currentWorld[0];
            double worldDeltaZ = this.dragStartWorldZ - currentWorld[2];
            this.cameraWorldX += worldDeltaX;
            this.cameraWorldZ += worldDeltaZ;
            this.constrainCamera();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int x = (this.field_22789 - 512) / 2;
        int y = (this.field_22790 - 512) / 2;
        int mapX = x + 90;
        int mapY = y + 115 - 10;
        if (mouseX >= (double)mapX && mouseX <= (double)(mapX + 331) && mouseY >= (double)mapY && mouseY <= (double)(mapY + 281)) {
            float oldVisualZoom = this.visualZoom;
            this.targetVisualZoom = (float)((double)this.targetVisualZoom + amount * (double)0.15f);
            this.visualZoom = this.targetVisualZoom = Math.max(0.104f, Math.min(this.targetVisualZoom, 1.8f));
            double beforeOffsetX = (mouseX - (double)(mapX + 165)) / (double)oldVisualZoom;
            double beforeOffsetY = (mouseY - (double)(mapY + 140)) / (double)oldVisualZoom;
            LatLng cameraLatLng = this.minecraftToLatLng(this.cameraWorldX, 64.0, this.cameraWorldZ);
            double[] cameraPixels = this.latLngToPixels(cameraLatLng, this.zoomLevel);
            double beforePixelX = cameraPixels[0] + beforeOffsetX;
            double beforePixelY = cameraPixels[1] + beforeOffsetY;
            LatLng beforeLatLng = this.pixelsToLatLng(beforePixelX, beforePixelY, this.zoomLevel);
            double[] beforeWorld = this.latLngToMinecraft(beforeLatLng, 64.0);
            double beforeWorldX = beforeWorld[0];
            double beforeWorldZ = beforeWorld[2];
            int newZoomLevel = this.zoomLevel;
            if (this.targetVisualZoom > 1.2f && this.zoomLevel > 0) {
                newZoomLevel = this.zoomLevel - 1;
                this.targetVisualZoom = 0.6f;
                this.visualZoom = 0.6f;
            } else if (this.targetVisualZoom < 0.4f && this.zoomLevel < 1) {
                newZoomLevel = this.zoomLevel + 1;
                this.targetVisualZoom = 0.9f;
                this.visualZoom = 0.9f;
            }
            if (newZoomLevel != this.zoomLevel) {
                this.zoomLevel = newZoomLevel;
                this.loadingTiles.clear();
            }
            double afterOffsetX = (mouseX - (double)(mapX + 165)) / (double)this.visualZoom;
            double afterOffsetY = (mouseY - (double)(mapY + 140)) / (double)this.visualZoom;
            cameraLatLng = this.minecraftToLatLng(this.cameraWorldX, 64.0, this.cameraWorldZ);
            cameraPixels = this.latLngToPixels(cameraLatLng, this.zoomLevel);
            double afterPixelX = cameraPixels[0] + afterOffsetX;
            double afterPixelY = cameraPixels[1] + afterOffsetY;
            LatLng afterLatLng = this.pixelsToLatLng(afterPixelX, afterPixelY, this.zoomLevel);
            double[] afterWorld = this.latLngToMinecraft(afterLatLng, 64.0);
            double afterWorldX = afterWorld[0];
            double afterWorldZ = afterWorld[2];
            double correctionX = beforeWorldX - afterWorldX;
            double correctionZ = beforeWorldZ - afterWorldZ;
            this.cameraWorldX += correctionX;
            this.cameraWorldZ += correctionZ;
            this.constrainCamera();
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public void method_25432() {
        super.method_25432();
        for (TileData tile : this.loadedTiles.values()) {
            try {
                class_310.method_1551().method_1531().method_4615(tile.id);
            }
            catch (Exception exception) {}
        }
        this.loadedTiles.clear();
        this.iconLoader.clearCache();
        this.skinLoader.clearCache();
    }

    public boolean method_25421() {
        return false;
    }

    private void drawSmoothText(class_4587 matrices, String text, int x, int y, int color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        WebMapScreen.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)class_2561.method_43470((String)text), (int)x, (int)y, (int)color);
        RenderSystem.disableBlend();
    }

    private static class LatLng {
        final double lat;
        final double lng;

        LatLng(double lat, double lng) {
            this.lat = lat;
            this.lng = lng;
        }
    }

    private static class TileData {
        final class_2960 id;
        final class_1043 texture;
        int framesUntilReady = 5;
        float alpha = 0.0f;

        TileData(class_2960 id, class_1043 texture) {
            this.id = id;
            this.texture = texture;
        }

        boolean isReady() {
            return this.framesUntilReady <= 0;
        }

        void tick() {
            if (this.framesUntilReady > 0) {
                --this.framesUntilReady;
            }
            if (this.isReady() && this.alpha < 1.0f) {
                this.alpha = Math.min(1.0f, this.alpha + 0.1f);
            }
        }

        float getAlpha() {
            return this.isReady() ? this.alpha : 0.0f;
        }
    }
}

