/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.itemsbobbing.gui;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class PlayerSkinLoader {
    private static final String SKIN_BASE_URL = "https://skins.votive-rp.com/SKIN/STORAGE/";
    private final Map<String, class_2960> cachedSkins = new HashMap<String, class_2960>();
    private final Map<String, Boolean> loadingSkins = new HashMap<String, Boolean>();

    public class_2960 getPlayerSkin(String playerName) {
        if (playerName == null || playerName.isEmpty()) {
            return null;
        }
        if (this.cachedSkins.containsKey(playerName)) {
            return this.cachedSkins.get(playerName);
        }
        if (this.loadingSkins.getOrDefault(playerName, false).booleanValue()) {
            return null;
        }
        this.loadingSkins.put(playerName, true);
        this.loadSkinAsync(playerName);
        return null;
    }

    private void loadSkinAsync(String playerName) {
        new Thread(() -> {
            try {
                String skinUrl = SKIN_BASE_URL + playerName;
                URL url = new URL(skinUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.setRequestProperty("User-Agent", "Minecraft-DynmapViewer/1.0");
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    this.useFallbackSkin(playerName);
                    return;
                }
                InputStream inputStream = connection.getInputStream();
                class_1011 skinImage = class_1011.method_4309((InputStream)inputStream);
                inputStream.close();
                class_2960 skinId = new class_2960("itemsbobbing", "skins/" + playerName.toLowerCase());
                class_310.method_1551().execute(() -> {
                    class_1043 texture = new class_1043(skinImage);
                    class_310.method_1551().method_1531().method_4616(skinId, (class_1044)texture);
                    this.cachedSkins.put(playerName, skinId);
                    this.loadingSkins.remove(playerName);
                });
            }
            catch (Exception e) {
                this.useFallbackSkin(playerName);
            }
        }, "PlayerSkinLoader-" + playerName).start();
    }

    private void useFallbackSkin(String playerName) {
        class_310.method_1551().execute(() -> {
            class_2960 defaultSkin = new class_2960("textures/entity/player/wide/steve.png");
            this.cachedSkins.put(playerName, defaultSkin);
            this.loadingSkins.remove(playerName);
        });
    }

    public void clearCache() {
        class_310 client = class_310.method_1551();
        for (class_2960 skinId : this.cachedSkins.values()) {
            try {
                if (skinId.method_12836().equals("minecraft")) continue;
                client.method_1531().method_4615(skinId);
            }
            catch (Exception exception) {}
        }
        this.cachedSkins.clear();
        this.loadingSkins.clear();
    }
}

