/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.itemsbobbing.gui;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class DynmapTileLoader {
    private static final String DYNMAP_BASE_URL = "https://flores.votive-rp.com/";
    private static final int TILE_SIZE = 128;
    private final Map<String, class_1043> tileTextureCache = new HashMap<String, class_1043>();
    private final Map<String, class_2960> tileIdCache = new HashMap<String, class_2960>();

    public void loadTileAsync(String world, String mapName, int zoom, int x, int z, TileCallback callback) {
        String tileKey = String.format("%s_%s_%d_%d_%d", world, mapName, zoom, x, z);
        if (this.tileIdCache.containsKey(tileKey)) {
            callback.onTileLoaded(this.tileIdCache.get(tileKey));
            return;
        }
        new Thread(() -> {
            try {
                String tileUrl = this.buildTileUrl(world, mapName, zoom, x, z);
                URL url = new URL(tileUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                connection.setRequestProperty("User-Agent", "Minecraft-DynmapViewer/1.0");
                connection.setRequestProperty("Accept", "image/png");
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    callback.onTileLoaded(null);
                    return;
                }
                InputStream inputStream = connection.getInputStream();
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                inputStream.close();
                if (bufferedImage == null) {
                    callback.onTileLoaded(null);
                    return;
                }
                class_1011 nativeImage = this.convertToNativeImage(bufferedImage);
                class_310.method_1551().execute(() -> {
                    try {
                        class_1043 texture = new class_1043(nativeImage);
                        class_2960 textureId = class_310.method_1551().method_1531().method_4617("dynmap_tile_" + tileKey, texture);
                        this.tileTextureCache.put(tileKey, texture);
                        this.tileIdCache.put(tileKey, textureId);
                        callback.onTileLoaded(textureId);
                    }
                    catch (Exception e) {
                        callback.onTileLoaded(null);
                    }
                });
            }
            catch (Exception e) {
                callback.onTileLoaded(null);
            }
        }, "DynmapTileLoader-" + tileKey).start();
    }

    private class_1011 convertToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        class_1011 nativeImage = new class_1011(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = bufferedImage.getRGB(x, y);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                nativeImage.method_4305(x, y, abgr);
            }
        }
        return nativeImage;
    }

    private String buildTileUrl(String world, String mapName, int zoomoutlevel, int tileX, int tileZ) {
        int scale = 1 << zoomoutlevel;
        int x = scale * tileX;
        int z = scale * tileZ;
        int y = -z;
        int scaledx = x >> 5;
        int scaledy = y >> 5;
        Object zoomPrefix = "";
        if (zoomoutlevel > 0) {
            zoomPrefix = "z".repeat(zoomoutlevel) + "_";
        }
        String folder = String.format("%d_%d", scaledx, scaledy);
        String file = String.format("%s%d_%d.png", zoomPrefix, x, y);
        String url = String.format("%stiles/%s/%s/%s/%s", DYNMAP_BASE_URL, world, mapName, folder, file);
        return url;
    }

    public void clearCache() {
        class_310.method_1551().execute(() -> {
            for (class_2960 id : this.tileIdCache.values()) {
                class_310.method_1551().method_1531().method_4615(id);
            }
            this.tileTextureCache.clear();
            this.tileIdCache.clear();
        });
    }

    public int getTileSize() {
        return 128;
    }

    public class_1043 getCachedTexture(String tileKey) {
        return this.tileTextureCache.get(tileKey);
    }

    public class_2960 getCachedIdentifier(String tileKey) {
        return this.tileIdCache.get(tileKey);
    }

    public static interface TileCallback {
        public void onTileLoaded(class_2960 var1);
    }
}

