/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.itemsbobbing.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.zeydie.itemsbobbing.gui.DynmapMarker;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class DynmapMarkersLoader {
    private static final String DYNMAP_BASE_URL = "https://flores.votive-rp.com/";
    private static final String WORLD_NAME = "ivent_east_3";

    public static List<DynmapMarker> loadMarkers() {
        ArrayList<DynmapMarker> markers = new ArrayList<DynmapMarker>();
        try {
            String apiUrl = "https://flores.votive-rp.com/up/world/ivent_east_3/";
            URL url = new URL(apiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setRequestProperty("User-Agent", "Minecraft-DynmapViewer/1.0");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return markers;
            }
            Scanner scanner = new Scanner(connection.getInputStream(), "UTF-8");
            String jsonString = scanner.useDelimiter("\\A").next();
            scanner.close();
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            if (json.has("players")) {
                JsonArray players = json.getAsJsonArray("players");
                for (JsonElement playerElement : players) {
                    String world;
                    JsonObject player = playerElement.getAsJsonObject();
                    String name = player.get("name").getAsString();
                    String account = player.has("account") ? player.get("account").getAsString() : name;
                    double x = player.get("x").getAsDouble();
                    double y = player.get("y").getAsDouble();
                    double z = player.get("z").getAsDouble();
                    if (player.has("world") && ((world = player.get("world").getAsString()).contains("hidden") || world.contains("bogus")) || x == 0.0 && y == 64.0 && z == 0.0) continue;
                    DynmapMarker marker = new DynmapMarker(DynmapMarker.MarkerType.PLAYER, account, name, x, y, z, "player", "\u0418\u0433\u0440\u043e\u043a: " + name);
                    markers.add(marker);
                }
            }
            DynmapMarkersLoader.loadStaticMarkers(markers);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return markers;
    }

    private static void loadStaticMarkers(List<DynmapMarker> markers) {
        try {
            String markersUrl = "https://flores.votive-rp.com/tiles/_markers_/marker_ivent_east_3.json";
            URL url = new URL(markersUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return;
            }
            Scanner scanner = new Scanner(connection.getInputStream(), "UTF-8");
            String jsonString = scanner.useDelimiter("\\A").next();
            scanner.close();
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            if (!json.has("sets")) {
                return;
            }
            JsonObject sets = json.getAsJsonObject("sets");
            for (String setId : sets.keySet()) {
                JsonObject set = sets.getAsJsonObject(setId);
                if (set.has("hide") && set.get("hide").getAsBoolean() || !set.has("markers")) continue;
                JsonObject setMarkers = set.getAsJsonObject("markers");
                for (String markerId : setMarkers.keySet()) {
                    JsonObject markerObj = setMarkers.getAsJsonObject(markerId);
                    if (!markerObj.has("x") || !markerObj.has("z")) continue;
                    double x = markerObj.get("x").getAsDouble();
                    double y = markerObj.has("y") ? markerObj.get("y").getAsDouble() : 64.0;
                    double z = markerObj.get("z").getAsDouble();
                    String label = markerObj.has("label") ? markerObj.get("label").getAsString() : markerId;
                    String desc = markerObj.has("desc") ? markerObj.get("desc").getAsString() : "";
                    String icon = markerObj.has("icon") ? markerObj.get("icon").getAsString() : "default";
                    int iconWidth = 16;
                    int iconHeight = 16;
                    if (markerObj.has("dim")) {
                        try {
                            String dim = markerObj.get("dim").getAsString();
                            String[] parts = dim.split("x");
                            if (parts.length == 2) {
                                iconWidth = Integer.parseInt(parts[0]);
                                iconHeight = Integer.parseInt(parts[1]);
                            }
                        }
                        catch (Exception dim) {
                            // empty catch block
                        }
                    }
                    DynmapMarker marker = new DynmapMarker(DynmapMarker.MarkerType.POI, markerId, label, x, y, z, icon, desc, iconWidth, iconHeight);
                    markers.add(marker);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadMarkersAsync(MarkerCallback callback) {
        new Thread(() -> {
            List<DynmapMarker> markers = DynmapMarkersLoader.loadMarkers();
            callback.onMarkersLoaded(markers);
        }, "DynmapMarkersLoader").start();
    }

    public static interface MarkerCallback {
        public void onMarkersLoaded(List<DynmapMarker> var1);
    }
}

