/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.itemsbobbing.gui;

public class DynmapMarker {
    private final MarkerType type;
    private final String id;
    private final String label;
    private final double x;
    private final double y;
    private final double z;
    private final String icon;
    private final String description;
    private final int iconWidth;
    private final int iconHeight;

    public DynmapMarker(MarkerType type, String id, String label, double x, double y, double z, String icon, String description) {
        this(type, id, label, x, y, z, icon, description, 16, 16);
    }

    public DynmapMarker(MarkerType type, String id, String label, double x, double y, double z, String icon, String description, int iconWidth, int iconHeight) {
        this.type = type;
        this.id = id;
        this.label = label;
        this.x = x;
        this.y = y;
        this.z = z;
        this.icon = icon;
        this.description = description;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
    }

    public MarkerType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public boolean isHovered(int screenX, int screenY, int markerScreenX, int markerScreenY, int markerSize) {
        return screenX >= markerScreenX - markerSize / 2 && screenX <= markerScreenX + markerSize / 2 && screenY >= markerScreenY - markerSize && screenY <= markerScreenY;
    }

    public String toString() {
        return String.format("%s[%s] at (%.1f, %.1f, %.1f)", new Object[]{this.type, this.label, this.x, this.y, this.z});
    }

    public static enum MarkerType {
        PLAYER,
        POI,
        AREA,
        LINE;

    }
}

