/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.itemsbobbing.gui;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class DynmapIconLoader {
    private static final String DYNMAP_BASE_URL = "https://flores.votive-rp.com/";
    private final Map<String, class_1043> iconTextureCache = new HashMap<String, class_1043>();
    private final Map<String, class_2960> iconIdCache = new HashMap<String, class_2960>();
    private final Map<String, Integer> iconLoadingState = new HashMap<String, Integer>();
    private final Map<String, int[]> iconSizeCache = new HashMap<String, int[]>();

    public void loadIconAsync(String iconName, IconCallback callback) {
        if (this.iconIdCache.containsKey(iconName)) {
            callback.onIconLoaded(this.iconIdCache.get(iconName));
            return;
        }
        Integer state = this.iconLoadingState.get(iconName);
        if (state != null && state == 1) {
            callback.onIconLoaded(null);
            return;
        }
        if (state != null && state == -1) {
            callback.onIconLoaded(null);
            return;
        }
        this.iconLoadingState.put(iconName, 1);
        new Thread(() -> {
            try {
                String[] possiblePaths = new String[]{"https://flores.votive-rp.com/tiles/_markers_/" + iconName + ".png", "https://flores.votive-rp.com/tiles/markers/" + iconName + ".png", "https://flores.votive-rp.com/images/markers/" + iconName + ".png", "https://flores.votive-rp.com/markers/" + iconName + ".png"};
                BufferedImage bufferedImage = null;
                String successfulUrl = null;
                for (String iconUrl : possiblePaths) {
                    try {
                        URL url = new URL(iconUrl);
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("GET");
                        connection.setConnectTimeout(15000);
                        connection.setReadTimeout(15000);
                        connection.setRequestProperty("User-Agent", "Minecraft-DynmapViewer/1.0");
                        connection.setRequestProperty("Accept", "image/png");
                        int responseCode = connection.getResponseCode();
                        if (responseCode != 200) continue;
                        InputStream inputStream = connection.getInputStream();
                        bufferedImage = ImageIO.read(inputStream);
                        inputStream.close();
                        if (bufferedImage == null) continue;
                        successfulUrl = iconUrl;
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (bufferedImage == null) {
                    this.iconLoadingState.put(iconName, -1);
                    callback.onIconLoaded(null);
                    return;
                }
                int realWidth = bufferedImage.getWidth();
                int realHeight = bufferedImage.getHeight();
                class_1011 nativeImage = this.convertToNativeImage(bufferedImage);
                class_310.method_1551().execute(() -> {
                    try {
                        class_1043 texture = new class_1043(nativeImage);
                        class_2960 textureId = class_310.method_1551().method_1531().method_4617("dynmap_icon_" + iconName, texture);
                        this.iconTextureCache.put(iconName, texture);
                        this.iconIdCache.put(iconName, textureId);
                        this.iconSizeCache.put(iconName, new int[]{realWidth, realHeight});
                        this.iconLoadingState.put(iconName, 2);
                        callback.onIconLoaded(textureId);
                    }
                    catch (Exception e) {
                        this.iconLoadingState.put(iconName, -1);
                        callback.onIconLoaded(null);
                    }
                });
            }
            catch (Exception e) {
                this.iconLoadingState.put(iconName, -1);
                callback.onIconLoaded(null);
            }
        }, "DynmapIconLoader-" + iconName).start();
    }

    private class_1011 convertToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        class_1011 nativeImage = new class_1011(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = bufferedImage.getRGB(x, y);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int abgr = a << 24 | b << 16 | g << 8 | r;
                nativeImage.method_4305(x, y, abgr);
            }
        }
        return nativeImage;
    }

    public class_2960 getCachedIcon(String iconName) {
        return this.iconIdCache.get(iconName);
    }

    public boolean isIconLoaded(String iconName) {
        Integer state = this.iconLoadingState.get(iconName);
        return state != null && state == 2;
    }

    public int[] getIconSize(String iconName) {
        return this.iconSizeCache.get(iconName);
    }

    public void clearCache() {
        class_310.method_1551().execute(() -> {
            for (class_2960 id : this.iconIdCache.values()) {
                class_310.method_1551().method_1531().method_4615(id);
            }
            this.iconTextureCache.clear();
            this.iconIdCache.clear();
            this.iconLoadingState.clear();
            this.iconSizeCache.clear();
        });
    }

    public static interface IconCallback {
        public void onIconLoaded(class_2960 var1);
    }
}

