/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.itemsbobbing.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zeydie.itemsbobbing.gui.MenuTextHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CustomInventoryScreen
extends class_437 {
    private static final class_2960 BACKGROUND_TEXTURE = new class_2960("itemsbobbing", "textures/gui/characterr.png");
    private static final class_2960 SCROLLBAR_BG = new class_2960("itemsbobbing", "textures/gui/scrollbar_background.png");
    private static final class_2960 SCROLLBAR_HANDLE = new class_2960("itemsbobbing", "textures/gui/scrollbar_handle_normal.png");
    private static final class_2960 SCROLLING_IMAGE = new class_2960("itemsbobbing", "textures/gui/scrolling_image.png");
    private static final class_2960 LEFT_BUTTON_TEXTURE = new class_2960("itemsbobbing", "textures/gui/left_button.png");
    private static final class_2960 LEFT_BUTTON_HOVER_TEXTURE = new class_2960("itemsbobbing", "textures/gui/left_button_hovered.png");
    private static final class_2960 LEFT_BUTTON_SKILLS_TEXTURE = new class_2960("itemsbobbing", "textures/gui/left_button_skills.png");
    private static final class_2960 LEFT_BUTTON_SKILLS_HOVER_TEXTURE = new class_2960("itemsbobbing", "textures/gui/left_button_skills_hovered.png");
    private static final class_2960 LEFT_BUTTON_ROST_TEXTURE = new class_2960("itemsbobbing", "textures/gui/left_button_rost.png");
    private static final class_2960 LEFT_BUTTON_ROST_HOVER_TEXTURE = new class_2960("itemsbobbing", "textures/gui/left_button_rost_hovered.png");
    private static final class_2960 CHANGE_DISC_TEXTURE = new class_2960("itemsbobbing", "textures/gui/change_disc.png");
    private static final class_2960 CHANGE_DISC_HOVER_TEXTURE = new class_2960("itemsbobbing", "textures/gui/change_disc_hovered.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int RIGHT_PANEL_WIDTH = 125;
    private static final int RIGHT_PANEL_HEIGHT = 125;
    private static final int RIGHT_PANEL_OFFSET_X = 3;
    private static final int RIGHT_PANEL_OFFSET_Y = 48;
    private static final int SCROLLBAR_BG_WIDTH = 4;
    private static final int SCROLLBAR_BG_HEIGHT = 110;
    private static final int HANDLE_WIDTH = 16;
    private static final int HANDLE_HEIGHT = 16;
    private static final int SCROLLBAR_OFFSET_X = -40;
    private static final int SCROLLBAR_OFFSET_Y = 10;
    private static final int SCROLLBAR_MARGIN = 32;
    private static final int HANDLE_OFFSET_X = -6;
    private static final int IMAGE_OFFSET_X = 5;
    private static final int IMAGE_OFFSET_Y = 5;
    private static final float TEXT_SCALE = 0.705f;
    private static final int TEXT_LINE_SPACING = 2;
    private static final int BLOCK_SPACING = 10;
    private static final int HEADING_COLOR = -11322582;
    private static final int BODY_TEXT_COLOR = -14872047;
    private static final int NAME_BLOCK_X = 19;
    private static final int GENDER_BLOCK_X = 19;
    private static final int DESCRIPTION_BLOCK_X = 19;
    private static final int RUMORS_BLOCK_X = 19;
    private static final int NAME_BLOCK_Y = 8;
    private static final int GENDER_BLOCK_Y = 32;
    private static final int DESCRIPTION_BLOCK_Y = 58;
    private static final int RUMORS_BLOCK_Y = 163;
    private static final String NAME_HEADING = "\u0418\u043c\u044f \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0430:";
    private static final String GENDER_HEADING = "\u041f\u043e\u043b \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u0436\u0430:";
    private static final String DESCRIPTION_HEADING = "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:";
    private static final String RUMORS_HEADING = "\u0421\u043b\u0443\u0445\u0438:";
    private static final int LEFT_BUTTON_WIDTH = 53;
    private static final int LEFT_BUTTON_HEIGHT = 14;
    private static final int CHANGE_DISC_BUTTON_WIDTH = 10;
    private static final int CHANGE_DISC_BUTTON_HEIGHT = 10;
    private static final int BG_TEX_WIDTH = 4;
    private static final int BG_TEX_HEIGHT = 110;
    private static final int HANDLE_TEX_HEIGHT = 16;
    private static final int SCROLLING_IMAGE_WIDTH = 120;
    private static final int SCROLLING_IMAGE_HEIGHT = 256;
    private static final int CHARS_PER_LINE = 15;
    private static final int BUTTON_NAME_OFFSET_X = 22;
    private static final int BUTTON_NAME_OFFSET_Y = 0;
    private static final int BUTTON_GENDER_OFFSET_X = 22;
    private static final int BUTTON_GENDER_OFFSET_Y = 0;
    private static final int BUTTON_DESCRIPTION_OFFSET_X = 22;
    private static final int BUTTON_DESCRIPTION_OFFSET_Y = -4;
    private static final int BUTTON_RUMORS_OFFSET_X = 22;
    private static final int BUTTON_RUMORS_OFFSET_Y = -2;
    private float scrollAmount = 0.0f;
    private boolean scrolling = false;
    private int totalContentHeight = 0;
    private final List<String> rightTextLines = new ArrayList<String>();
    private final String title;
    private float nameButtonX;
    private float nameButtonY;
    private float genderButtonX;
    private float genderButtonY;
    private float descriptionButtonX;
    private float descriptionButtonY;
    private float rumorsButtonX;
    private float rumorsButtonY;

    public CustomInventoryScreen(String title) {
        super((class_2561)class_2561.method_43470((String)title));
        this.title = title;
        for (int i = 1; i <= 50; ++i) {
            this.rightTextLines.add("\u041a\u0432\u0435\u0441\u0442 " + i + ": \u0421\u043f\u0430\u0441\u0438 VotiveRP \u043e\u0442 \u0434\u0440\u0430\u043a\u043e\u043d\u0430...");
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.totalContentHeight = 261;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        CustomInventoryScreen.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)-1065320320);
        this.renderBackgroundTexture(matrices);
        int menuX = (this.field_22789 - 256) / 2;
        int menuY = (this.field_22790 - 256) / 2;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            int playerX = menuX + 34;
            int playerY = menuY + 75;
            int playerSize = 30;
            this.drawEntity(playerX, playerY, playerSize, (class_1657)player);
        }
        int rightPanelWidth = 125;
        int rightPanelX = menuX + 256 - rightPanelWidth - 4 - 32 + 3;
        int rightPanelY = menuY + 10 + 48;
        int panelHeight = 125;
        this.drawRightPanel(matrices, rightPanelX, rightPanelY, rightPanelWidth, panelHeight, mouseX, mouseY);
        if (this.totalContentHeight > panelHeight) {
            this.drawScrollbar(matrices, rightPanelX + rightPanelWidth + 32, rightPanelY, panelHeight, mouseX, mouseY);
        }
        this.renderLeftButtonRost(matrices, mouseX, mouseY);
        this.renderLeftButton(matrices, mouseX, mouseY);
        this.renderLeftButtonSkills(matrices, mouseX, mouseY);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void renderBackgroundTexture(class_4587 matrices) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        int x = (this.field_22789 - 256) / 2;
        int y = (this.field_22790 - 256) / 2;
        CustomInventoryScreen.method_25290((class_4587)matrices, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)256, (int)256, (int)256, (int)256);
    }

    private void drawRightPanel(class_4587 matrices, int x, int y, int width, int height, int mouseX, int mouseY) {
        CustomInventoryScreen.method_44379((int)x, (int)y, (int)(x + width), (int)(y + height));
        int contentY = y - (int)this.scrollAmount;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)SCROLLING_IMAGE);
        int imageX = x + 5;
        int imageY = contentY + 5;
        CustomInventoryScreen.method_25290((class_4587)matrices, (int)imageX, (int)imageY, (float)0.0f, (float)0.0f, (int)120, (int)256, (int)120, (int)256);
        matrices.method_22903();
        matrices.method_22905(0.705f, 0.705f, 2.0f);
        int scaledX = (int)((float)x / 0.705f);
        int scaledContentY = (int)((float)contentY / 0.705f);
        int maxWidth = this.calculateMaxWidth(15);
        int currentY = scaledContentY + 11;
        currentY = this.renderTextBlock(matrices, NAME_HEADING, MenuTextHolder.getName(), scaledX + 19, currentY, maxWidth);
        int genderY = scaledContentY + 45;
        currentY = this.renderTextBlock(matrices, GENDER_HEADING, MenuTextHolder.getGender(), scaledX + 19, genderY, maxWidth);
        int descriptionY = scaledContentY + 82;
        currentY = this.renderTextBlock(matrices, DESCRIPTION_HEADING, MenuTextHolder.getDescription(), scaledX + 19, descriptionY, maxWidth);
        int rumorsY = scaledContentY + 231;
        currentY = this.renderTextBlock(matrices, RUMORS_HEADING, MenuTextHolder.getRumors(), scaledX + 19, rumorsY, maxWidth);
        matrices.method_22909();
        this.nameButtonX = x + width - 10 - 22;
        this.nameButtonY = (float)(y + 8) - this.scrollAmount + 0.0f;
        this.genderButtonX = x + width - 10 - 22;
        this.genderButtonY = (float)(y + 32) - this.scrollAmount + 0.0f;
        this.descriptionButtonX = x + width - 10 - 22;
        this.descriptionButtonY = (float)(y + 58) - this.scrollAmount + -4.0f;
        this.rumorsButtonX = x + width - 10 - 22;
        this.rumorsButtonY = (float)(y + 163) - this.scrollAmount + -2.0f;
        if (this.isButtonVisible(this.nameButtonY, y, height)) {
            this.renderButton(matrices, this.nameButtonX, this.nameButtonY, mouseX, mouseY);
        }
        if (this.isButtonVisible(this.genderButtonY, y, height)) {
            this.renderButton(matrices, this.genderButtonX, this.genderButtonY, mouseX, mouseY);
        }
        if (this.isButtonVisible(this.descriptionButtonY, y, height)) {
            this.renderButton(matrices, this.descriptionButtonX, this.descriptionButtonY, mouseX, mouseY);
        }
        if (this.isButtonVisible(this.rumorsButtonY, y, height)) {
            this.renderButton(matrices, this.rumorsButtonX, this.rumorsButtonY, mouseX, mouseY);
        }
        CustomInventoryScreen.method_44380();
    }

    private boolean isButtonVisible(float buttonY, int panelY, int panelHeight) {
        return buttonY >= (float)panelY && buttonY <= (float)(panelY + panelHeight - 10);
    }

    private void renderButton(class_4587 matrices, float x, float y, int mouseX, int mouseY) {
        boolean isHovered = (float)mouseX >= x && (float)mouseX <= x + 10.0f && (float)mouseY >= y && (float)mouseY <= y + 10.0f;
        RenderSystem.setShaderTexture((int)0, (class_2960)(isHovered ? CHANGE_DISC_HOVER_TEXTURE : CHANGE_DISC_TEXTURE));
        CustomInventoryScreen.method_25290((class_4587)matrices, (int)((int)x), (int)((int)y), (float)0.0f, (float)0.0f, (int)10, (int)10, (int)10, (int)10);
    }

    private int calculateMaxWidth(int charsPerLine) {
        int CHAR_WIDTH = 6;
        return (int)((float)charsPerLine * 8.510638f);
    }

    private List<String> wrapTextWithCharacterBreak(String text, int maxWidth, class_2583 style) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        StringBuilder currentWord = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (c == ' ') {
                String wordWithStyle = currentWord.toString();
                class_5250 lineText = class_2561.method_43470((String)(currentLine.toString() + wordWithStyle)).method_10862(style);
                if (this.field_22793.method_27525((class_5348)lineText) > maxWidth) {
                    lines.add(currentLine.toString().trim());
                    currentLine = new StringBuilder(wordWithStyle + " ");
                } else {
                    currentLine.append(wordWithStyle).append(" ");
                }
                currentWord = new StringBuilder();
                continue;
            }
            currentWord.append(c);
            class_5250 wordText = class_2561.method_43470((String)currentWord.toString()).method_10862(style);
            if (this.field_22793.method_27525((class_5348)wordText) <= maxWidth) continue;
            while (this.field_22793.method_27525((class_5348)wordText) > maxWidth) {
                String part = currentWord.substring(0, currentWord.length() - 1);
                wordText = class_2561.method_43470((String)part).method_10862(style);
                while (this.field_22793.method_27525((class_5348)wordText) > maxWidth) {
                    part = part.substring(0, part.length() - 1);
                    wordText = class_2561.method_43470((String)part).method_10862(style);
                }
                lines.add(part);
                currentWord = new StringBuilder(currentWord.substring(part.length()));
                wordText = class_2561.method_43470((String)currentWord.toString()).method_10862(style);
            }
        }
        if (currentWord.length() > 0) {
            String wordWithStyle = currentWord.toString();
            class_5250 lineText = class_2561.method_43470((String)(currentLine.toString() + wordWithStyle)).method_10862(style);
            if (this.field_22793.method_27525((class_5348)lineText) > maxWidth) {
                lines.add(currentLine.toString().trim());
                lines.add(wordWithStyle);
            } else {
                currentLine.append(wordWithStyle);
                lines.add(currentLine.toString().trim());
            }
        } else if (currentLine.length() > 0) {
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    private int renderTextBlock(class_4587 matrices, String heading, String body, int x, int y, int maxWidth) {
        class_2583 headingStyle = class_2583.field_24360.method_10982(Boolean.valueOf(true));
        List<String> headingLines = this.wrapTextWithCharacterBreak(heading, maxWidth, headingStyle);
        for (String line : headingLines) {
            class_5250 styledText = class_2561.method_43470((String)line).method_10862(headingStyle);
            this.field_22793.method_30883(matrices, (class_2561)styledText, (float)x, (float)y, -11322582);
            Objects.requireNonNull(this.field_22793);
            y += 9 + 2;
        }
        List<String> bodyLines = this.wrapTextWithCharacterBreak(body, maxWidth, class_2583.field_24360);
        for (String line : bodyLines) {
            this.field_22793.method_1729(matrices, line, (float)x, (float)y, -14872047);
            Objects.requireNonNull(this.field_22793);
            y += 9 + 2;
        }
        return y + 10;
    }

    private void drawScrollbar(class_4587 matrices, int x, int y, int height, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)SCROLLBAR_BG);
        CustomInventoryScreen.method_25290((class_4587)matrices, (int)(x + -40), (int)(y + 10), (float)0.0f, (float)0.0f, (int)4, (int)110, (int)4, (int)110);
        float maxScroll = this.totalContentHeight - height;
        float scrollRatio = this.scrollAmount / maxScroll;
        int handleY = y + (int)(scrollRatio * 94.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)SCROLLBAR_HANDLE);
        CustomInventoryScreen.method_25290((class_4587)matrices, (int)(x + -40 + -6), (int)(handleY + 10), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        RenderSystem.disableBlend();
    }

    private void renderLeftButtonRost(class_4587 matrices, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int leftButtonRostX = (this.field_22789 - 256) / 2 + 47;
        int leftButtonRostY = (this.field_22790 - 256) / 2 + 120 + 14;
        boolean hovered = mouseX >= leftButtonRostX && mouseX <= leftButtonRostX + 53 && mouseY >= leftButtonRostY && mouseY <= leftButtonRostY + 14;
        RenderSystem.setShaderTexture((int)0, (class_2960)(hovered ? LEFT_BUTTON_ROST_HOVER_TEXTURE : LEFT_BUTTON_ROST_TEXTURE));
        CustomInventoryScreen.method_25290((class_4587)matrices, (int)leftButtonRostX, (int)leftButtonRostY, (float)0.0f, (float)0.0f, (int)53, (int)14, (int)53, (int)14);
        RenderSystem.disableBlend();
    }

    private void renderLeftButton(class_4587 matrices, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int leftButtonX = (this.field_22789 - 256) / 2 + 47;
        int leftButtonY = (this.field_22790 - 256) / 2 + 166;
        boolean hovered = mouseX >= leftButtonX && mouseX <= leftButtonX + 53 && mouseY >= leftButtonY && mouseY <= leftButtonY + 14;
        RenderSystem.setShaderTexture((int)0, (class_2960)(hovered ? LEFT_BUTTON_HOVER_TEXTURE : LEFT_BUTTON_TEXTURE));
        CustomInventoryScreen.method_25290((class_4587)matrices, (int)leftButtonX, (int)leftButtonY, (float)0.0f, (float)0.0f, (int)53, (int)14, (int)53, (int)14);
        RenderSystem.disableBlend();
    }

    private void renderLeftButtonSkills(class_4587 matrices, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int leftButtonSkillsX = (this.field_22789 - 256) / 2 + 47;
        int leftButtonSkillsY = (this.field_22790 - 256) / 2 + 136 + 14;
        boolean hovered = mouseX >= leftButtonSkillsX && mouseX <= leftButtonSkillsX + 53 && mouseY >= leftButtonSkillsY && mouseY <= leftButtonSkillsY + 14;
        RenderSystem.setShaderTexture((int)0, (class_2960)(hovered ? LEFT_BUTTON_SKILLS_HOVER_TEXTURE : LEFT_BUTTON_SKILLS_TEXTURE));
        CustomInventoryScreen.method_25290((class_4587)matrices, (int)leftButtonSkillsX, (int)leftButtonSkillsY, (float)0.0f, (float)0.0f, (int)53, (int)14, (int)53, (int)14);
        RenderSystem.disableBlend();
    }

    private void closeMenuAndInventory() {
        this.method_25419();
        class_310.method_1551().method_1507(null);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int menuX = (this.field_22789 - 256) / 2;
            int menuY = (this.field_22790 - 256) / 2;
            int rightPanelWidth = 125;
            int rightPanelX = menuX + 256 - rightPanelWidth - 4 - 32 + 3;
            int rightPanelY = menuY + 10 + 48;
            int scrollbarX = rightPanelX + rightPanelWidth + 32 + -40;
            int panelHeight = 125;
            float maxScroll = this.totalContentHeight - panelHeight;
            float scrollRatio = this.scrollAmount / maxScroll;
            int handleY = (int)((float)(rightPanelY + 10) + scrollRatio * 94.0f);
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + 16) && mouseY >= (double)handleY && mouseY <= (double)(handleY + 16)) {
                this.scrolling = true;
                return true;
            }
            int leftButtonRostX = (this.field_22789 - 256) / 2 + 47;
            int leftButtonRostY = (this.field_22790 - 256) / 2 + 120 + 14;
            if (mouseX >= (double)leftButtonRostX && mouseX <= (double)(leftButtonRostX + 53) && mouseY >= (double)leftButtonRostY && mouseY <= (double)(leftButtonRostY + 14)) {
                class_310.method_1551().field_1724.field_3944.method_45730("rost_menu");
                return true;
            }
            int leftButtonX = (this.field_22789 - 256) / 2 + 47;
            int leftButtonY = (this.field_22790 - 256) / 2 + 166;
            if (mouseX >= (double)leftButtonX && mouseX <= (double)(leftButtonX + 53) && mouseY >= (double)leftButtonY && mouseY <= (double)(leftButtonY + 14)) {
                class_310.method_1551().field_1724.field_3944.method_45730("player_inventory");
                return true;
            }
            int leftButtonSkillsX = (this.field_22789 - 256) / 2 + 47;
            int leftButtonSkillsY = (this.field_22790 - 256) / 2 + 136 + 14;
            if (mouseX >= (double)leftButtonSkillsX && mouseX <= (double)(leftButtonSkillsX + 53) && mouseY >= (double)leftButtonSkillsY && mouseY <= (double)(leftButtonSkillsY + 14)) {
                class_310.method_1551().field_1724.field_3944.method_45730("menu");
                return true;
            }
            if (mouseX >= (double)this.nameButtonX && mouseX <= (double)(this.nameButtonX + 10.0f) && mouseY >= (double)this.nameButtonY && mouseY <= (double)(this.nameButtonY + 10.0f)) {
                class_310.method_1551().field_1724.field_3944.method_45730("set name");
                this.closeMenuAndInventory();
                return true;
            }
            if (mouseX >= (double)this.genderButtonX && mouseX <= (double)(this.genderButtonX + 10.0f) && mouseY >= (double)this.genderButtonY && mouseY <= (double)(this.genderButtonY + 10.0f)) {
                class_310.method_1551().field_1724.field_3944.method_45730("set gender");
                this.closeMenuAndInventory();
                return true;
            }
            if (mouseX >= (double)this.descriptionButtonX && mouseX <= (double)(this.descriptionButtonX + 10.0f) && mouseY >= (double)this.descriptionButtonY && mouseY <= (double)(this.descriptionButtonY + 10.0f)) {
                class_310.method_1551().field_1724.field_3944.method_45730("set description");
                this.closeMenuAndInventory();
                return true;
            }
            if (mouseX >= (double)this.rumorsButtonX && mouseX <= (double)(this.rumorsButtonX + 10.0f) && mouseY >= (double)this.rumorsButtonY && mouseY <= (double)(this.rumorsButtonY + 10.0f)) {
                class_310.method_1551().field_1724.field_3944.method_45730("set rumors");
                this.closeMenuAndInventory();
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int menuY = (this.field_22790 - 256) / 2;
            int rightPanelY = menuY + 10 + 48;
            int panelHeight = 125;
            float maxScroll = this.totalContentHeight - panelHeight;
            float scrollRatio = (float)(mouseY - (double)rightPanelY - 10.0) / 94.0f;
            this.scrollAmount = Math.max(0.0f, Math.min(scrollRatio * maxScroll, maxScroll));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int menuX = (this.field_22789 - 256) / 2;
        int menuY = (this.field_22790 - 256) / 2;
        int rightPanelWidth = 125;
        int rightPanelX = menuX + 256 - rightPanelWidth - 4 - 32 + 3;
        int rightPanelY = menuY + 10 + 48;
        int panelHeight = 125;
        if (mouseX >= (double)rightPanelX && mouseX <= (double)(rightPanelX + rightPanelWidth) && mouseY >= (double)rightPanelY && mouseY <= (double)(rightPanelY + panelHeight)) {
            float maxScroll = this.totalContentHeight - panelHeight;
            this.scrollAmount = (float)((double)this.scrollAmount - amount * 10.0);
            this.scrollAmount = Math.max(0.0f, Math.min(this.scrollAmount, maxScroll));
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    private void drawEntity(int x, int y, int size, class_1657 entity) {
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_46416((float)x, (float)y, 1050.0f);
        matrixStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        matrixStack2.method_46416(0.0f, 0.0f, 1000.0f);
        matrixStack2.method_22905((float)size, (float)size, (float)size);
        float fixedBodyYaw = 10.0f;
        float fixedHeadYaw = -20.0f;
        float fixedPitch = 0.0f;
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateY((float)Math.toRadians(fixedBodyYaw));
        quaternionf.mul((Quaternionfc)quaternionf2);
        matrixStack2.method_22907(quaternionf);
        float originalBodyYaw = entity.field_6283;
        float originalYaw = entity.method_36454();
        float originalPitch = entity.method_36455();
        float originalPrevHeadYaw = entity.field_6259;
        float originalHeadYaw = entity.field_6241;
        entity.field_6283 = 180.0f + fixedBodyYaw;
        entity.method_36456(180.0f + fixedHeadYaw);
        entity.method_36457(fixedPitch);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, -1.35, -1.7, 0.0, 0.0f, 1.0f, matrixStack2, (class_4597)immediate, 0xF000F0));
        immediate.method_22993();
        entityRenderDispatcher.method_3948(true);
        entity.field_6283 = originalBodyYaw;
        entity.method_36456(originalYaw);
        entity.method_36457(originalPitch);
        entity.field_6259 = originalPrevHeadYaw;
        entity.field_6241 = originalHeadYaw;
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }
}

