/*
 * Decompiled with CFR 0.152.
 */
package ignis.gas.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import ignis.gas.client.GasClientMod;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class GasSmokeParticle
extends class_4003 {
    private final double spawnX;
    private final double spawnY;
    private final double spawnZ;
    private final float horizontalSpread;
    private final float verticalSpread;
    private final float speed;
    private final float maxScale;
    private boolean isAscending = false;
    public static double MAX_SPREAD_RADIUS = 20.0;
    public static double RENDER_DISTANCE = 256.0;
    public static final double MAX_PLAYER_DISTANCE = 32.0;

    protected GasSmokeParticle(class_638 world, double x, double y, double z, double vx, double vy, double vz, float scale, float red, float green, float blue, float maxAlpha, int duration, float horizontalSpread, float verticalSpread, float speed, class_4002 spriteProvider) {
        super(world, x, y, z, vx, vy, vz);
        int attempts;
        this.field_3862 = false;
        class_2338 pos = new class_2338((int)this.field_3874, (int)this.field_3854, (int)this.field_3871);
        class_2680 state = world.method_8320(pos);
        class_265 collisionShape = state.method_26220((class_1922)world, pos);
        int maxAttempts = 100;
        for (attempts = 0; !collisionShape.method_1110() && attempts < 100; ++attempts) {
            pos = new class_2338((int)x, (int)(y += 1.0), (int)z);
            state = world.method_8320(pos);
            collisionShape = state.method_26220((class_1922)world, pos);
        }
        if (attempts >= 100) {
            this.method_3085();
        }
        this.field_3854 = y;
        this.field_3838 = y;
        this.field_3852 = vx;
        this.field_3869 = vy;
        this.field_3850 = vz;
        this.maxScale = scale;
        this.field_17867 = 0.0f;
        this.field_3861 = red;
        this.field_3842 = green;
        this.field_3859 = blue;
        this.field_3841 = 0.5f;
        this.field_3847 = duration;
        this.field_3844 = 5.0E-5f;
        this.horizontalSpread = horizontalSpread;
        this.verticalSpread = verticalSpread;
        this.speed = speed;
        this.spawnX = x;
        this.spawnY = y;
        this.spawnZ = z;
        this.method_18142(spriteProvider);
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((int)770, (int)771);
        super.method_3074(vertexConsumer, camera, tickDelta);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.depthMask((boolean)true);
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public void method_3070() {
        class_2487 nbt;
        class_1799 mainHand;
        class_243 playerPos;
        class_243 particlePos;
        double dist;
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        ++this.field_3866;
        int fadeInTicks = 10;
        int fadeOutTicks = 20;
        int fullVisibilityEnd = this.field_3847 - fadeOutTicks;
        this.field_17867 = this.field_3866 <= fadeInTicks ? (float)this.field_3866 / (float)fadeInTicks * this.maxScale : this.maxScale;
        if (this.field_3866 > fullVisibilityEnd) {
            this.isAscending = true;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && (dist = (particlePos = new class_243(this.field_3874, this.field_3854, this.field_3871)).method_1022(playerPos = client.field_1724.method_19538())) > 32.0) {
            this.method_3085();
            return;
        }
        if (this.isAscending) {
            this.field_3869 = 0.01;
        } else {
            double distance = Math.sqrt(Math.pow(this.field_3874 - this.spawnX, 2.0) + Math.pow(this.field_3871 - this.spawnZ, 2.0));
            if (distance > MAX_SPREAD_RADIUS) {
                double directionX = (this.spawnX - this.field_3874) / distance;
                double directionZ = (this.spawnZ - this.field_3871) / distance;
                this.field_3852 = directionX * 0.01;
                this.field_3850 = directionZ * 0.01;
            } else {
                this.field_3852 += (Math.random() - 0.5) * 0.03;
                this.field_3850 += (Math.random() - 0.5) * 0.03;
                this.field_3869 += (Math.random() - 0.5) * 0.01;
                double maxSpeed = 0.05;
                double currentSpeed = Math.sqrt(this.field_3852 * this.field_3852 + this.field_3850 * this.field_3850);
                if (currentSpeed > maxSpeed) {
                    this.field_3852 = this.field_3852 / currentSpeed * maxSpeed;
                    this.field_3850 = this.field_3850 / currentSpeed * maxSpeed;
                }
                if (distance > MAX_SPREAD_RADIUS - 2.0) {
                    double slowdownFactor = 1.0 - (distance - (MAX_SPREAD_RADIUS - 2.0)) / 2.0;
                    this.field_3852 *= slowdownFactor;
                    this.field_3850 *= slowdownFactor;
                }
            }
        }
        boolean isRepelling = false;
        if (client.field_1724 != null && (mainHand = client.field_1724.method_6047()).method_7985() && (nbt = mainHand.method_7969()).method_10573("MMOITEMS_ITEM_ID", 8) && nbt.method_10558("MMOITEMS_ITEM_ID").equals("LAMP_SWAMP_IVENT")) {
            class_243 particlePos2 = new class_243(this.field_3874, this.field_3854, this.field_3871);
            class_243 playerPos2 = client.field_1724.method_19538();
            double dist2 = particlePos2.method_1022(playerPos2);
            if (dist2 < 5.0) {
                this.method_3085();
                return;
            }
            if (dist2 < 10.0 && dist2 > 0.1) {
                isRepelling = true;
                double force = 0.12 / dist2;
                double dx = (this.field_3874 - playerPos2.field_1352) / dist2;
                double dy = (this.field_3854 - playerPos2.field_1351) / dist2;
                double dz = (this.field_3871 - playerPos2.field_1350) / dist2;
                this.field_3852 += dx * force;
                this.field_3869 += dy * force;
                this.field_3850 += dz * force;
            }
        }
        if (this.isAscending && !isRepelling) {
            this.field_3852 = 0.0;
            this.field_3850 = 0.0;
        }
        this.moveWithCollision(this.field_3852, this.field_3869, this.field_3850);
        if (!this.isAscending && !isRepelling) {
            this.field_3869 *= 0.96;
        }
        if (this.field_3845) {
            this.field_3852 *= 0.9;
            this.field_3850 *= 0.9;
        }
        if (this.isAscending && this.field_3854 >= this.spawnY + 5.0) {
            this.method_3085();
        }
        if (this.field_3866 > this.field_3847 + 1000) {
            this.method_3085();
        }
    }

    private void moveWithCollision(double dx, double dy, double dz) {
        this.method_3069(dx, dy, dz);
        if (this.field_3845) {
            this.field_3852 *= 0.7;
            this.field_3850 *= 0.7;
        }
    }

    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 spriteProvider;

        public Factory(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public class_703 createParticle(class_2400 type, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new GasSmokeParticle(world, x, y, z, velocityX, velocityY, velocityZ, 3.0f, GasClientMod.currentRed, GasClientMod.currentGreen, GasClientMod.currentBlue, 0.6f, GasClientMod.currentDuration, 10.0f, 0.3f, 0.1f, this.spriteProvider);
        }
    }
}

