/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.util;

import com.votive.geckomythicclient.GeckoMythicClient;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ModelResourceValidator {
    private static final Map<String, Boolean> validationCache = new ConcurrentHashMap<String, Boolean>();

    public static boolean validateModelResources(String modelNamespace, String modelName) {
        class_2960 animationId;
        class_2960 textureId;
        String modelId = modelNamespace + ":" + modelName;
        Boolean cached = validationCache.get(modelId);
        if (cached != null) {
            return cached;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.method_1478() == null) {
            GeckoMythicClient.LOGGER.warn("Cannot validate resources: MinecraftClient or ResourceManager is null");
            return false;
        }
        boolean isValid = true;
        StringBuilder missingResources = new StringBuilder();
        class_2960 geoId = new class_2960(modelNamespace, "geo/entity/" + modelName + ".geo.json");
        if (!ModelResourceValidator.resourceExists(client, geoId)) {
            isValid = false;
            missingResources.append("\n  - ").append(geoId);
        }
        if (!ModelResourceValidator.resourceExists(client, textureId = new class_2960(modelNamespace, "textures/entity/" + modelName + ".png"))) {
            isValid = false;
            missingResources.append("\n  - ").append(textureId);
        }
        if (!ModelResourceValidator.resourceExists(client, animationId = new class_2960(modelNamespace, "animations/entity/" + modelName + ".animation.json"))) {
            isValid = false;
            missingResources.append("\n  - ").append(animationId);
        }
        validationCache.put(modelId, isValid);
        if (!isValid) {
            GeckoMythicClient.LOGGER.error("Model '{}' is missing required resources:{}\nPlease reinstall the resource pack through the launcher!", (Object)modelId, (Object)missingResources);
        } else {
            GeckoMythicClient.LOGGER.debug("Model '{}' resources validated successfully", (Object)modelId);
        }
        return isValid;
    }

    private static boolean resourceExists(class_310 client, class_2960 identifier) {
        try {
            Optional resource = client.method_1478().method_14486(identifier);
            return resource.isPresent();
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.debug("Resource check failed for {}: {}", (Object)identifier, (Object)e.getMessage());
            return false;
        }
    }

    public static void clearCache() {
        validationCache.clear();
        GeckoMythicClient.LOGGER.debug("Model validation cache cleared");
    }
}

