/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.renderer;

import com.votive.geckomythicclient.GeckoMythicClient;
import com.votive.geckomythicclient.client.GeckoEntityWrapper;
import com.votive.geckomythicclient.hitbox.HitboxData;
import com.votive.geckomythicclient.hitbox.HitboxParser;
import com.votive.geckomythicclient.renderer.GeckoEntityGeoModel;
import java.lang.reflect.Field;
import java.util.HashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;

public class ReplacedEntityRenderer
extends GeoReplacedEntityRenderer<class_1309, GeckoEntityWrapper> {
    private final String modelNamespace;
    private final String modelName;
    private volatile GeckoEntityWrapper currentWrapper;
    private float customShadowRadius = 0.5f;
    private static Field wrappedEntityField;
    private static Field animationsField;
    private static Field triggeredField;
    private static Field customIdleField;
    private static Field customWalkField;
    private static Field isCurrentlyWalkingField;
    private static volatile boolean fieldsInitialized;

    public ReplacedEntityRenderer(class_5617.class_5618 renderManager, String modelNamespace, String modelName) {
        super(renderManager, (GeoModel)new GeckoEntityGeoModel(modelNamespace, modelName), (GeoAnimatable)new GeckoEntityWrapper(null, modelNamespace, modelName, new HashMap<String, String>()));
        this.modelNamespace = modelNamespace;
        this.modelName = modelName;
        HitboxData hitboxData = HitboxParser.parseHitboxes(modelNamespace, modelName);
        if (hitboxData != null && hitboxData.hasHitboxes()) {
            float maxWidth = 0.0f;
            for (HitboxData.HitboxCube cube : hitboxData.getCubes()) {
                float width = (float)Math.max(Math.abs(cube.size.field_1352), Math.abs(cube.size.field_1350));
                maxWidth = Math.max(maxWidth, width);
            }
            this.customShadowRadius = maxWidth / 2.0f;
            GeckoMythicClient.LOGGER.info("Shadow radius for {}: {}", (Object)modelName, (Object)Float.valueOf(this.customShadowRadius));
        }
    }

    private static synchronized void initializeFields() {
        if (fieldsInitialized) {
            return;
        }
        try {
            wrappedEntityField = GeckoEntityWrapper.class.getDeclaredField("wrappedEntity");
            wrappedEntityField.setAccessible(true);
            animationsField = GeckoEntityWrapper.class.getDeclaredField("animationMappings");
            animationsField.setAccessible(true);
            triggeredField = GeckoEntityWrapper.class.getDeclaredField("triggeredAnimation");
            triggeredField.setAccessible(true);
            customIdleField = GeckoEntityWrapper.class.getDeclaredField("customIdleAnimation");
            customIdleField.setAccessible(true);
            customWalkField = GeckoEntityWrapper.class.getDeclaredField("customWalkAnimation");
            customWalkField.setAccessible(true);
            isCurrentlyWalkingField = GeckoEntityWrapper.class.getDeclaredField("isCurrentlyWalking");
            isCurrentlyWalkingField.setAccessible(true);
            fieldsInitialized = true;
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.error("Failed to initialize reflection fields", (Throwable)e);
        }
    }

    public synchronized void setCurrentWrapper(GeckoEntityWrapper wrapper) {
        this.currentWrapper = wrapper;
        if (wrapper != null) {
            try {
                if (!fieldsInitialized) {
                    ReplacedEntityRenderer.initializeFields();
                }
                if (!fieldsInitialized) {
                    return;
                }
                GeckoEntityWrapper dummyWrapper = (GeckoEntityWrapper)super.getAnimatable();
                wrappedEntityField.set(dummyWrapper, wrapper.getWrappedEntity());
                animationsField.set(dummyWrapper, wrapper.getAnimationMappings());
                triggeredField.set(dummyWrapper, triggeredField.get(wrapper));
                customIdleField.set(dummyWrapper, customIdleField.get(wrapper));
                customWalkField.set(dummyWrapper, customWalkField.get(wrapper));
                isCurrentlyWalkingField.set(dummyWrapper, isCurrentlyWalkingField.get(wrapper));
            }
            catch (Exception e) {
                GeckoMythicClient.LOGGER.error("Failed to update dummy wrapper", (Throwable)e);
            }
        }
    }

    public synchronized void syncStateFromDummy(GeckoEntityWrapper wrapper) {
        if (wrapper == null || !fieldsInitialized) {
            return;
        }
        try {
            GeckoEntityWrapper dummyWrapper = (GeckoEntityWrapper)super.getAnimatable();
            isCurrentlyWalkingField.set(wrapper, isCurrentlyWalkingField.get(dummyWrapper));
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.error("Failed to sync state from dummy", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(class_1309 entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        GeckoEntityGeoModel.setCurrentEntity(entity);
        try {
            this.field_4673 = this.customShadowRadius;
            if (entity instanceof class_1657 && entity.method_5715()) {
                poseStack.method_22903();
                poseStack.method_22904(0.0, 0.125, 0.0);
                try {
                    this.renderSafely(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
                }
                finally {
                    poseStack.method_22909();
                }
            } else {
                this.renderSafely(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
            }
            if (this.currentWrapper != null) {
                this.syncStateFromDummy(this.currentWrapper);
            }
        }
        finally {
            GeckoEntityGeoModel.clearCurrentEntity();
        }
    }

    private void renderSafely(class_1309 entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        try {
            super.method_3936((class_1297)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.error("Failed to render model {}:{} - resources may be missing", new Object[]{this.modelNamespace, this.modelName, e});
        }
    }

    static {
        fieldsInitialized = false;
    }
}

