/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.renderer;

import com.votive.geckomythicclient.GeckoMythicClient;
import com.votive.geckomythicclient.client.GeckoEntityWrapper;
import com.votive.geckomythicclient.renderer.ReplacedEntityRenderer;
import com.votive.geckomythicclient.util.ModelResourceValidator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_898;
import org.joml.Matrix4f;

public class GeckoEntityRenderer {
    private static final int MAX_RENDERER_CACHE_SIZE = 256;
    private static final Map<String, ReplacedEntityRenderer> rendererCache = new ConcurrentHashMap<String, ReplacedEntityRenderer>();

    public static void clearCache() {
        rendererCache.clear();
    }

    public static int getCacheSize() {
        return rendererCache.size();
    }

    public static void render(GeckoEntityWrapper wrapper, class_1309 actualEntity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (wrapper == null || actualEntity == null) {
            GeckoMythicClient.LOGGER.warn("Attempted to render null wrapper or entity");
            return;
        }
        try {
            wrapper.updateEntity(actualEntity);
            String modelId = wrapper.getModelIdentifier();
            if (!ModelResourceValidator.validateModelResources(wrapper.getModelNamespace(), wrapper.getModelName())) {
                GeckoEntityRenderer.renderMissingResourcesText(actualEntity, matrices, vertexConsumers, light);
                return;
            }
            ReplacedEntityRenderer geoRenderer = rendererCache.get(modelId);
            if (geoRenderer == null) {
                if (rendererCache.size() >= 256) {
                    GeckoMythicClient.LOGGER.warn("Renderer cache size limit reached ({}), clearing oldest entries", (Object)256);
                    Iterator<String> iterator = rendererCache.keySet().iterator();
                    for (int toRemove = 128; iterator.hasNext() && toRemove > 0; --toRemove) {
                        iterator.next();
                        iterator.remove();
                    }
                }
                try {
                    class_898 dispatcher = class_310.method_1551().method_1561();
                    class_5617.class_5618 ctx = new class_5617.class_5618(dispatcher, class_310.method_1551().method_1480(), class_310.method_1551().method_1541(), dispatcher.method_43336(), class_310.method_1551().method_1478(), class_310.method_1551().method_31974(), class_310.method_1551().field_1772);
                    ReplacedEntityRenderer newRenderer = new ReplacedEntityRenderer(ctx, wrapper.getModelNamespace(), wrapper.getModelName());
                    geoRenderer = rendererCache.putIfAbsent(modelId, newRenderer);
                    if (geoRenderer == null) {
                        geoRenderer = newRenderer;
                        GeckoMythicClient.LOGGER.debug("Created new renderer for model: {} (cache size: {})", (Object)modelId, (Object)rendererCache.size());
                    } else {
                        GeckoMythicClient.LOGGER.debug("Using existing renderer for model: {}", (Object)modelId);
                    }
                }
                catch (Exception e) {
                    GeckoMythicClient.LOGGER.error("Failed to create renderer for model: {}", (Object)modelId, (Object)e);
                    return;
                }
            }
            geoRenderer.setCurrentWrapper(wrapper);
            geoRenderer.render(actualEntity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.error("Error rendering GeckoLib model: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void renderMissingResourcesText(class_1309 entity, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        class_5250 text = class_2561.method_43470((String)"\u041f\u0435\u0440\u0435\u0437\u0430\u0439\u0434\u0438 \u0432 \u043b\u0430\u0443\u043d\u0447\u0435\u0440!");
        matrices.method_22903();
        matrices.method_22904(0.0, (double)entity.method_17682() + 0.5, 0.0);
        matrices.method_22907(client.method_1561().method_24197());
        float scale = 0.025f;
        matrices.method_22905(-scale, -scale, scale);
        Matrix4f matrix = matrices.method_23760().method_23761();
        float textWidth = textRenderer.method_27525((class_5348)text);
        float x = -textWidth / 2.0f;
        int backgroundColor = Integer.MIN_VALUE;
        int textColor = -256;
        textRenderer.method_30882((class_2561)text, x, 0.0f, textColor, false, matrix, vertexConsumers, false, backgroundColor, light);
        matrices.method_22909();
    }
}

