/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.renderer;

import com.votive.geckomythicclient.GeckoMythicClient;
import com.votive.geckomythicclient.client.GeckoEntityWrapper;
import com.votive.geckomythicclient.emotecraft.EmoteCraftBridge;
import java.util.HashMap;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class GeckoEntityGeoModel
extends GeoModel<GeckoEntityWrapper> {
    private final String modelNamespace;
    private final String modelName;
    private boolean bonesLogged = false;
    private static final ThreadLocal<class_1309> currentRenderingEntity = new ThreadLocal();
    private float previousHeadYaw = 0.0f;
    private float previousHeadPitch = 0.0f;

    public GeckoEntityGeoModel(String modelNamespace, String modelName) {
        this.modelNamespace = modelNamespace;
        this.modelName = modelName;
    }

    public static void setCurrentEntity(class_1309 entity) {
        currentRenderingEntity.set(entity);
    }

    public static void clearCurrentEntity() {
        currentRenderingEntity.remove();
    }

    public class_2960 getModelResource(GeckoEntityWrapper animatable) {
        return new class_2960(this.modelNamespace, "geo/entity/" + this.modelName + ".geo.json");
    }

    public class_2960 getTextureResource(GeckoEntityWrapper animatable) {
        return new class_2960(this.modelNamespace, "textures/entity/" + this.modelName + ".png");
    }

    public class_2960 getAnimationResource(GeckoEntityWrapper animatable) {
        return new class_2960(this.modelNamespace, "animations/entity/" + this.modelName + ".animation.json");
    }

    public void setCustomAnimations(GeckoEntityWrapper animatable, long instanceId, AnimationState<GeckoEntityWrapper> animationState) {
        CoreGeoBone head;
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        class_1309 entity = animatable.getWrappedEntity();
        if (entity == null) {
            entity = currentRenderingEntity.get();
        }
        if (entity == null) {
            if (!this.bonesLogged) {
                this.bonesLogged = true;
                GeckoMythicClient.LOGGER.warn("setCustomAnimations: entity is NULL even from ThreadLocal!");
            }
            return;
        }
        HashMap<String, CoreGeoBone> boneMap = new HashMap<String, CoreGeoBone>();
        for (CoreGeoBone bone : this.getAnimationProcessor().getRegisteredBones()) {
            boneMap.put(bone.getName(), bone);
            if (!bone.getName().toLowerCase().startsWith("hitbox")) continue;
            bone.setHidden(true);
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            try {
                float tickDelta = animationState != null ? animationState.getPartialTick() : 0.0f;
                EmoteCraftBridge.applyEmoteCraftAnimations(player, boneMap, tickDelta);
            }
            catch (Exception e) {
                GeckoMythicClient.LOGGER.error("Failed to apply EmoteCraft animations for player " + player.method_5477().getString(), (Throwable)e);
            }
        }
        if ((head = this.getAnimationProcessor().getBone("bipedHead")) == null) {
            head = this.getAnimationProcessor().getBone("head");
        }
        if (head == null) {
            head = this.getAnimationProcessor().getBone("Head");
        }
        if (head != null) {
            float netHeadYaw;
            boolean isClientPlayer;
            class_310 client = class_310.method_1551();
            boolean bl = isClientPlayer = entity instanceof class_1657 && client.field_1724 != null && entity.method_5667().equals(client.field_1724.method_5667());
            if (isClientPlayer) {
                class_243 playerPos;
                class_243 cameraPos = client.field_1773.method_19418().method_19326();
                double cameraDistance = cameraPos.method_1022(playerPos = entity.method_19538().method_1031(0.0, entity.method_23320() - entity.method_23318(), 0.0));
                if (cameraDistance < 0.5) {
                    head.setHidden(true);
                    return;
                }
                head.setHidden(false);
            } else {
                head.setHidden(false);
            }
            float headPitch = entity.method_36455();
            for (netHeadYaw = entity.field_6241 - entity.field_6283; netHeadYaw > 180.0f; netHeadYaw -= 360.0f) {
            }
            while (netHeadYaw < -180.0f) {
                netHeadYaw += 360.0f;
            }
            netHeadYaw = class_3532.method_15363((float)netHeadYaw, (float)-75.0f, (float)75.0f);
            headPitch = class_3532.method_15363((float)headPitch, (float)-45.0f, (float)45.0f);
            float smoothingFactor = 0.25f;
            float smoothedYaw = class_3532.method_16439((float)smoothingFactor, (float)this.previousHeadYaw, (float)netHeadYaw);
            float smoothedPitch = class_3532.method_16439((float)smoothingFactor, (float)this.previousHeadPitch, (float)headPitch);
            this.previousHeadYaw = smoothedYaw;
            this.previousHeadPitch = smoothedPitch;
            head.setRotY(-smoothedYaw * ((float)Math.PI / 180));
            head.setRotX(-smoothedPitch * ((float)Math.PI / 180));
        }
    }
}

