/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.packets;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.UUID;

public class RequestModelPacket {
    private static final Gson GSON = new Gson();
    private final String packetType = "REQUEST_MODEL";
    private final UUID entityUUID;

    public RequestModelPacket(UUID entityUUID) {
        this.entityUUID = entityUUID;
    }

    public UUID getEntityUUID() {
        return this.entityUUID;
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static RequestModelPacket fromJson(String json) {
        try {
            JsonObject obj = (JsonObject)GSON.fromJson(json, JsonObject.class);
            if (!obj.has("entityUUID")) {
                return null;
            }
            UUID entityUUID = UUID.fromString(obj.get("entityUUID").getAsString());
            return new RequestModelPacket(entityUUID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isValid() {
        return this.entityUUID != null;
    }

    public String toString() {
        return String.format("RequestModelPacket{entity=%s}", this.entityUUID);
    }
}

