/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.votive.geckomythicclient.mount.MountBoneData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_243;

public class MountDataPacket {
    private static final Gson GSON = new GsonBuilder().create();
    private final String packetType = "MOUNT_DATA";
    private String entityUUID;
    private Map<String, Object> mountData;

    private MountDataPacket() {
    }

    public static MountDataPacket fromJson(String json) {
        return (MountDataPacket)GSON.fromJson(json, MountDataPacket.class);
    }

    public UUID getEntityUUID() {
        return UUID.fromString(this.entityUUID);
    }

    public Map<String, Object> getMountData() {
        return new HashMap<String, Object>(this.mountData);
    }

    public MountBoneData toMountBoneData(String modelIdentifier) {
        MountBoneData data = new MountBoneData(modelIdentifier);
        if (this.mountData == null || this.mountData.isEmpty()) {
            return null;
        }
        if (this.mountData.containsKey("driver")) {
            Map driverPos = (Map)this.mountData.get("driver");
            class_243 driverVec = new class_243(((Double)driverPos.get("x")).doubleValue(), ((Double)driverPos.get("y")).doubleValue(), ((Double)driverPos.get("z")).doubleValue());
            data.setDriverBonePosition(driverVec);
        }
        if (this.mountData.containsKey("passengers")) {
            Map passengers = (Map)this.mountData.get("passengers");
            for (Map.Entry entry : passengers.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("pass_")) continue;
                try {
                    int seatNumber = Integer.parseInt(key.substring(5));
                    Map pos = (Map)entry.getValue();
                    class_243 vec = new class_243(((Double)pos.get("x")).doubleValue(), ((Double)pos.get("y")).doubleValue(), ((Double)pos.get("z")).doubleValue());
                    data.addPassengerBonePosition(seatNumber, vec);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return data.hasDriverBone() || data.hasPassengerBones() ? data : null;
    }

    public boolean hasMountData() {
        return this.mountData != null && !this.mountData.isEmpty();
    }

    public String toString() {
        return "MountDataPacket{entityUUID=" + this.entityUUID + ", hasMountData=" + this.hasMountData() + "}";
    }

    public boolean isValid() {
        try {
            UUID.fromString(this.entityUUID);
            return this.mountData != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

