/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.votive.geckomythicclient.GeckoMythicClient;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EntityModelPacket {
    private static final Gson GSON = new GsonBuilder().create();
    private String entityUUID;
    private String modelNamespace;
    private String modelName;
    private Map<String, String> animationMappings;

    private EntityModelPacket() {
    }

    public static EntityModelPacket fromJson(String json) {
        try {
            return (EntityModelPacket)GSON.fromJson(json, EntityModelPacket.class);
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.error("Failed to parse EntityModelPacket from JSON: {}", (Object)json, (Object)e);
            return null;
        }
    }

    public UUID getEntityUUID() {
        try {
            return UUID.fromString(this.entityUUID);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getModelNamespace() {
        return this.modelNamespace;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelIdentifier() {
        return this.modelNamespace + ":" + this.modelName;
    }

    public Map<String, String> getAnimationMappings() {
        return this.animationMappings != null ? new HashMap<String, String>(this.animationMappings) : new HashMap();
    }

    public boolean isValid() {
        try {
            return this.entityUUID != null && UUID.fromString(this.entityUUID) != null && this.modelNamespace != null && !this.modelNamespace.isEmpty() && this.modelName != null && !this.modelName.isEmpty();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

